/*
 * Hashtable.java:  a java.util.Hashtable with set comparsion
 * for the Nomencurator, a Nomenclature Heuristic Model.
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: Hashtable.java,v 1.1 2002/09/27 06:11:48 nozomi Exp $
 * $Log: Hashtable.java,v $
 * Revision 1.1  2002/09/27 06:11:48  nozomi
 * initial import into CVS repository
 *
 */
package org.nomencurator.util;

import java.util.Enumeration;

/**
 * A customized Hashtable with set comparison methods
 *
 * @version 	27 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public class Hashtable
    extends java.util.Hashtable
{
    /**
     * Constructs an empty <CODE>Hashtble</CODE> with specified
     * <CODE>initialCapacity</CODE> and <CODE>loadFactor</CODE>.
     *
     * @param initialCapacity initial capacity of the <CODE>Hashtable</CODE>
     * @param loadFactor load factor of the <CODE>Hashtable</CODE>
     *
     * @exception IllegalArgumentException if <CODE>initialCapacity</CODE> less than zero
     * or <CODE>loadFactor</CODE> is non positive value
     */
    public Hashtable(int initialCapacity,
		     float loadFactor)
    {
	super(initialCapacity, loadFactor);
    }

    /**
     * Constructs an empty <CODE>Hashtble</CODE> with specified
     * <CODE>initialCapacity</CODE> and default load factor (0.75)
     *
     * @param initialCapacity initial capacity of the <CODE>Hashtable</CODE>
     *
     * @exception IllegalArgumentException if <CODE>initialCapacity</CODE> less than zero
     */
    public Hashtable(int initialCapacity)
    {
	super(initialCapacity);
    }

    /**
     * Constructs an empty <CODE>Hashtble</CODE> with default
     * initial capacity (11) and default load factor (0.75)
     *
     */
    public Hashtable()
    {
	super();
    }

    /**
     * Returns true if this <CODE>Hashtable</CODE> and <CODE>h</CODE>
     * are disjoint each other.
     *
     * @param h <CODE>java.util.Hashtable</CODE> to be examined against to
     * this <CODE>Hashtable</CODE>
     *
     * @return true if this <CODE>Hashtable</CODE> and <CODE>h</CODE>
     * are disjoint each other
     */
    public boolean isDisjoint(java.util.Hashtable h)
    {
	java.util.Hashtable tester = (h.size() < size())? h:this;
	java.util.Hashtable testant = (h.size() < size())? this:h;
	Enumeration key = tester.keys();
	boolean disjoint = true;
	while(disjoint && key.hasMoreElements()) {
	    if(testant.get(key.nextElement()) != null)
		disjoint = false;
	}
	
	return disjoint;
    }

    /**
     * Returns true if this <CODE>Hashtable</CODE> has intersection with
     * with <CODE>h</CODE>
     *
     * @param h <CODE>java.util.Hashtable</CODE> to be examined against to
     * this <CODE>Hashtable</CODE>
     *
     * @return true if this <CODE>Hashtable</CODE> has an intersection
     * with <CODE>h</CODE>
     */
    public boolean hasIntersection(java.util.Hashtable h)
    {
	return !isDisjoint(h);
    }

    /**
     * Return true if this <CODE>Hashtable</CODE> contains
     * at least one key which is not contained in <COCE>h</CODE>
     *
     * @param h <CODE>java.util.Hashtable</CODE> to be examined against to
     * this <CODE>Hashtable</CODE>
     *
     * @return true if this <CODE>Hashtable</CODE> contains key which is
     * not contained in <CODE>h</CODE>
     */
    public boolean hasOtherThan(java.util.Hashtable h)
    {
	if(size() > h.size())
	    return true;

	boolean otherThan = false;
	Enumeration key = keys();
	while(!otherThan && key.hasMoreElements()) {
	    if(h.get(key.nextElement()) == null)
		otherThan = true;
	}

	return otherThan;
    }

    /**
     * Returns true if this <CODE>Hashtable</CODE> contains <CODE>h</CODE>.
     *
     * @param h <CODE>java.util.Hashtable</CODE> to be examined against to
     * this <CODE>Hashtable</CODE>
     *
     * @return true if this <CODE>Hashtable</CODE> contains <CODE>h</CODE>
     */
    public boolean includes(java.util.Hashtable h)
    {
	if(h.size() > size())
	    return false;

	boolean includes = true;
	Enumeration key = h.keys();
	while(includes && key.hasMoreElements()) {
	    if(get(key.nextElement()) == null)
		includes = false;
	}

	return includes;
    }

    /**
     * Returns true if this <CODE>Hashtable</CODE> is equlvalent to <CODE>h</CODE>,
     * i.e. they contain eatch other
     *
     * @param h <CODE>java.util.Hashtable</CODE> to be examined against to
     * this <CODE>Hashtable</CODE>
     *
     * @return true if this <CODE>Hashtable</CODE> is equivalent to <CODE>h</CODE>
     */
    public boolean equals(Hashtable h)
    {
	return includes(h) && h.includes(this);
    }
}
