/*
 * Util.java: 
 *
 * Copyright (c) 2002 Hiroyuki Okawa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: Util.java,v 1.15 2002/09/02 08:13:18 t.okada Exp $
 * $Log: Util.java,v $
 * Revision 1.15  2002/09/02 08:13:18  t.okada
 * remove multibyte character
 *
 * Revision 1.14  2002/05/10 14:43:09  ryo
 * add underscore to the character which is not converted
 *
 * Revision 1.13  2002/05/08 13:12:59  ryo
 * modify specification of convertStringToHex() and convertHexToString() and add isNotConvertChar()
 *
 * Revision 1.12  2002/04/19 21:49:32  nozomi
 * change in file name encoding
 *
 * Revision 1.11  2002/04/16 23:43:52  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.10  2002/04/16 03:53:38  nozomi
 * migration to NameUsage from NameRecord
 *
 * Revision 1.9  2002/03/29 12:47:32  ryo
 * use StringBuffer to join strings.
 *
 * Revision 1.8  2002/03/28 06:33:51  okawa
 * add copyright
 *
 * Revision 1.7  2002/03/11 11:58:55  ryo
 * add convertStringToHex() and convertHexToString()
 *
 * Revision 1.6  2002/03/08 13:55:35  okawa
 * add makeNameTreeModel()
 *
 * Revision 1.5  2002/03/06 13:24:21  ryo
 * modify a bug in addChildren()
 *
 * Revision 1.4  2002/02/27 09:50:16  okawa
 * add addAllToVector()
 *
 * Revision 1.3  2002/02/26 06:01:57  okawa
 * modify a bug in removeCharacter()
 *
 * Revision 1.2  2002/02/26 02:15:52  okawa
 * add removeCharacter()
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 *
 */

package org.nomencurator.util;

import org.nomencurator.awt.tree.TextTreeModel;
import org.nomencurator.awt.model.NameUsageTreeNode;
import org.nomencurator.awt.tree.DefaultMutableTreeNode;
import org.nomencurator.editor.model.NameUsageEditModel;
import org.nomencurator.util.tree.DefaultTreeModel;
import org.nomencurator.util.tree.TreePath;
import org.nomencurator.editor.model.NameTreeModel;
import org.nomencurator.editor.model.NameUsageNode;
import org.nomencurator.NameUsage;

import java.util.Vector;
import java.util.Enumeration;

public class Util
{
	/**
	 * make TextTreeModel object from the NameUsage tree node list
	 * @param  Vector<NameUsageTreeNode> tree node object list
	 * @return TextTreeModel tree model
	 */
	public static TextTreeModel makeTreeModel(Vector v) {

	    if(v.size() == 0) return null;

	    NameUsageTreeNode node = (NameUsageTreeNode)v.elementAt(0);

        NameUsageTreeNode root = null;
	    while(true) {
            NameUsageTreeNode parent = getTreeNode(v, node.getHigher());
            if(parent == null) {
                root = node;
                break;
            }
            node = parent;
        }

//        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(root.getName());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(root);
        addChildren(v, root, rootNode);

	    TextTreeModel textTreeModel = new TextTreeModel(rootNode);
	    DefaultTreeModel treeModel = (DefaultTreeModel)(textTreeModel.getTreeModel());
	    org.nomencurator.util.tree.TreeNode[] treeNodes = treeModel.getPathToRoot(rootNode);
	    textTreeModel.setExpandedState(new TreePath(treeNodes), true);
        return textTreeModel;
    }

	/**
	 * make TextTreeModel object from the NameUsage tree node list
	 * @param  Vector<NameUsageTreeNode> tree node object list
	 * @param  NameUsageTreeNode parent tree node object
	 * @param  DefaultMutableTreeNode parent gui tree node object
	 */
	private static void addChildren(Vector v, NameUsageTreeNode node, DefaultMutableTreeNode rootNode) {
        Vector children = node.getLower();
        if(children == null || children.size() == 0) return;

        for (Enumeration e = children.elements() ; e.hasMoreElements() ;) {
            NameUsageTreeNode child = getTreeNode(v, (String)e.nextElement());
            if (child == null) continue;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child.getName());
            rootNode.add(childNode);
            addChildren(v, child, childNode);
        }
        return;
    }

	/**
	 * make TextTreeModel object from the NameUsage tree node list
	 * @param  Vector<NameUsageTreeNode> tree node object list
	 * @param  String target object ID
	 * @return NameUsageTreeNode tree node
	 */
	private static NameUsageTreeNode getTreeNode(Vector v, String oid) {

        for (Enumeration e = v.elements() ; e.hasMoreElements() ;) {
            NameUsageTreeNode node = (NameUsageTreeNode)e.nextElement();
            if(node.getObjectId().equals(oid)) {
                return node;
            }
        }
        return null;
    }

	/**
	 * make NameTreeModel object from the NameUsageEditModel node list
	 * @param  NameUsageEditModel
	 * @return NameTreeModel
	 */
	public static NameTreeModel makeNameTreeModel(NameUsageEditModel model) {
//System.out.println("[Util::makeNameTreeModel] model:"+model);
        NameUsageNode nameUsageNode = new NameUsageNode(model);
        addLowerNameNodes(nameUsageNode, model.getNameUsage());

	    NameTreeModel nameTreeModel = new NameTreeModel(nameUsageNode);

	    DefaultTreeModel treeModel = (DefaultTreeModel)(nameTreeModel.getTreeModel());
	    org.nomencurator.util.tree.TreeNode[] treeNodes = treeModel.getPathToRoot(nameUsageNode);
	    nameTreeModel.setExpandedState(new TreePath(treeNodes), true);

        return nameTreeModel;
    }
    
	private static void addLowerNameNodes(NameUsageNode node, NameUsage nameUsage) {
        Vector lowerList = nameUsage.getLowerTaxa();
        if(lowerList == null || lowerList.size() == 0) return;

        for (Enumeration e = lowerList.elements() ; e.hasMoreElements() ;) {
            NameUsage lowerNameUsage = (NameUsage)e.nextElement();
            NameUsageNode lowerNode = new NameUsageNode(new NameUsageEditModel(lowerNameUsage));
//System.out.println("[Util::addLowerNameNodes] add lowerNode:"+lowerNameUsage);
            node.add(lowerNode);
            addLowerNameNodes(lowerNode, lowerNameUsage);
        }
        return;
    }

	/**
	 * remove a special character from the string
	 * @param  String 
	 * @param  character to be removed
	 * @return String removed string
	 */
	public static String removeCharacter(String str, char ch) {
	    StringBuffer sb = new StringBuffer();
	    
	    for(int i = 0; i < str.length(); i++) {
	        char c = str.charAt(i);
	        if(c != ch) sb.append(c);
	    }
	    return sb.toString();
	}

	/**
	 * add all Vector elements to the other Vector object
	 * @param  Vector 
	 * @param  Vector
	 * @return Vector 
	 */
    public static Vector addAllToVector(Vector v1, Vector v2) {
        for (Enumeration e = v2.elements(); e.hasMoreElements();) {
            v1.addElement(e.nextElement());
        }
        return v1;
    }

	/**
	 * convert string to hex code.
	 */
	public static String convertStringToHex(String str) {
		StringBuffer hexstring = new StringBuffer();
		char[] ch = str.toCharArray();
		for (int i=0; i<ch.length; i++) {
			if (isNotConvertChar(ch[i])) {
				hexstring.append(ch[i]);
				if (ch[i] == 'x')
					hexstring.append('x');
			} else {
				String code = Integer.toHexString((int) ch[i]);
				hexstring.append('x');
				hexstring.append((code.length() == 2) ? "00" + code : code);
			}
		}
		return hexstring.toString();
	}

	/**
	 * convert hex code to string.
	 */
	public static String convertHexToString(String hexString) {
		StringBuffer string = new StringBuffer();
		char[] ch = hexString.toCharArray();
		int i = 0;
		while (i < ch.length) {
			if (isNotConvertChar(ch[i]) && ch[i] != 'x') {
				string.append(ch[i]);
				i++;
			} else if (ch[i] == 'x' && ch[i+1] == 'x') {
				string.append(ch[i]);
				i += 2;
			} else {
				StringBuffer buf = new StringBuffer();
				buf.append(ch[i+1]);
				buf.append(ch[i+2]);
				buf.append(ch[i+3]);
				buf.append(ch[i+4]);
				string.append((char)Integer.parseInt(buf.toString(), 16));
				i += 5;
			}
		}
		return string.toString();
	}
	
	/**
	 * 
	 */
	private static boolean isNotConvertChar(char c) {
		return (('a' <= c && c <= 'z')
				|| ('A' <= c && c <= 'Z')
				|| ('0' <= c && c <= '9') || c == '_');
	}

}
