/*
 *
 * TreeModel.java:  TreeModel to replace javax.swing.tree.TreeModel
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: TreeModel.java,v 1.1.1.1 2002/01/16 12:33:33 ryo Exp $
 *	$Log: TreeModel.java,v $
 *	Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 *	initial import into CVS
 *	
 *	
 *
 */

package org.nomencurator.util.tree;

import org.nomencurator.util.tree.event.TreeModelListener;

public interface TreeModel
{
    /**
     * Add a <code>TreeModelListener</code> given by <code>listener</code> to the listener list.
     *
     * @param   listener a TreeModelListener
     */
    public void addTreeModelListener(TreeModelListener listener);

    /**
     * Returns child of <I>parent</I> at <I>index</I>.  The <I>parent</I> must be 
     * a node of the tree.  The method does not return null where given <I>index</I>
     * is valid index of given <I>parent</I>, i.e. <I>index</I> >= 0 && <I>index</I> < getChildCount(<I>parent</I>).
     *
     * @param   parent  a node in the tree obtained from this data source
     * @return  the child of <I>parent</I> at index <I>index</I>
     */
    public Object getChild(Object parent, int index);

    /**
     * Returns number of chaild nodes of given <I>parent</I>.
     * It return 0 where the <I>parent</I> is a leaf or <I>parent</I> does not have a child node.
     * The <I>parent</I> must be a node obtaind from the tree.
     *
     * @param   parent  a node in the tree obtained from this tree.
     * @return  number of child nodes of <I>parent</I>
     */
    public int getChildCount(Object parent);

    /**
     * Returns index of given <I>child</I> as child of <I>parent</I>.
     *
     */
    public int getIndexOfChild(Object parent, Object child); 

    /**
     * Returns root node of the tree.  It returns null only if the tree does not have node.
     *
     */
    public Object getRoot();
      
    /**
     * Returns true if given <I>node</I> is a leaf of the tree.
     */
    public boolean isLeaf(Object node);

    /**
     */
    public void removeTreeModelListener(TreeModelListener listener) ;

    /**
     */
    public void valueForPathChanged(TreePath path, Object newValue); 
}
