/*
 * TreeNode.java:  TreeNode to replace javax.swing.tree.TreeNode
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TreeNode.java,v 1.5 2002/06/09 12:50:14 nozomi Exp $
 * $Log: TreeNode.java,v $
 * Revision 1.5  2002/06/09 12:50:14  nozomi
 * change TreeModelEvent handling
 *
 * Revision 1.4  2002/06/03 01:26:19  nozomi
 * add description of API
 *	
 * Revision 1.3  2002/03/10 06:56:52  nozomi
 * modify comments
 *	
 * Revision 1.2  2002/03/08 23:03:14  nozomi
 * extends TreeModelListener and it also accept listeners
 *	
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.util.tree;

import java.util.Enumeration;

import org.nomencurator.util.tree.event.TreeModelListener;

/**
 * Interface of node in a tree.
 * It is upper compatible with <CODE>TreeNode</CODE> in Swing;
 * it extends <CODE>TreeModelListener</CODE> to transfer
 * <CODE>TextModelEvent</CODE>
 *
 * @version 	09 June 2002
 * @author 	Nozomi `James' Ytow
 */
public interface TreeNode
    //    extends TreeModelListener
{
    /**
     * Returns children of the <CODE>TreeNode</CODE> as <CODE>Enumeration</CODE>.
     *
     * @return Enumeration to access to child nodes
     *
     * @see getChildren()  
     */
    public Enumeration children(); 
    
    /**
     * Returns children of the <CODE>TreeNode</CODE> as <CODE>Enumeration</CODE>.
     * Same as <CODE>TreeNode#children()</CODE>.  
     * It does not exists in <CODE>javax.swing.tree.TreeNode</CODE>.
     *
     * @return Enumeration to access to child nodes
     *
     * @see children()  
     */
    public Enumeration getChildren(); 
    
    /**
     *  Returns true if the <CODE>TreeNode</CODE> allows to have children.
     *
     * @return true if the <CODE>TreeNode</CODE> allows to have children.
     */
    public boolean getAllowsChildren(); 
    
    /**
     * Returns a child <CODE>TreeNode</CODE> at given <CODE>childIndex</CODE>.
     *
     * @param childIndex <CODE>int</CODE> representing the position of child node
     *
     * @return TreeNode at <CODE>childIndex</CODE>
     */
    public TreeNode getChildAt(int childIndex); 
    
    /**
     * Returns number of child <CODE>TreeNode</CODE>s of the <CODE>TreeNode</CODE>.
     *
     * @return int representing number of child <CODE>TreeNode</CODE>s of the <CODE>TreeNode</CODE>
     */
    public int getChildCount();
    
    /**
     * Returns index of <CODE>TreeNode</CODE> given by <CODE>node</CODE> 
     * if it is childlen of the <CODE>TreeNode</CODE>.
     * If the <CODE>TreeNode</CODE> does not contain given <CODE>node</CODE>,
     * it returns -1.
     *
     * @param node <CODE>TreeNode</CODE> of which index will be returned
     *
     * @return int representing index of <CODE>node</CODE> or -1 if it isn't
     * child node of this <CODE>TreeNode</CODE>
     */
    public int getIndex(TreeNode node);
    
    /**
     * Returns parent <CODE>TreeNode</CODE> of the <CODE>TreeNode</CODE>.
     *
     * @return TreeNode representing parent <CODE>TreeNode</CODE> of the <CODE>TreeNode</CODE>.
     */
    public TreeNode getParent();

    /**
     * Returns true if the <CODE>TreeNode</CODE> is a leaf, i.e. it does not have children.
     * It must be equivalent with getChildCount() != 0.
     *
     * @return boolean true if the <CODE>TreeNode</CODE> is a leaf
     */
    public boolean isLeaf();
}
