/*
 * TreePath.java:  TreePath to replace javax.swing.tree.TreePath
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TreePath.java,v 1.2 2002/08/05 23:56:21 nozomi Exp $
 * $Log: TreePath.java,v $
 * Revision 1.2  2002/08/05 23:56:21  nozomi
 * fix constructor
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.util.tree;

//import java.io.Serializable;

/**
 * Represents a path to a node.
 * <CODE>TreePath</CODE> is an array of <CODE>Object</CODE>
 * created from <CODE>TreeModel</CODE>.
 * Elements of a path is always orderd that root node is
 * the first element (index zero).
 * <CODE>TreePath</CODE> is <CODE>Serializable</CODE> but
 * it is not written out if components of the path is no
 * serializable.
 *
 * @version 	05 Aug 2002
 * @author 	Nozomi `James' Ytow
 */
public class TreePath
    extends Object
	    //implements Serializable
{
    private TreePath path;
    
    private Object lastNode;
    
    protected TreePath()
    {
	this((Object)null);
    }
       
    public TreePath(Object node)
    {
	super();
	lastNode = node;
	path = null;
    }

    public TreePath(Object[] p)
    {
	super();
	path = null;
	lastNode = null;
	if(p != null && p.length != 0) {
	    recursiveCreate(p, p.length);
	    /*
	    int index = p.length - 1;
	    lastNode = p[index];
	    if(index > 0) {
		path = new TreePath(p, index);
	    }
	    */
	}
    }

    protected TreePath(Object[] p, int length)
    {
	super();
	path = null;
	lastNode = null;
	recursiveCreate(p, length);
    }

    protected void recursiveCreate(Object[] p, int length)
    {
	int index = --length;
	lastNode = p[index];
	if(index > 0) {
	    path = new TreePath(p, index);
	}
	/*
	else
	    path = null;
	*/
    }

    protected TreePath(TreePath parent, Object lastElement)
    {
	path = null;
	lastNode = null;
	if(lastElement != null){
	    Object[] p = getPath();
	    int index = 0;
	    int count = getPathCount();
	    for(; p[index] != lastElement && index < count; index++) { ; }
	    if(index < count)
		recursiveCreate(p, index);
	    else {
		path = parent;
		lastNode = lastElement;
	    }
	}
    }


    public boolean equals(Object o)
    {
	if(o == this)
	    return true;
	if(o instanceof TreePath) {
	    TreePath target = (TreePath)o;
	    if(getPathCount() != target.getPathCount())
		return false;
	    for(TreePath p = this; p != null; p = p.path) {
		if (!(p.lastNode.equals 
		      (target.lastNode)
		      )
		    )
		    {
			return false;
		    }

		target = target.path;
	    }
	    return true;
	}
	return false;
    } 

    public Object getLastPathComponent()
    {
	return lastNode;
    } 

    public TreePath getParentPath()
    {
	return path;
    } 

    public Object[] getPath()
    {
	int i = getPathCount();
        Object[] r = new Object[i--];

        for(TreePath p = this; p != null; p = p.path) {
            r[i--] = p.lastNode;
        }
	return r;
    }

    public Object getPathComponent(int index)
    {
	int elements = getPathCount();
	if(elements <= index || elements < 0)
            throw new IllegalArgumentException("Index " + index + " is out of the specified range");
	TreePath p = this;
	
        for(int i = elements - 1; i != index; i--) {
           p = p.path;
        }
	return p.lastNode;
    }

    public int getPathCount()
    {
	int count = 0;
        for(TreePath p = this; p != null; p = p.path) {
	    count++;
	}
	return count;
    }

    public int hashCode()
    {
	return lastNode.hashCode();
    }


    public boolean isDescendant(TreePath treePath)
    {
	if(this == treePath)
	    return true;

	if(treePath == null)
	    return false;

	int pathCount = getPathCount();
	int comparandPathCount = treePath.getPathCount();
	
	// subset can't be descendant
	if(comparandPathCount < pathCount)
	    return false;
	
	while(comparandPathCount-- > pathCount)
	    treePath = treePath.getParentPath();
	return equals(treePath);
    }

    public TreePath pathByAddingChild(Object child)
    {
	if(child == null)
	    throw new NullPointerException("Null child not allowed");

	return new TreePath(this, child);
    }

    public String toString()
    {
	StringBuffer buffer = new StringBuffer("[");

	for (int i = 0, pathCount = getPathCount();
	     i < pathCount; i++) {
	    if(i > 0)
		buffer.append(",");
	    buffer.append(getPathComponent(i));
	}

	buffer.append("]");

	return buffer.toString();
    } 

    /**
       serialization...

    private void writeObject(ObjectOutputStream s) throws IOException {
    }

    private void readObject(ObjectInputStream s) 
        throws IOException, ClassNotFoundException {
    }
    */
}
