/*
 * TreeModelEvent.java:  TreeModelEvent to replace javax.swing.event.TreeModelEvent
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * $Id: TreeModelEvent.java,v 1.5 2002/09/02 08:13:43 t.okada Exp $
 * $Log: TreeModelEvent.java,v $
 * Revision 1.5  2002/09/02 08:13:43  t.okada
 * remove multibyte character
 *
 * Revision 1.4  2002/04/19 21:46:56  nozomi
 * more translations of comment
 *
 * Revision 1.3  2002/04/16 23:43:52  nozomi
 * apply ryo's modification on another branch
 *
 * Revision 1.2  2002/03/10 06:56:52  nozomi
 * modify comments
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package org.nomencurator.util.tree.event;

import java.util.EventObject;

import org.nomencurator.util.tree.TreePath;

public class TreeModelEvent
    extends EventObject
{
    //path to parent of the modified node (i.e. source)
    protected TreePath path;

    //indices specifying where childs were
    protected int[] childIndices;

    //removed children
    protected Object[] children;



    /**
     * Use to create an event when nodes were modified, inserted or deleted.
    */
    public TreeModelEvent(Object source,
			  Object[] path,
			  int[] childIndices,
			  Object[] children)
    {
	this(source, new TreePath(path), childIndices, children);
    }


    /*
    */

    public TreeModelEvent(Object source,
			  TreePath path,
			  int[] childIndices,
			  Object[] children)
    {
	super(source);
	this.path         = path;
	this.childIndices = childIndices;
	this.children     = children;
    }
			  

    /**
     * Constructs an event when the node structure is modified in some way.
     * <code>path</code> to the root of the modified subtree is specified
     * by an array of <code>Object</code>.  Structure modification events
     * contains, for example, cases containing node exchange points, or
     * encapsulation of multiplenode insertion or deletion in subtree under
     * the node.  Modifications at various levels in the subtree are possible
     * for the latter case.
     * <P>
     * Note: JTree contains all node under the specified node, so only the direct
     * child nodes are visible.
     *
     * @param source <code>Object</code> processes constructs the event.
     * Creatror of the event passes <code>this</code> ordinarily.
     * @param path an array of <code>Object</code> 
    */
    public TreeModelEvent(Object source,
			  Object[] path)
    {
	this(source, new TreePath(path));
    }

    /**
     * Constructs an event when the node structure is modified in some way.
     * A <code>TreePath</code> object <code>path</code> specifies root of modified subtree.
     * See <code>TreeModelEvent(Object,Object[])</code> for specification detail of this event.
     *
     * @param source <code>Object</code> processes constructs the event.
     * Creatror of the event passes <code>this</code> ordinarily.
     * @param path <code>TreePaht</code> object specifies modification point.
     * Although it stores user data object in case of <code>DefaultTreeModel</code>,
     * it is alos possible to use completely different mechanisms in subclasses of
     * <code>TreePath</code> e.g. node ID number.
     *
     * @see TreeModelEvent(Object,Object[])
     */
    public TreeModelEvent(Object source,
			  TreePath path)
    {
	this(source, path, null, null);
    }


    /**
     * Returns parent node of modified node for all events except
     * <code>treeStructureChanged</code>.  It returns higher <code>Object</code>
     * of modified structure for <code>treeStructureChanged</code> event.
     * The list of affected nodes is available using this method and
     * <code>getChildIndices</code>.
     * <P>
     * The exception of above is <code>treeNodesChanged</code> event specifying root
     * where it returns root node and <code>getChildIndices</code> returns null.
     *
     * @return <code>TreePath</code> object specifying modified node.
     *
     * @see TreePath.getLastPathComponent()
     */
    public TreePath getTreePath()
    {
	return path;
    }


    /**
     * A utility method to get an array <code>Objct</code> from 
     * <code>TreePath</code> instance wrapped by this event.
     *
     * @return an array of <code>Object</code>s.  The first <code>Object</code>
     * is the <code>Object</code> at root of the tree, the last <code>Object</code>
     * is the node <code>Object</code> specified by the path 
     */
    public Object[] getPath()
    {
	return path.getPath();
    }


    /**
     * Returns child node <code>Object</code>s at the position specified by <code>getChildIndices</code>,
     * which are child nodes of a node specified by <code>getPath</code>.
     * Returned <code>Object</code>s are not child nodes of the paretnt node if this is a
     * removal event.
     *
     * @return an array of <code>Object</code> containing child nodes specified by this event
     *
     * @see getPath()
     * @see getChildIndices()
    */
    public Object[] getChildren()
    {
	return children;
    }


    /**
     * Returns indices of children modified.
     * These indices indicate positions of children in the initial list
     * if this is a removal event, or, indicate positions of children
     * in the final list if this is a appending event.
     * The indices indicate position of modified node if this is a
     * node modification event.
     *
     * @return an array of int containing indices of child nodes specified by this event
     *
    */
    public int[] getChildIndices()
    {
	return childIndices;
    }

    /**
     * Returns <code>String</code> representing proparites of this <code>Object</code>
     *
     * @override EventObject#toSring()
     *
     * @return String representing this object
     */
    public String toString()
    {
	StringBuffer   buffer = new StringBuffer();

	buffer.append(getClass().getName());
	buffer.append(" ");
	buffer.append(Integer.toString(hashCode()));

	if(path != null)
	    buffer.append(" path " + path);

	if(childIndices != null) {
	    buffer.append(" indicices [ ");

	    for(int i = 0; i < childIndices.length; i++) {
		buffer.append(Integer.toString(childIndices[i]));
		buffer.append(" ");
	    }

	    buffer.append("]");
	}

	if(children != null) {
	    buffer.append(" children [ ");

	    for(int i = 0; i < children.length; i++) {
		buffer.append(children[i]);
		buffer.append(" ");
	    }

	    buffer.append("]");
	}

	return buffer.toString();
    }

};
