/*
 * BorderedTabbedPanel.java
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */

package jp.kyasu.awt;

import jp.kyasu.graphics.V3DTabbedPanelBorder;
import jp.kyasu.graphics.VBorder;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.CardLayout;

/**
 * The <code>BorderedTabbedPanel</code> is the bordered lightweight container class.
 * The default layout manager for a bordered panel is <code>BorderLayout</code>.
 *
 * @see		jp.kyasu.graphics.VBorder
 *
 * @version 	14 May 2002
 * @author 	Nozomi `James' Ytow
 */
public class BorderedTabbedPanel
    extends BorderedPanel
{

    protected TabSelectionModel tabSelectionModel; 

    /**
     * Creates a new panel using the default layout manager and border.
     */
    public BorderedTabbedPanel(TabSelectionModel model)
    {
	this(new V3DTabbedPanelBorder(true), model);
    }

    /**
     * Creates a new panel with the specified border.
     *
     * @param border the visual border of the panel.
     */
    public BorderedTabbedPanel(VBorder border, TabSelectionModel model)
    {
	this(new CardLayout(), border, model);
    }

    /**
     * Creates a new panel with the specified layout manager.
     *
     * @param layout the layout manager for the panel.
     */
    public BorderedTabbedPanel(LayoutManager layout, TabSelectionModel model)
    {
	this(layout, new V3DTabbedPanelBorder(true), model);
    }

    /**
     * Creates a new panel with the specified layout manager and border.
     *
     * @param layout the layout manager for the panel.
     * @param border the visual border of the panel.
     */
    public BorderedTabbedPanel(LayoutManager layout, VBorder border, TabSelectionModel model)
    {
	super(layout, border);
	tabSelectionModel = model; 
    }

    /**
     * Sets <code>model</code> as <code>TabSelectionModel</code>
     * of this <code>BorderedTabbedPanel</code>
     *
     * @param model <code>TabSelectionModel</code> to be set
     */
    public void setModel(TabSelectionModel model)
    {
	if(tabSelectionModel == model) 
	    return;

	tabSelectionModel = model; 
    }

    /**
     * Returns <code>TabSelectionModel</code> of this
     *
     * @return TabSelectionModel of this <code>BorderedTabbedPanel</code>
     */
    public TabSelectionModel getModel()
    {
	return tabSelectionModel;
    }

    /**
     * Paints the border of this panel.
     */
    protected void paintBorder(Graphics g)
    {
	Dimension d = getSize();
	((V3DTabbedPanelBorder)border).setTab(getModel().getTab());
	border.paint(g, 0, 0, d.width, d.height);
    }
}
