/*
 * ColumnsLayout.java:  a LayoutManager imelementation supporting multiple rows
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: ColumnsLayout.java,v 1.3 2002/09/22 19:47:19 nozomi Exp $
 * $Log: ColumnsLayout.java,v $
 * Revision 1.3  2002/09/22 19:47:19  nozomi
 * KFC style copyright
 *
 * Revision 1.2  2002/01/29 08:14:58  nozomi
 * Constructors and some methods made public
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * The <code>ColumnsLayout</code> class is a layout manager that lays out a
 * container's components.
 *
 * @version 	23 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public class ColumnsLayout
    extends AbstractRowColumnLayout
{
    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout()
    {
	this(EQUAL_SIZE);
    }

    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(boolean equalSize)
    {
	this(0, 0, equalSize);
    }

    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(int orientation)
    {
	this(orientation, EQUAL_SIZE);
    }


    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(int orientation, 
	       boolean equalSize)
    {
	this(0, 0, orientation, equalSize);
    }

    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(int horizontalPlacement, 
	       int verticalPlacement, 
	       boolean equalSize)
    {
	this(horizontalPlacement, verticalPlacement, LEFT_TOP, equalSize);
    }

    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(int horizontalPlacement, 
	       int verticalPlacement, 
	       int orientation,
	       boolean equalSize)
    {
	this(horizontalPlacement, verticalPlacement,
	     orientation, 0, equalSize,
	     0, 0);
    }

    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(int horizontalPlacement, 
	       int verticalPlacement, 
	       int orientation, int gap, 
	       boolean equalSize)
    {
	this(horizontalPlacement, verticalPlacement,
	     orientation, gap, equalSize,
	     0, 0);
    }


    /**
     * Constructs a <code>ColumnsLayout</code> object.
     */
    public ColumnsLayout(int horizontalPlacement, 
	       int verticalPlacement, 
	       int orientation, int gap, 
	       boolean equalSize,
	       int initialColumns, int initialComponentsInColumn)
    {
	super(horizontalPlacement, verticalPlacement,
	      orientation, gap, equalSize,
	      initialColumns, initialComponentsInColumn);
    }

    /**
     * Calculates the preferred size dimensions for the specified
     * panel given the components in the specified parent container.
     * @param parent the component to be laid out
     * @param sizePreference true to get preferred size
     *
     * @see #minimumLayoutSize
     */
    /*
    public Dimension getLayoutSize(Container parent, boolean sizePreference)
    {
	int compCount = parent.getComponentCount();
	int x = 0;
	int y = 0;

	int ncomps = 0;
	maxWidth   = 0;
	maxHeight  = 0;
	int maxColHeight = 0;
	int colHeight = 0;
	int maxWidthInColumn = 0;
	int totalHeight = 0;

	Dimension parentSize = parent.getSize();


	preferSize = sizePreference;
	columns = 0;

	for (int i = 0; i < compCount; i++) {
	    Component c = parent.getComponent(i);
	    if (c.isVisible()) {
		ncomps++;
		Dimension d = getSize(c);
		colHeight += d.height;
		totalHeight += d.height; 
		if(d.width > maxWidthInColumn)
		    maxWidthInColumn = d.width;
		if(colHeight > parentSize.width) {
		    columns++;
		    colHeight -= d.height;
		    colHeight -= gap;
		    if(colHeight < 0)
			colHeight = 0;
		    if(colHeight > maxColHeight)
			maxColHeight = colHeight;
		    colHeight = 0;
		    y += maxWidthInColumn;
		}
		else
		    colHeight += gap;
		    
		if(d.width > maxWidth)
		    maxWidth = d.width;
		if(d.height > maxHeight)
		    maxHeight = d.height;
	    }
	}
	x = maxColHeight;

	if(colHeight != 0)
	    columns++;

	if (ncomps > 1) {
	    int parentHeight = parentSize.height;
	    if(parentHeight == 0) {
		if((initialColumns == 0 &&
		    initialComponentsInColumn == 0) ||
		   initialColumns == 1)
		    parentHeight = totalHeight + gap * (ncomps - 1);
		else if(initialColumns == 0) {
		    parentHeight = (gap + maxHeight) * initialComponentsInColumn - gap;
		}
	    }
	    
	    if(parentHeight != 0) {
		int tabsInColumn = (parentHeight + gap)/(maxHeight + gap);
		if(tabsInColumn != 0) {
		    columns = ncomps / tabsInColumn;
		    if(ncomps % tabsInColumn != 0)
			columns++;
		    y = tabsInColumn * (maxHeight + gap) - gap;
		    x = maxWidth * columns;
		}
	    }
	    else {
		x = parentSize.height;
		x = maxWidth * initialColumns;
	    }
	}
	else {
	    x = 0;
	    y = 0;
	}
	    

	Insets insets = parent.getInsets();

	return new Dimension(x + (insets.left + insets.right),
			     y + (insets.top  + insets.bottom));
    }
    */
    /**
     * Lays out the container in the specified panel.
     * @param parent the component which needs to be laid out
     */
    /*
    public void layoutContainer(Container parent)
    {
	Insets insets = parent.getInsets();
	int compCount = parent.getComponentCount();
	Dimension parentSize = parent.getSize();
	Dimension parentPrefSize = parent.getPreferredSize();
	int width  = parentSize.width;
	int height = parentSize.height;
	width  -= insets.left + insets.right;
	height -= insets.top  + insets.bottom;
	int origin = insets.left;
	int widthIncrement = maxWidth;

	switch(horizontalPlacement) {
	    //nothing to do for case LEFT
	case CENTER:
	    origin += width / 2 - parentPrefSize.width / 2 - maxWidth * columns /2;
	    break;
	case RIGHT:
	    origin += width - maxWidth * columns;
	}

	if(orientation == RIGHT_TOP ||
	   orientation == RIGHT_BOTTOM) {
	    widthIncrement = - widthIncrement;
	    origin = width - maxWidth;
	}

	int top = insets.top;
	int increment = 1;

	switch(verticalPlacement) {
	    //nothing to do for case TOP
	case MIDDLE:
	    top += height / 2 - parentPrefSize.height / 2;
	    break;
	case BOTTOM:
	    top += height - parentPrefSize.height;
	    break;
	}

	switch(orientation) {
	case RIGHT_BOTTOM:
	case LEFT_BOTTOM:
	    top += parentPrefSize.height;
	    increment = -1;
	    break;
	}

	int y = top;
	int inColumns = 0;
	int remain = height;
	int componentHeight = maxHeight;
	int row = 0;
	for (int i = 0; i < compCount; ++i) {
	    Component c = parent.getComponent(i);
	    if (!c.isVisible())
		continue;
	    if(!equalSize)
		componentHeight = parent.getSize().height;
	    if(remain < componentHeight) {
		origin += widthIncrement;
		remain = height;
		y = top;
	    }
	    
	    c.setBounds(origin, y, maxWidth, componentHeight);
	    remain -= componentHeight;
	    y += increment * componentHeight;
	}
    }
    */

    public Dimension getAdvances(Component component, boolean preferSize)
    {
	return swap(getSize(component, preferSize));
    }

    public Dimension getAdvances(Component component)
    {
	return swap(component.getSize());
    }


    public int getComponentAdvance(Component component,
				      boolean preferSize)
    {
	return getSize(component, preferSize).height;
    }

    public int getComponentAdvance(Component component)
    {
	return component.getSize().height;
    }

    public int getLineAdvance(Component component,
				 boolean preferSize)
    {
	return getSize(component, preferSize).width;
    }

    protected Insets getInsets(Container container)
    {
	Insets i = container.getInsets();

	//rotate
	switch(orientation) {
	case LEFT_TOP:
	case RIGHT_TOP:
	    return new Insets(i.right, i.top, i.left, i.bottom);
	case RIGHT_BOTTOM:
	case LEFT_BOTTOM:
	    return new Insets(i.left, i.bottom, i.right, i.top);
	}

	return i;
    }

    protected void setLineParameters(Container parent)
    {
	lineAdvance = maxHeight;
	lineDirection = 1;

	Insets insets = parent.getInsets();
	Dimension parentSize = parent.getSize();

	lineWidth  = parentSize.height - (insets.top  + insets.bottom);
	int height = parentSize.width - (insets.left + insets.right);

	lineHead = insets.left;

	Dimension parentPrefSize = parent.getPreferredSize();

	switch(horizontalPlacement) {
	    //nothing to do for case LEFT
	case CENTER:
	    lineHead += height / 2 - parentPrefSize.width / 2 - maxHeight * lines /2;
	    break;
	case RIGHT:
	    lineHead += height - maxHeight * lines;
	}

	if(orientation == RIGHT_TOP ||
	   orientation == RIGHT_BOTTOM) {
	    lineAdvance = -lineAdvance;
	    lineHead = parentSize.width - insets.right - maxHeight;
	}

	if(lineHead < 0)
	    lineHead = 0;


	lineOrigin = insets.top;

	switch(verticalPlacement) {
	    //nothing to do for case TOP:
	case MIDDLE:
	    lineOrigin += parentPrefSize.height / 2 - lineWidth / 2;
	    break;
	case BOTTOM:
	    lineOrigin += parentPrefSize.height - lineWidth;
	    break;
	}

	switch(orientation) {
	case RIGHT_BOTTOM:
	case LEFT_BOTTOM:
	    lineOrigin += lineWidth;
	    lineDirection = -1;
	    break;
	}

    }

    protected void setBounds(Component component,
			     int componentAt,
			     int lineHead,
			     int componentAdvance,
			     int componentHeight)
    {
	component.setBounds(lineHead, componentAt, componentHeight, componentAdvance);
    }


}
