/*
 * DefaultTabLayout.java:  a LayoutManager imelementation supporting multiple rows
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: DefaultTabLayout.java,v 1.3 2002/09/05 05:10:50 nozomi Exp $
 * $Log: DefaultTabLayout.java,v $
 * Revision 1.3  2002/09/05 05:10:50  nozomi
 * change copyright to KFC style
 *
 * Revision 1.2  2002/01/29 08:12:49  nozomi
 * Modified to wrap manager for size calcuration
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * The <code>DefaultTabLayout</code> class is a layout manager that lays out a
 * container's components.
 *
 * @version 	25 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
class DefaultTabLayout
    implements TabLayout
{
    /*
    public static final int TOP    = RowsLayout.TOP;
    public static final int BOTTOM = RowsLayout.BOTTOM;
    public static final int MIDDLE = RowsLayout.MIDDLE;
    public static final int LEFT   = RowsLayout.LEFT;
    public static final int CENTER = RowsLayout.CENTER;
    public static final int RIGHT  = RowsLayout.RIGHT;

    public static final int TOP_LEFT     = RowsLayout.TOP_LEFT;
    public static final int BOTTOM_LEFT  = RowsLayout.BOTTOM_LEFT;
    public static final int TOP_RIGHT    = RowsLayout.TOP_RIGHT;
    public static final int BOTTOM_RIGHT = RowsLayout.BOTTOM_RIGHT;
    public static final int LEFT_TOP     = ColumnsLayout.LEFT_TOP;
    public static final int LEFT_BOTTOM  = ColumnsLayout.LEFT_BOTTOM;
    public static final int RIGHT_TOP    = ColumnsLayout.RIGHT_TOP;
    public static final int RIGHT_BOTTOM = ColumnsLayout.RIGHT_BOTTOM;

    public static final boolean EQUAL_SIZE = RowsLayout.EQUAL_SIZE;
    */
    TabSelectionModel model;
    TabLayout manager;

    /**
     * Constructs a <code>DefaultTabLayout</code> object.
     */
    public DefaultTabLayout()
    {
	this(new TabSelectionModel());
    }

    /**
     * Constructs a <code>DefaultTabLayout</code> object.
     */
    public DefaultTabLayout(TabSelectionModel model)
    {
	this(model, EQUAL_SIZE);
    }

    /**
     * Constructs a <code>DefaultTabLayout</code> object.
     */
    public DefaultTabLayout(TabSelectionModel model, boolean equalSize)
    {
	this(model, equalSize, 0);
    }

    /**
     * Constructs a <code>DefaultTabLayout</code> object.
     */
    public DefaultTabLayout(TabSelectionModel model, 
		     boolean equalSize,
		     int gap) 
    {
	setModel(model, equalSize, gap);
    }

    protected void setManager(TabSelectionModel model,
			      boolean equalSize,
			      int gap) 
    {
	switch(model.getTabPlacement()) {
	case Tab.TOP:
	    manager = new RowTabLayout(model, 
				       RowsLayout.LEFT, 
				       RowsLayout.BOTTOM, 
				       RowsLayout.BOTTOM_LEFT,
				       gap, equalSize);
	    break;
	case Tab.BOTTOM:
	    manager = new RowTabLayout(model,
				       RowsLayout.LEFT,
				       RowsLayout.TOP,
				       RowsLayout.TOP_LEFT,
				       gap, equalSize);
	    break;
	case Tab.RIGHT:
	    manager = new ColumnarTabLayout(model,
					    ColumnsLayout.LEFT,
					    ColumnsLayout.TOP,
					    ColumnsLayout.LEFT_TOP,
					    gap, equalSize);
	    break;
	case Tab.LEFT:
	    manager = new ColumnarTabLayout(model,
					    ColumnsLayout.RIGHT,
					    ColumnsLayout.TOP,
					    ColumnsLayout.RIGHT_TOP,
					    gap, equalSize);
	    break;
	}
    }

    protected void setManager(TabSelectionModel model)
    {
	switch(model.getTabPlacement()) {
	case Tab.TOP:
	    manager = new RowTabLayout(model);
	    break;
	case Tab.BOTTOM:
	    manager = new RowTabLayout(model);
	    break;
	case Tab.RIGHT:
	    manager = new ColumnarTabLayout(model);
	    break;
	case Tab.LEFT:
	    manager = new ColumnarTabLayout(model);
	    break;
	}
    }

    protected void setModel(TabSelectionModel model,
			    boolean equalSize,
			    int gap) 
    {
	int newPlacement = model.getTabPlacement();
	int currentPlacement = -1;
	if(this.model != null)
	    currentPlacement = this.model.getTabPlacement();
	this.model = model;
	if(newPlacement == currentPlacement)
	    manager.setModel(model);
	else
	    setManager(model, equalSize, gap);
    }

    public void setModel(TabSelectionModel model)
    {
	int newPlacement = model.getTabPlacement();
	int currentPlacement = -1;
	if(this.model != null)
	    currentPlacement = this.model.getTabPlacement();
	this.model = model;
	if(newPlacement == currentPlacement)
	    manager.setModel(model);
	else if(manager != null) {
	    setManager(model,
		       manager.getEqualSize(),
		       manager.getGap()
		       );
	}
	else
	    setManager(model);
    }

    public TabSelectionModel getModel()
    {
	return model;
    }

    /**
     * Adds the specified component with the specified name to
     * the layout.
     * @param name the component name
     * @param comp the component to be added
     */
    public void addLayoutComponent(String name, Component comp)
    {
	manager.addLayoutComponent(name, comp);
    }

    /**
     * Removes the specified component from the layout.
     * @param comp the component ot be removed
     */
    public void removeLayoutComponent(Component comp)
    {
	manager.removeLayoutComponent(comp);
    }

    /**
     * Calculates the preferred size dimensions for the specified
     * panel given the components in the specified parent container.
     * @param parent the component to be laid out
     *
     * @see #minimumLayoutSize
     */
    public Dimension preferredLayoutSize(Container parent)
    {
	return manager.preferredLayoutSize(parent);
    }

    /**
     * Calculates the minimum size dimensions for the specified
     * panel given the components in the specified parent container.
     * @param parent the component to be laid out
     * @see #preferredLayoutSize
     */
    public Dimension minimumLayoutSize(Container parent)
    {
	return manager.minimumLayoutSize(parent);
    }

    /**
     * Lays out the container in the specified panel.
     * @param parent the component which needs to be laid out
     */
    public void layoutContainer(Container parent)
    {
	manager.layoutContainer(parent);
    }

    public void setHorizontalPlacement(int horizontalPlacement)
    {
	manager.setHorizontalPlacement(horizontalPlacement);
    }

    public void setVerticalPlacement(int verticalPlacement)
    {
	manager.setVerticalPlacement(verticalPlacement);
    }

    public void setPlacements(int horizontalPlacement, int verticalPlacement)
    {
	manager.setPlacements(horizontalPlacement, verticalPlacement);
    }
    
    public void setOrientation(int orientation)
    {
	manager.setOrientation(orientation);
    }

    public void setGap(int gap)
    {
	manager.setGap(gap);
    }
    
    public int getGap()
    {
	return manager.getGap();
    }
    
    public void setEqualSize(boolean equalSize)
    {
	manager.setEqualSize(equalSize);
    }
    
    public boolean getEqualSize()
    {
	return manager.getEqualSize();
    }

    public void setInitialLines(int initialLines)
    {
	manager.setInitialLines(initialLines);
    }
    
    public void setInitialComponentsInLine(int initialComponentsInLine)
    {
	manager.setInitialComponentsInLine(initialComponentsInLine);
    }
    
    /**
     * Set size of <code>Tab</code> and pane to be used by this layout
     * by a algorithm referring to given <code>component</code> and <code>tab</code>. 
     *
     * @param component <code>Component</code> to be <code>Tab</code>bed in a <code>TabbedPane</code>
     * @param tab <code>Tab</code> to associates with <code>component</code>
     */
    public void setSize(Component component, Tab tab)
    {
	manager.setSize(component, tab);
    }
}
