/*
 *
 * RowColumnLayout.java:  a LayoutManager imelementation supporting multiple rows
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: RowColumnLayout.java,v 1.2 2002/09/03 23:56:00 nozomi Exp $
 * $Log: RowColumnLayout.java,v $
 * Revision 1.2  2002/09/03 23:56:00  nozomi
 * change copyright
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * The <code>RowColumnLayout</code> class is a layout manager that lays out a
 * container's components.
 *
 * @version 	04 Sep 2002
 * @author 	Nozomi `James' Ytow
 */
public interface RowColumnLayout 
    extends LayoutManager
{
    public static final int TOP    = 0;
    public static final int BOTTOM = 1;
    public static final int MIDDLE = 2;
    public static final int LEFT  = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    
    public static final int TOP_LEFT     = 0;
    public static final int BOTTOM_LEFT  = 1;
    public static final int TOP_RIGHT    = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int LEFT_TOP     = 4;
    public static final int LEFT_BOTTOM  = 5;
    public static final int RIGHT_TOP    = 6;
    public static final int RIGHT_BOTTOM = 7;
    
    public static final boolean EQUAL_SIZE = true;
    
    public abstract void setHorizontalPlacement(int horizontalPlacement);

    public abstract void setVerticalPlacement(int verticalPlacement);

    public abstract void setPlacements(int horizontalPlacement, int verticalPlacement);
    
    public abstract void setOrientation(int orientation);

    public abstract void setGap(int gap);
    
    public abstract int getGap();
    
    public abstract void setEqualSize(boolean equalSize);
    
    public abstract boolean getEqualSize();

    public abstract void setInitialLines(int initialLines);
    
    public abstract void setInitialComponentsInLine(int initialComponentsInLine);
    
}

