/*
 * RowTabLayout.java:  a LayoutManager imelementation supporting multiple rows
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: RowTabLayout.java,v 1.3 2002/09/05 05:11:03 nozomi Exp $
 * $Log: RowTabLayout.java,v $
 * Revision 1.3  2002/09/05 05:11:03  nozomi
 * change copyright to KFC style
 *
 * Revision 1.2  2002/01/29 08:06:23  nozomi
 * Modifed to use TabbedPaneSize
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * The <code>RowTabLayout</code> class is a layout manager that lays out a
 * container's components.
 *
 * @version 25 Jan 2002
 * @author Nozomi `James' Ytow
 */
public class RowTabLayout 
    extends RowsLayout
    implements TabLayout
{
    /**
     * <code>TabSelectionModel</code> to be used
     */
    protected TabSelectionModel model;

    /**
     * <code>TabbedPaneSize</code> calcurator
     */
    protected TabbedPaneSize sizes;

    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model)
    {
	this(model, EQUAL_SIZE);
    }
  
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, boolean equalSize)
    {
	this(model, 0, 0, equalSize);
    }
  
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, int orientation)
    {
	this(model, orientation, EQUAL_SIZE);
    }
  
  
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, int orientation, 
		      boolean equalSize)
    {
	this(model, 0, 0, orientation, equalSize);
    }
    
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, int horizontalPlacement, 
		      int verticalPlacement, 
		      boolean equalSize)
    {
	this(model, horizontalPlacement, verticalPlacement, TOP_LEFT, equalSize);
    }
  
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, int horizontalPlacement, 
		      int verticalPlacement, 
		      int orientation,
		      boolean equalSize)
    {
	this(model, horizontalPlacement, verticalPlacement,
	     orientation, 0, equalSize,
	     0, 0);
    }
    
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, int horizontalPlacement, 
		      int verticalPlacement, 
		      int orientation, int gap, 
		      boolean equalSize)
    {
	this(model, horizontalPlacement, verticalPlacement,
	     orientation, gap, equalSize,
	     0, 0);
    }
    
    
    /**
     * Constructs a <code>RowTabLayout</code> object.
     */
    public RowTabLayout(TabSelectionModel model, 
			int horizontalPlacement, 
			int verticalPlacement, 
			int orientation, int gap, 
			boolean equalSize,
			int initialLines, int initialComponentsInLine)
    {
	super(horizontalPlacement, verticalPlacement,
	      orientation, gap, equalSize,
	      initialLines, initialComponentsInLine);
	setModel(model);
	sizes = new TabbedPaneSize(this);
    }

    public void setModel(TabSelectionModel model)
    {
	this.model = model;
    } 

    public TabSelectionModel getModel()
    {
	return model;
    } 

    protected void drawComponents(Container parent)
    {
	int components = parent.getComponentCount();
	int i = 0;

	if(!model.isSelected()) {
	    drawComponents(parent, i, components);
	    return;
	}

	BooleanState tab = model.getSelectedBooleanState();

	int selectedLineOrigin = i;
	Component c = parent.getComponent(i);
	int componentAt      = lineOrigin;
	int remaining        = lineWidth;
	int componentAdvance = maxAdvance;

	while(c != tab && i < components) {
	    c = parent.getComponent(++i);
	    if (!c.isVisible())
		continue;
	    if(!equalSize)
		componentAdvance = getComponentAdvance(c);
	    if(remaining < componentAdvance) {
		lineHead += lineAdvance;
		remaining = lineWidth;
		componentAt = lineOrigin;
		selectedLineOrigin = i;
	    }
	    remaining -= componentAdvance;
	    componentAt += lineDirection * componentAdvance;
	}

	if(c != tab || i == 0) {
	    drawComponents(parent, 0, components);
	    return;
	}

	drawComponents(parent, selectedLineOrigin, components);
	drawComponents(parent, 0, selectedLineOrigin);
    }

    /**
     * Adds <code>component</code> with <code>tab</code> to determine layout
     *
     * @param component <code>Component</code> to be <code>Tab</code>bed in a <code>TabbedPane</code>
     * @param tab <code>Tab</code> to associates with <code>component</code>
     */
    public void setSize(Component component, Tab tab)
    {
	sizes.setSize(component, tab);
    }

    public Dimension getLayoutSize(Container parent, boolean sizePreference)
    {
	super.getLayoutSize(parent, sizePreference);
	return sizes.getTabPaneSize();
    }
}

