/*
 *
 * RowsLayout.java:  a LayoutManager imelementation supporting multiple rows
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: RowsLayout.java,v 1.3 2002/09/06 02:12:40 nozomi Exp $
 * $Log: RowsLayout.java,v $
 * Revision 1.3  2002/09/06 02:12:40  nozomi
 * change copyright to KFC style
 *
 * Revision 1.2  2002/01/29 08:04:19  nozomi
 * Modifed advance methods to be public
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

/**
 * The <code>RowsLayout</code> class is a layout manager that lays out a
 * container's components.
 *
 * @version 25 Jan 2002
 * @author Nozomi `James' Ytow
 */
public class RowsLayout 
    extends AbstractRowColumnLayout
{
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout()
    {
	this(EQUAL_SIZE);
    }
  
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(boolean equalSize)
    {
	this(0, 0, equalSize);
    }
  
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(int orientation)
    {
	this(orientation, EQUAL_SIZE);
    }
  
  
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(int orientation, 
		      boolean equalSize)
    {
	this(0, 0, orientation, equalSize);
    }
    
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(int horizontalPlacement, 
		      int verticalPlacement, 
		      boolean equalSize)
    {
	this(horizontalPlacement, verticalPlacement, TOP_LEFT, equalSize);
    }
  
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(int horizontalPlacement, 
		      int verticalPlacement, 
		      int orientation,
		      boolean equalSize)
    {
	this(horizontalPlacement, verticalPlacement,
	     orientation, 0, equalSize,
	     0, 0);
    }
    
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(int horizontalPlacement, 
		      int verticalPlacement, 
		      int orientation, int gap, 
		      boolean equalSize)
    {
	this(horizontalPlacement, verticalPlacement,
	     orientation, gap, equalSize,
	     0, 0);
    }
    
    
    /**
     * Constructs a <code>RowsLayout</code> object.
     */
    public RowsLayout(int horizontalPlacement, 
		      int verticalPlacement, 
		      int orientation, int gap, 
		      boolean equalSize,
		      int initialLines, int initialComponentsInLine)
    {
	super(horizontalPlacement, verticalPlacement,
	      orientation, gap, equalSize,
	      initialLines, initialComponentsInLine);
    }
    
    public Dimension getAdvances(Component component, boolean preferSize)
    {
	return getSize(component, preferSize);
    }


    public Dimension getAdvances(Component component)
    {
	return component.getSize();
    }


    public int getComponentAdvance(Component component,
				      boolean preferSize)
    {
	return getSize(component, preferSize).width;
    }

    public int getComponentAdvance(Component component)
    {
	return component.getSize().width;
    }

    public int getLineAdvance(Component component,
				 boolean preferSize)
    {
	return getSize(component, preferSize).height;
    }

    protected Insets getInsets(Container container)
    {
	return container.getInsets();
    }


    protected void setLineParameters(Container parent)
    {
	lineAdvance = maxHeight;
	lineDirection = 1;

	Insets insets = parent.getInsets();
	Dimension parentSize = parent.getSize();

	lineWidth  = parentSize.width - (insets.left + insets.right);
	int height = parentSize.height - (insets.top  + insets.bottom);

	lineHead = insets.top;

	Dimension parentPrefSize = parent.getPreferredSize();

	switch(verticalPlacement) {
	    //nothing to do for case TOP
	case MIDDLE:
	    lineHead += height / 2 - parentPrefSize.height / 2 - maxHeight * lines /2;
	    break;
	case BOTTOM:
	    lineHead += height - maxHeight * lines;
	}


	if(orientation == BOTTOM_LEFT ||
	   orientation == BOTTOM_RIGHT) {
	    lineAdvance = -lineAdvance;
	    lineHead = height - maxHeight;
	}


	lineOrigin = insets.left;

	switch(horizontalPlacement) {
	    //nothing to do for case LEFT
	case CENTER:
	    lineOrigin += lineWidth / 2 - parentPrefSize.width / 2;
	    break;
	case RIGHT:
	    lineOrigin += lineWidth - parentPrefSize.width;
	    break;
	}

	switch(orientation) {
	case TOP_RIGHT:
	case BOTTOM_RIGHT:
	    lineOrigin += parentPrefSize.width;
	    lineDirection = -1;
	    break;
	}

    }

    protected void setBounds(Component component,
			     int componentAt,
			     int lineHead,
			     int componentAdvance,
			     int componentHeight)
    {
	component.setBounds(componentAt, lineHead, componentAdvance, componentHeight);
    }

}

