/*
 * SingleSelectionModel.java:
 *  interface compatible with javax.swing.SingleSelectionModel
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: SingleSelectionModel.java,v 1.2 2002/05/13 20:40:49 nozomi Exp $
 * $Log: SingleSelectionModel.java,v $
 * Revision 1.2  2002/05/13 20:40:49  nozomi
 * change copyright to KFC style
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import jp.kyasu.awt.event.ChangeListener;

public interface SingleSelectionModel
{

    final public int UNSELECTED = -1;
    /**
     *
     * Returns selected index
     *
     * @return selected index or -1 if nothing is selected
     *
     * @see setSelectedIndex(int)
     */
    public int getSelectedIndex();


    /**
     *
     * Sets selected index to <code>index</code> and notifies to all
     * listeners if model changed (i.e. <code>index</code> != 
     * current selected index).
     *
     * @param index an int specifying selection index
     *
     * @see getSelectedIndex()
     * @see addChangeListener(ChangeListener)
     */
    public void setSelectedIndex(int index);

         
    /**
     *
     * Clears selection (sets selected index to -1)
     *
     */
    public void clearSelection();


    /**
     *
     * Returns true if an item is selected in the model
     *
     * @return true if an item is selected
     */
    public boolean isSelected();



    /**
     *
     * Adds <code>listener</code> to the list of <code>ChangeListener</code>s
     *
     * @param listener a <code>ChangeLister</code> to be added
     */
    public void addChangeListener(ChangeListener listener);


    /**
     *
     * Removes <code>listener</code> from the list of <code>ChangeListener</code>s
     *
     * @param listener a <code>ChangeLister</code> to be removed
     */
    public void removeChangeListener(ChangeListener listener);
}
