/*
 * TabLayout.java:  a LayoutManager imelementation supporting multiple rows
 *
 * Copyright (c) 2001, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: TabLayout.java,v 1.3 2002/09/03 23:56:00 nozomi Exp $
 * $Log: TabLayout.java,v $
 * Revision 1.3  2002/09/03 23:56:00  nozomi
 * change copyright
 *
 * Revision 1.2  2002/01/29 08:01:36  nozomi
 * Modifed to use TabbedPaneSize
 *
 * Revision 1.1.1.1  2002/01/16 12:33:33  ryo
 * initial import into CVS
 */

package jp.kyasu.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

import jp.kyasu.awt.Tab;

/**
 * The <code>TabLayout</code> class is a layout manager that lays out a
 * container's components.
 *
 * @version 	23 Jan 2002
 * @author 	Nozomi `James' Ytow
 */
public interface TabLayout
    extends RowColumnLayout
{
    /**
     * Sets <code>model</code> as <code>TabSelectionModel</code> to be used
     *
     * @param model <code>TabSelectionModel</code> to be used
     */
    public void setModel(TabSelectionModel model);

    /**
     * Gets <code>TabSelectionModel</code> in use
     *
     * @return <code>TabSelectionModel</code> in use
     */
    public TabSelectionModel getModel();

    /**
     * Set size of <code>Tab</code> and pane to be used by this layout
     * by a algorithm referring to given <code>component</code> and <code>tab</code>. 
     *
     * @param component <code>Component</code> to be <code>Tab</code>bed in a <code>TabbedPane</code>
     * @param tab <code>Tab</code> to associates with <code>component</code>
     */
    public void setSize(Component component, Tab tab);

}
