/*
 * CharactorSetButton.java:  a Button to pop up a character table.
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: CharacterSelectButton.java,v 1.2 2002/06/23 17:34:06 nozomi Exp $
 * $Log: CharacterSelectButton.java,v $
 * Revision 1.2  2002/06/23 17:34:06  nozomi
 * modify event handilng
 *
 * Revision 1.1  2002/06/23 13:09:22  nozomi
 * initial import into CVS repository
 *
 */

package jp.kyasu.editor;

import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import jp.kyasu.awt.AWTResources;
import jp.kyasu.awt.Button;

import jp.kyasu.graphics.VActiveButton;
import jp.kyasu.graphics.VImage;

import jp.kyasu.editor.CharacterChooser;

/**
 * The <code>CharacterSelectButton</code> allows a user to pick up a character
 *
 * @version 	23 Jun 2002
 * @author 	Nozomi `James' Ytow
 */
public class CharacterSelectButton
    extends Button
    implements ActionListener,
	       ItemListener,
	       ItemSelectable
{
    protected CharacterChooser chooser;

    public CharacterSelectButton()
    {
	this(new CharacterChooser());
    }

    public CharacterSelectButton(CharacterChooser chooser)
    {
	super("");
	VImage icon =
	    jp.kyasu.awt.AWTResources.getIcon(getClass(), "icons/charpick.gif");
	setVButton(new VActiveButton(icon));
	this.chooser = chooser;
	if(chooser != null)
	    chooser.addItemListener(this);
	addActionListener(this);
    }

    public char getChar()
    {
	return chooser.getChar();
    }

    /** The item listener. */
    transient protected ItemListener itemListener;

    /**
     * Add a listener to recieve item events when the state of an item changes.
     * @see java.awt.ItemSelectable
     */
    public void addItemListener(ItemListener listener)
    {
	itemListener = 
	    AWTEventMulticaster.add(itemListener, listener);
    }

    /**
     * Removes an item listener.
     * @see java.awt.ItemSelectable
     */
    public void removeItemListener(ItemListener listener)
    {
	itemListener = 
	    AWTEventMulticaster.remove(itemListener, listener);
    }

    public void itemStateChanged(ItemEvent event)
    {
	if(event.getSource() == chooser)
	    notifyItemListeners(event);
    }


    /** Notifies the item event to the item listeners. */
    protected void notifyItemListeners(ItemEvent event)
    {
	if (itemListener != null) {
	    ItemEvent e = 
		new ItemEvent(this, ItemEvent.ITEM_STATE_CHANGED,
			      chooser.getCharacter(), ItemEvent.SELECTED);
	    itemListener.itemStateChanged(e);
	}
    }

    /**
     * Returns the selected items or null if no items are selected.
     * @see java.awt.ItemSelectable
     */
    public Object[] getSelectedObjects()
    {
	return chooser.getSelectedObjects();
    }

    public void actionPerformed(ActionEvent e)
    {
	chooser.showPopup(CharacterSelectButton.this,
			  0, CharacterSelectButton.this.getSize().height);
    }

    /** Executes an example. */
    public static void main(String args[]) {
	CharacterSelectButton button = new CharacterSelectButton();
	button.addItemListener(new ItemListener() {
	    public void itemStateChanged(java.awt.event.ItemEvent e) {
		System.out.println(e.getItem());
	    }
	});
	jp.kyasu.awt.Frame f = new jp.kyasu.awt.Frame();
	f.add(button, java.awt.BorderLayout.CENTER);
	f.pack();
	f.setVisible(true);
    }

}
