/*
 * Editor.java
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: Editor.java,v 1.2 2002/08/22 10:52:33 nozomi Exp $
 * $Log: Editor.java,v $
 * Revision 1.2  2002/08/22 10:52:33  nozomi
 * add lastFocused
 *
 * Revision 1.1  2002/06/21 08:18:56  nozomi
 * intial import of multitext handler
 *
 */

package jp.kyasu.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;

import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

import java.io.BufferedReader;
import java.io.File;
import java.io.Writer;

import java.util.Enumeration;

import jp.kyasu.awt.TextComponent;
import jp.kyasu.awt.TextEditModel;
import jp.kyasu.awt.ToolBar;

import jp.kyasu.awt.event.TextPositionEvent;
import jp.kyasu.awt.event.TextPositionListener;

import jp.kyasu.awt.text.KeyAction;
import jp.kyasu.awt.text.KeyBinding;
import jp.kyasu.awt.text.Keymap;
import jp.kyasu.awt.text.TextCaret;
import jp.kyasu.awt.text.TextEditController;
import jp.kyasu.awt.text.TextEditView;

import jp.kyasu.graphics.ParagraphStyle;
import jp.kyasu.graphics.ParagraphStyleModifier;
import jp.kyasu.graphics.RichText;
import jp.kyasu.graphics.Text;
import jp.kyasu.graphics.TextStyle;
import jp.kyasu.graphics.TextStyleModifier;


/**
 * An interface specifying motheds necessary in text edition.
 *
 * @version 	21 Jun 2002
 * @author 	Nozomi `James' Ytow
 */
public interface Editor
    extends FocusController
{
    /*
    static public final int TEXT_TYPE = 0;
    static public final int CODE_TYPE = 1;
    static public final int RICHTEXT_TYPE = 2;
    static public final int HTML_TYPE = 4 | RICHTEXT_TYPE;
    static public final int DOCUMENT_TYPE = 8 | RICHTEXT_TYPE;
    */

    /**
     * Returns <CODE>TextComponent</CODE> under edition
     *
     * @return TextComponent under edition
     */
    public TextComponent getTextComponent();

    /**
     * Returns <CODE>TextComponent</CODE> had focus previously
     *
     * @return TextComponent had focus previously
     */
    public TextComponent getLastFocused();

    /**
     * Sets <CODE>textComponent</CODE> to be edited by this
     *
     * @param textComponent <CODE>TextComponent</CODE> to be edited
     */
    public void setTextComponent(TextComponent textComponent);

    /**
     * Set focus to the last focused <CODE>TextComponent</CODE>
     */
    public void setLastFocus();

    /**
     * Returns a <CODE>ToolBar</CODE> linked to this editor
     * or null if no <CODE>ToolBar</CODE> is linked to.
     *
     * @return ToolBar linked to this editor
     */
    public ToolBar getToolBar();

    /**
     * Set  <CODE>toolBar</CODE> to be used by this <CODE>Editor</CODE>
     *
     * @param toolBar <CODE>ToolBar</CODE> to be linked to this <CODE>Editor</CODE>
     */
    public void setToolBar(ToolBar toolBar);

    /**
     * Checks if the text is changed.
     */
    public boolean isTextChanged();

    /**
     * Sets the text is changed or not.
     */
    public void setTextChanged(boolean b);

    /**
     * Disables sub components.
     * @see #enableSubComps()
     */
    public void disableSubComps();

    /**
     * Enables sub components.
     * @see #disableSubComps()
     */
    public void enableSubComps();

    // ======== KFC TextComponent APIs ========
    /**
     * Adds the specified text event listener to recieve text events from
     * this text component.
     * @param l the text event listener.
     */
    public void addTextListener(TextListener listener);

    /**
     * Removes the specified text event listener so that it no longer
     * receives text events from this textcomponent
     * @param l the text event listener.
     */
    public void removeTextListener(TextListener listener);

    /**
     * Invoked when the value of the text has changed.
     * @see java.awt.event.TextListener
     */
    public void textValueChanged(TextEvent event);

    /**
     * Adds the specified text position event listener to recieve text
     * position events from this text component.
     * @param l the text position event listener.
     */
    public void addTextPositionListener(TextPositionListener listener);

    /**
     * Removes the specified text position event listener so that it no
     * longer receives text position events from this text component
     * @param l the text position event listener.
     */
    public void removeTextPositionListener(TextPositionListener listener);

    /**
     * Invoked when the position of the text has changed.
     * @see java.awt.event.TextPositionListener
     */
    public void textPositionChanged(TextPositionEvent event); 
}
