/*
 * FocusController.java
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: FocusController.java,v 1.1 2002/06/21 08:18:56 nozomi Exp $
 * $Log: FocusController.java,v $
 * Revision 1.1  2002/06/21 08:18:56  nozomi
 * intial import of multitext handler
 *
 */

package jp.kyasu.editor;

import java.awt.Component;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

/**
 * A focaus event dispacher which can be used to add e.g. multiple <CODE>TextComponet</CODE>
 * handling to <CODE>ToolBar</CODE>
 *
 * @version 	21 June 2002
 * @author 	Nozomi `James' Ytow
 */
public interface FocusController
    extends FocusListener
{
    /**
     * Returns <CODE>Component</CODE> having the focus,
     * or null if no <CODE>Component</CODE> under this controller
     * has the focus.
     *
     * @return Component having the focus, or null if none
     */
    public Component getFocusedComponent();

    /**
     * Listens <CODE>FocusEvent</CODE> of <CODE>component</CODE>,
     * if it is not yet listened.
     *
     * @param component <CODE>Component</CODE> to be listened
     */
    public void listen(Component component);

    /**
     * Unlistens <CODE>FocusEvent</CODE> of <CODE>component</CODE>,
     * if it is already listened by this <CODE>Editor</CODE>
     *
     * @param component <CODE>Component</CODE> to be unlistened
     */
    public void unlisten(Component component);

    /**
     * Adds <COCE>listner</CODE> to the list of
     * <CODE>FocusListener</CODE> listening this
     *
     * @param listner <CODE>FocusListener</CODE> to be added 
     */
    public void addFocusListener(FocusListener listener);

    /**
     * Removes <COCE>listner</CODE> from the list of
     * <CODE>FocusListener</CODE> listening this
     *
     * @param listner <CODE>FocusListener</CODE> to be removed
     */
    public void removeFocusListener(FocusListener listener);

    /**
     * Invokes <CODE>focusGained</CODE> of <CODE>ForcusListener</CODE>s
     * to dispatch <CODE>event</CODE> to them
     *
     * @param event <CODE>FocusEvent</CODE> to be dispatched to registered
     * <CODE>ForcusListener</CODE>s
     *
     * @see java.awt.event.FocusListener
     */
    public void fireFocusGained(FocusEvent event);

    /**
     * Invokes <CODE>focusLost</CODE> of <CODE>ForcusListener</CODE>s
     * to dispatch <CODE>event</CODE> to them
     *
     * @param event <CODE>FocusEvent</CODE> to be dispatched to registered
     * <CODE>ForcusListener</CODE>s
     *
     * @see java.awt.event.FocusListener
     */
    public void fireFocusLost(FocusEvent event);
}

