/*
 * GenericScript.java: a Java implementation of generalized
 * super/subscript attribute.
 *
 * Copyright (c) 2000, 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: GenericScript.java,v 1.5 2002/08/01 04:15:19 nozomi Exp $
 * $Log: GenericScript.java,v $
 * Revision 1.5  2002/08/01 04:15:19  nozomi
 * fix line hight calcuration
 *
 * Revision 1.4  2002/07/02 08:19:41  nozomi
 * change hight calculation
 *
 * Revision 1.3  2002/06/24 01:14:01  nozomi
 * support max line height calculation with super/sub scripts
 *
 * Revision 1.2  2002/06/23 21:44:57  nozomi
 * use sqrt(2.0) as scaling factor
 *
 * Revision 1.1.1.1  2002/01/16 12:33:32  ryo
 * initial import into CVS
 */

package jp.kyasu.graphics;

import java.awt.Font;
import java.awt.FontMetrics;

/**
 * The <code>GenericScript</code> provides handling of
 * nomal/super/subscripts
 *
 * @version 	01 Aug 2002
 * @author 	Nozomi `James' Ytow
 */
public class GenericScript implements java.io.Serializable {

    static public final int NORMALSCRIPT  =  0;
    static public final int SUPERSCRIPT   =  1;
    static public final int SUBSCRIPT     = -1;

    static public final int BASELINE      =  0;

    static public final double scale       = 1.0/Math.sqrt(2.0);

    static public final double superscriptOffsetScale = - Math.sqrt(2.0);
    static public final double subscriptOffsetScale   = Math.sqrt(2.0) - 1.0;
    
    static public final double fontScale       = 0.5;

    //    static public final double maxHeightScale = 1.0/(2.0 - Math.sqrt(2.0));
    static public final double maxHeightScale = Math.sqrt(2.0);

    protected GenericScript script;

    protected int scriptLevel;

    public GenericScript() {
	this(null, NORMALSCRIPT);
    }

    public GenericScript(GenericScript script, int scriptLevel)
    {
	this.script  = script;
	this.scriptLevel = scriptLevel;
    }

    public GenericScript getGenericScript()
    {
	return script;
    }

    public void setGenericScript(GenericScript script)
    {
	this.script = script;
    }

    public GenericScript deriveGenericScript(int scriptLevel)
    {
	return new GenericScript(this, scriptLevel);
    }

    public GenericScript deriveSuperscript()
    {
	return deriveGenericScript(SUPERSCRIPT);
    }

    public GenericScript deriveSubscript()
    {
	return deriveGenericScript(SUBSCRIPT);
    }

    public GenericScript deriveNormalscript()
    {
	return new GenericScript(null, NORMALSCRIPT);
    }

    public int getScriptLevel() {
	return scriptLevel;
    }

    public void setScriptLevel(int scriptLevel)
    {
	this.scriptLevel = scriptLevel;
    }

    public int getBaselineOffset(FontMetrics metrics) {
	int baseline = 0;
	if(scriptLevel != NORMALSCRIPT && metrics != null && metrics.getFont() != null) {
	    //	    double fontSize = (double) getFont(metrics).getSize();
	    double fontSize = (double)getAscent(metrics);


	    //	    baseline = (int)(0.5 +  (double) metrics.getFont().getSize() * 0.5 
	    //	    		     * Math.pow(scale, Math.abs(scriptLevel)/* - 1*/));

	    if(scriptLevel > NORMALSCRIPT) {
		//		baseline = - baseline;
		//baseline = - (int)(0.5 + fontSize  * superscriptBaselineScale);
		baseline = (int)(0.5 + fontSize * superscriptOffsetScale);
	    }
	    else {
		//		baseline = - (int)(0.5 + fontSize  * scale);fontSize - baseline;
		//		baseline -= (double) metrics.getFont().getSize() * 0.5;
		baseline = (int)(0.5 + fontSize * subscriptOffsetScale);
	    }
	    if(script != null)
		baseline += script.getBaselineOffset(metrics);
	}
	return baseline;
    }

    public Font getFont(FontMetrics metrics) {
	Font font = metrics.getFont();

	if(scriptLevel != NORMALSCRIPT) {
	    font = new Font(font.getName(), font.getStyle(), 
			    (int)(0.5 + 
				  font.getSize() *
				  Math.pow(fontScale, Math.abs(scriptLevel))));
	}

	return font;
    }

    public int getAscent(FontMetrics metrics)
    {
	if(scriptLevel == NORMALSCRIPT)
	    return metrics.getAscent();

	return (int)(0.5 + 
		     metrics.getAscent() * 
		     Math.pow(fontScale, Math.abs(scriptLevel)));
    }

    public static int getHeight(FontMetrics metrics)
    {
	return (int)(0.5 + /*metrics.getLeading()*/ + (metrics.getHeight() /*- metrics.getLeading()*/) * maxHeightScale);
    }

    public int hashCode() {
	Integer level = new Integer(scriptLevel);
	int hash = level.hashCode();
	if (script != null) hash ^= script.hashCode();
	return hash;
    }
    /*
    public String toString() {
	StringBuffer buffer = new StringBuffer();
    }
    */
}
