/*
 * Icon.java
 *
 * Copyright (c) 2002 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: Icon.java,v 1.1 2002/04/24 01:52:14 nozomi Exp $
 * $Log: Icon.java,v $
 * Revision 1.1  2002/04/24 01:52:14  nozomi
 * VImage implements Icon
 *
 */

package jp.kyasu.graphics;

import java.awt.Component;
import java.awt.Graphics;

/**
 * Icon is a fixed size image used to decorate components.
 *
 * @see ImageIcon
 *
 * @version 	24 Apr 2002
 * @author 	Nozomi `James' Ytow
 */
public interface Icon
{
    /**
     * Drows an <code>Icon</code> at specified position.
     * Implementations of <code>Icon</code> use <code>component</code>
     * to get propaties such as fourgournd or background color.
     *
     * @param component <code>Component</code> from which propaties are obtained.
     * @param graphics <code>Graphics</code> where the <code>Icon</code> will be drawn
     * @param x <code>int</code> specifies x coordinate where the <code>Icon</code> will be drawn
     * @param y <code>int</code> specifies y coordinate where the <code>Icon</code> will be drawn
     */
    public void paintIcon(Component component,
			  Graphics graphics,
			  int x,
			  int y);

    /**
     * Returns width of the <code>Icon</code>
     *
     * @return int representing width of the <code>Icon</code>
     */
    public int getIconWidth();

    /**
     * Returns height of the <code>Icon</code>
     *
     * @return int representing height of the <code>Icon</code>
     */
    public int getIconHeight();
}
