/*
 * VDashedTabBorder.java
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: VDashedTabBorder.java,v 1.2 2002/09/22 19:47:19 nozomi Exp $
 * $Log: VDashedTabBorder.java,v $
 * Revision 1.2  2002/09/22 19:47:19  nozomi
 * KFC style copyright
 *
 * Revision 1.1.1.1  2002/01/16 12:33:32  ryo
 * initial import into CVS
 */

package jp.kyasu.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

/**
 * The <code>VDashedTabBorder</code> class implements a tab border.
 *
 * @version 	10 Nov 2001
 * @author 	Nozomi `James' Ytow
 */
public class VDashedTabBorder
    extends VTabBorder
{

    /**
     * Constructs a tab border.
     */
    public VDashedTabBorder()
    {
	this(0, 0, VTab.TOP);
    }

    /**
     * Constructs a tab border with the specified width and height.
     *
     * @param width  the width of the horizontal line border.
     * @param height the height of the horizontal line border.
     */
    public VDashedTabBorder(int width, int height, int placement)
    {
	super(width, height, placement);
    }

    /**
     * Paints the tab border at the specified location,
     * with the specified dimension.
     * @see jp.kyasu.graphics.VBorder#paint(java.awt.Graphics, int, int, int, int)
     */
    public void paint(Graphics g, int x, int y, int width, int height)
    {
	return;
	/*
	int dx, dy, limit, slopeOffset;

	switch(tabPlacement){
	case VTab.TOP:
	case VTab.BOTTOM:

	    slopeOffset = height / 2;
	    switch(tabPlacement){
	    case VTab.TOP:
		// top
		dx = x + slopeOffset;
		dy = y;
		limit = x + width - slopeOffset;
		for (; dx < limit; dx += 2) {
		    g.drawLine(dx, dy, dx, dy);
		}

		// right
		dx = x + width - 1 - slopeOffset;
		dy = y;
		limit = y + height;
		for (; dy < limit; dy += 2, dx += 1) {
		    g.drawLine(dx, dy, dx, dy);
		}
		
		// do not draw bottom

		// left
		dx = x;
		dy = y;
		limit = y + height - 1;
		for (; dy >= limit; dy -= 2, dx -= 1) {
		    g.drawLine(dx, dy, dx, dy);
		}
		break;

	    case VTab.BOTTOM:
		// do not draw top
		
		// right
		dx = x + width - 1;
		dy = y;
		limit = y + height;
		for (; dy < limit; dy += 2, dx -= 1) {
		    g.drawLine(dx, dy, dx, dy);
		}
		
		// bottom
		dx = x + width - 1 - slopeOffset;
		dy = y + height - 1;
		limit = x + slopeOffset;
		for (; dx >= limit; dx -= 2) {
		    g.drawLine(dx, dy, dx, dy);
		}
		
		// left
		dx = x;
		dy = y + height - 1;
		limit = y;
		for (; dy >= limit; dy -= 2, dx += 1) {
		    g.drawLine(dx, dy, dx, dy);
		}
		break;
	    }
	    break;

	case VTab.RIGHT:
	case VTab.LEFT:

	    slopeOffset = width / 2;

	    switch (tabPlacement) {
	    case VTab.RIGHT:
		// top
		dx = x;
		dy = y;
		limit = x + width;
		for (; dx < limit; dx += 2, dy += 1) {
		    g.drawLine(dx, dy, dx, dy);
		}

		// right
		dx = x + width - 1;
		dy = y + slopeOffset;
		limit = y + height - slopeOffset;
		for (; dy < limit; dy += 2) {
		    g.drawLine(dx, dy, dx, dy);
		}

		// bottom
		dx = x + width - 1;
		dy = y + height - 1 - slopeOffset;
		limit = x;
		for (; dx >= limit; dx -= 2, dy += 1) {
		    g.drawLine(dx, dy, dx, dy);
		}

		// do not draw left

		break;

	    case VTab.LEFT:
		// top
		dx = x;
		dy = y + slopeOffset;
		limit = x + width;
		for (; dx < limit; dx += 2, dy -= 1) {
		    g.drawLine(dx, dy, dx, dy);
		}

		// do not draw right

		// bottom
		dx = x + width - 1;
		dy = y + height - 1;
		limit = x;
		for (; dx >= limit; dx -= 2, dy -= 1) {
		    g.drawLine(dx, dy, dx, dy);
		}

		// left
		dx = x;
		dy = y + height - 1 - slopeOffset;
		limit = y + slopeOffset;
		for (; dy >= limit; dy -= 2) {
		    g.drawLine(dx, dy, dx, dy);
		}
		break;
	    }
	    break;

	default:
	}
	*/
    }

}
