/*
 * VTabBorder.java
 *
 * Copyright (c) 2001 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee or royalty is hereby
 * granted, provided that both the above copyright notice and this
 * permission notice appear in all copies of the software and
 * documentation or portions thereof, including modifications, that you
 * make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
 * COPYRIGHT HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE
 * OR DOCUMENTATION.
 */
/*
 * $Id: VTabBorder.java,v 1.2 2002/09/22 19:47:19 nozomi Exp $
 * $Log: VTabBorder.java,v $
 * Revision 1.2  2002/09/22 19:47:19  nozomi
 * KFC style copyright
 *
 * Revision 1.1.1.1  2002/01/16 12:33:32  ryo
 * initial import into CVS
 */

package jp.kyasu.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

/**
 * The <code>VTabBorder</code> class implements a tab border.
 *
 * @version 	10 Nov 2001
 * @author 	Nozomi `James' Ytow
 */
public class VTabBorder
    extends VBorder
{

    //tab placement holder
    int tabPlacement;

    /**
     * Constructs a tab border.
     */
    public VTabBorder()
    {
	this(0, 0, VTab.TOP);
    }

    /**
     * Constructs a tab border with the specified width and height.
     *
     * @param width  the width of the horizontal line border.
     * @param height the height of the horizontal line border.
     */
    public VTabBorder(int width, int height, int placement)
    {
	super(width, height);
	tabPlacement = placement;
    }


    /**
     * Returns the insets of this horizontal line border.
     * @see jp.kyasu.graphics.VBorder#getInsets()
     */
    public Insets getInsets() {
	return new Insets(1, 1, 1, 1);
    }

    /**
     * Paints the tab border at the specified location,
     * with the specified dimension.
     * @see jp.kyasu.graphics.VBorder#paint(java.awt.Graphics, int, int, int, int)
     */
    public void paint(Graphics g, int x, int y, int width, int height) {

	int dx, dy, limit, slopeOffset;

	switch(tabPlacement){
	case VTab.TOP:
	case VTab.BOTTOM:

	    slopeOffset = height / 2;

	    switch(tabPlacement){
	    case VTab.TOP:
		// top
		g.drawLine(x + slopeOffset, y,
			   x + width - slopeOffset, y);

		// right
		g.drawLine(x + width - 1 - slopeOffset, y,
			   x + width, y + height);
		
		// do not draw bottom

		// left
		g.drawLine(x, y + height - 1,
			   x + slopeOffset, y);
		break;

	    case VTab.BOTTOM:
		// do not draw top
		
		// right
		g.drawLine(x + width - 1, y,
			   x + width - slopeOffset, y + height);

		// bottom		
		dy = y + height - 1;
		g.drawLine(x + width - 1 - slopeOffset, dy,
			   x + slopeOffset, dy);
		
		// left
		g.drawLine(x, y, x - slopeOffset, y + height);
		break;
	    }
	    break;

	case VTab.RIGHT:
	case VTab.LEFT:

	    slopeOffset = width / 2;

	    switch (tabPlacement) {
	    case VTab.RIGHT:
		// top
		g.drawLine(x + width, y, x + width, y + slopeOffset);

		// right
		dx = x + width - 1;
		g.drawLine(dx, y + slopeOffset, 
			   dx, y + height - slopeOffset);

		// bottom
		g.drawLine(x, y + height, 
			   x + width, y + height - slopeOffset);

		// do not draw left

		break;

	    case VTab.LEFT:
		// top
		g.drawLine(x, y + slopeOffset,
			   x + width, y);

		// do not draw right

		// bottom
		g.drawLine(x, y + height - slopeOffset,
			   x + width, y + height);
		    
		// left
		g.drawLine(x, y + slopeOffset,
			   x, y + height - slopeOffset);
		break;
	    }
	    break;

	default:
	}

    }

    /**
     *
     * Returns placement of tab 
     *
     * @see setTabPlacement(int)
     */
    public int getTabPlacement()
    {
	return tabPlacement;
    }
        
    /**
     *
     * Returns tab placement which is one of:
     * <UL>
     * <LI>VTab.TOP 
     * <LI>VTab.BOTTOM 
     * <LI>VTab.LEFT 
     * <LI>VTab.RIGHT 
     * </UL>
     * Default placement is <code>VTab.TOP</code>
     *
     * @param placement placement of tab to the contents
     *
     * @exception IllegalArgumentException if tabPlacement is not any of above 
     * valid values.
     *
     * @see getTabPlacement()
     */
    public void setTabPlacement(int placement)
    {
	tabPlacement = placement;
    }
}
