/*
 *
 * Affiliation.cxx: an implementation of class to hold affiliation record
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Affiliation.cxx,v 1.1.2.1 1999/08/21 06:20:58 nozomi Exp $
 *	$Log: Affiliation.cxx,v $
 *	Revision 1.1.2.1  1999/08/21 06:20:58  nozomi
 *	add method _Affiliation for private use
 *	
 *	Revision 1.2  1999/08/21 00:50:12  nozomi
 *	add method _Affiliation for private use
 *	
 *	Revision 1.1  1999/03/21 13:42:43  nozomi
 *	operator< (Affiliation&, Affiliation&)
 *	
 *	Revision 1.0.0  1999/03/14 02:14:59  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "Affiliation.h"
/*
  char* _affiliation;
  Date frm;
  Date untl;
  void set_affil(char*);
  */
Affiliation::Affiliation(const char* s)
  : _from(), _until() {_Affiliation(s);}

void Affiliation::_Affiliation(const char* s)
{
  int l;
  if(NULL == s || 0 == (l = strlen(s))) { _affiliation = strdup();return;}

  const char *f;
  int i;
  for(i = 0, f = s; i < l && (isspace(*f) || isalnum(*f)); f++, i++){}
  if(i == l){ _affiliation= new_strdup::strdup(s);return;}
  const char separator = *f;
  const char *tmp = f - 1;

  //skip heading ws
  for(i = 0, f = s; i < l && isspace(*f); f++, i++){}
  //skip tailing ws
  for(i = 0; i < tmp - f && isspace(*tmp); tmp--, i++){}
  int al = tmp + 1 - f;
  _affiliation= strndup(f, al);

  for(i = 0, al = 0, f = s; i < l; f++, i++){if(separator == *f) al++;}
  switch(al){
  case 1:
    for(i = 0, f = s; i < l && separator != *f++; i++){}
    for(; i < l && isspace(*f);f++, i++){}
    _until = Date(f); _from = Date(f); break;
  case 2:
    for(i = 0, f = s; i < l && separator != *f++; i++){}
    for(; i < l && isspace(*f);f++, i++){}
    for(tmp = f; i < l && separator != *tmp++; i++){}
    _from = Date(f, tmp - f - 1);
    for(; i < l && isspace(*tmp);tmp++, i++){}
    _until = Date(tmp); break;
  case 3:
    for(i = 0, f = s; i < l && separator != *f++; i++){}
    for(; i < l && isspace(*f);f++, i++){}
    _until = Date(f); _from = Date(f); break;
  case 6:
    for(i = 0, f = s; i < l && separator != *f++; i++){}
    for(; i < l && isspace(*f);f++, i++){}
    _from = Date(f);
    for(; i < l && separator != *f++; i++){}
    for(; i < l && separator != *f++; i++){}
    for(; i < l && separator != *f++; i++){}
    for(; i < l && isspace(*f);f++, i++){}
    _until = Date(f); break;
  default:
    break;
  }
  return;
}
#if 0
Affiliation::Affiliation(const NamedField & nf, const char *fn)
  : _from(), _until()
{
  if(strcmp(nf.entryName(), fn)) { _affiliation = new char[1];*_affiliation = 0;return;}
  const char* s;
  if(strlen(s = nf.strcmp(fn))){
    _Affiliation(s);
  }
  else{
    if(NULL != (s = nf.strcasecmp("name")))
      {
	_affiliation= new_strdup::strdup(s);
      }
    if(NULL != (s = nf.strcasecmp("from")))
      _from = Date(s);
    if(NULL != (s = nf.strcasecmp("to")))
      _until = Date(s); 
  }
}
#endif
Affiliation::Affiliation(const NamedField *nf, const char *fn)
  : _from(), _until()
{
  if(strcmp(nf->entryName(), fn)) { _affiliation = new char[1];*_affiliation = 0;return;}
  const char* s;
  if(strlen(s = nf->strcmp(fn))){
    _Affiliation(s);
  }
  else{
    if(NULL != (s = nf->strcasecmp("name")))
      {
	_affiliation= new_strdup::strdup(s);
      }
    if(NULL != (s = nf->strcasecmp("from")))
      _from = Date(s);
    if(NULL != (s = nf->strcasecmp("to")))
      _until = Date(s); 
  }
}


bool operator<(const Affiliation & a1, const Affiliation & a2)
{
  if(a1._from != a2._from)
    return a1._from < a2._from;
  else
    return strcmp(a1._affiliation, a2._affiliation) < 0;
}
