/*
 *
 * Affiliation.h: a definition of class to hold affiliation record
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Affiliation.h,v 1.5 1999/12/05 18:20:13 nozomi Exp $
 *	$Log: Affiliation.h,v $
 *	Revision 1.5  1999/12/05 18:20:13  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.4  1999/08/23 06:53:04  nozomi
 *	cosmetics
 *	
 *	Revision 1.3  1999/08/21 00:49:38  nozomi
 *	add method _Affiliation for private use
 *	
 *	Revision 1.2  1999/03/21 07:52:39  nozomi
 *	operator < (Affiliation&, Affiliation&)
 *	
 *	Revision 1.1  1999/03/15 16:42:43  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:15:15  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

// class Affiliation holds a combination institution etc. (as char*),
// Dates of beginning and ending.

#if !(defined _INCLUDED_AFFILIATION_H)
#define  _INCLUDED_AFFILIATION_H
#include "Date.h"
#if !defined (_INCLUDED_NAMEDFIELD_H)
#include "NamedField.h"
#endif

#if (__GNUC_MINOR__ > 7)
#if !defined (_INCLUDED_STRING)
#include <string>
#define _INCLUDED_STRING
#endif
#if !defined (_INCLUDED_CSTRING)
#include <cstring>
#define _INCLUDED_CSTRING
#endif
#if !defined (_INCLUDED_LIST)
#include <list>
#define _INCLUDED_LIST
#endif
#else
#if !defined (_INCLUDED_STRING)
#include <string.h>
#define _INCLUDED_STRING
#endif
#if !defined (_INCLUDED_CSTRING)
#include <cstring.h>
#define _INCLUDED_CSTRING
#endif
#if !defined (_INCLUDED_LIST)
#include <list.h>
#define _INCLUDED_LIST
#endif
#endif

class Affiliation
{
public:
  //constructors
  Affiliation(void);
  Affiliation(const Affiliation&);
  Affiliation& operator=(const Affiliation& a);

  Affiliation(const char* a);
  Affiliation(const char* a, int yr);
  Affiliation(const NamedField & nf, const char* fn = "Affiliation");
  Affiliation(const NamedField * nf, const char* fn = "Affiliation");
  Affiliation(const char* a, Date f, Date u);

  //the destructgor
  inline ~Affiliation();

  // I/O
  friend istream& operator>>(istream & s, Affiliation &a);
  friend ostream& operator<<(ostream & s, const Affiliation &a);

  //accessor
  const char* affiliation(void)const;
  Date from(void) const;
  Date until(void) const;

  //manipurator
  string affiliation(string);
  Date from(int);
  Date until(int);
  Date from(Date);
  Date until(Date);
  Date at(int);
  Date at(Date);

  //boolian


  bool in(int) const;
  bool in(Date) const;

  friend bool operator<(const Affiliation &, const Affiliation &);

private:
  Date _from;
  Date _until;
  char* _affiliation;
  void set_affil(const char*);
  static const char* const _classname = "Affiliation";
  void _Affiliation(const char* a);
};


inline void Affiliation::set_affil(const char* s)
{ 
  //  delete [] _affiliation;
  if(NULL == s)_affiliation = new_strdup::strdup("");
  else _affiliation = new_strdup::strdup(s);
}

inline Affiliation::Affiliation(void)
  :_from(), _until(), _affiliation(strdup("")){}

inline Affiliation::Affiliation(const NamedField & nf, const char *fn)
  : _from(), _until() {*this = Affiliation(&nf, fn);}

inline Affiliation::Affiliation(const char* a, int yr)
  :_from(yr), _until(yr) {set_affil(a);}

inline Affiliation::Affiliation(const char* a, Date f, Date u)
  :_from(f), _until(u) {set_affil(a);}

inline Affiliation::Affiliation(const Affiliation& a)
  :_from(a._from), _until(a._until), _affiliation(new_strdup::strdup(a._affiliation)){}

inline Affiliation& Affiliation::operator=(const Affiliation& a)
{_from = a._from; _until = a._until; delete [] _affiliation; set_affil(new_strdup::strdup(a._affiliation)); return *this;}

inline Affiliation::~Affiliation(void)
{delete [] _affiliation;}

inline istream& operator>>(istream & s, Affiliation &a)
{ NamedField nf; s >> nf; a = Affiliation(nf); return s;}

inline ostream& operator<<(ostream & s, const Affiliation &a)
{s << a._affiliation<<"/"<< a._from <<"/"<< a._until; return s;}

inline const char* Affiliation::affiliation(void)const
{
  return _affiliation;
}

inline Date Affiliation::from(void) const {return _from;}

inline Date Affiliation::until(void) const {return _until;}

inline bool Affiliation::in(int y) const
{
  if(y < _from.year() || y > _until.year()) return false;
  else return true;
}

inline bool Affiliation::in(Date d) const
{
  if(d < _from || d > _until) return false;
  else return true;
}

//manipurator
inline string Affiliation::affiliation(string a)
{
  string s(_affiliation);
  delete [] _affiliation;
  _affiliation = strdup(a.data());
  return s;
}

inline Date Affiliation::from(int y)
{
  if(y != Date::invalidYear &&
     (_from.year() == Date::invalidYear ||
      (_from.year() != Date::invalidYear
       && _from.year() > y)
      )
     )
    {
      _from.year(y);
      _from.month(Date::invalidMonth);
      _from.day(Date::invalidDay);
    }
  
  return _from;
    
}

inline Date Affiliation::until(int y)
{
  if(y != Date::invalidYear &&
     (_until.year() == Date::invalidYear ||
      (_until.year() != Date::invalidYear
       && _until.year() < y)
      )
     )
    {
      _until.year(y);
      _until.month(Date::invalidMonth);
      _until.day(Date::invalidDay);
    }
  
  return _until;
    
}

inline Date Affiliation::from(Date d)
{
  if(d.valid()) {
    if(_from.invalid() ||
       (_from.valid() && _from > d))
      _from = d;
  }
  return _from;
}

inline Date Affiliation::until(Date d)
{
  if(d.valid()) {
    if(_until.invalid() ||
       (_until.valid() && _until > d))
      _until = d;
  }
  return _until;
}

inline Date Affiliation::at(int y)
{
  until(y);
  return from(y);
}

inline Date Affiliation::at(Date d)
{
  until(d);
  return from(d);
}

#if 0
//boolian
inline pbool Affiliation::in(int y) const
{
  if(y == Date::invalidYear ||
     (_from.invalid() && _until.invalid())
    )
    return false;

  if(_from.valid() && _until.valid()){
    if(y < _from.year() || y > _until.year())
      return false;
    return true;
  }

  if((_from.valid() && y > _from.year()) ||
     (_until.valid() && y < _until.year()))
    return ture;
  reutrn false;
}

inline bool Affiliation::in(Date d) const
{ return in(d.year()); }


#endif
#endif //_INCLUDED_AFFILIATION_H
