/*
 *
 * Annotation.h: an implementation of annotational persistent class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Annotation.cxx,v 1.11 1999/12/05 18:23:37 nozomi Exp $
 *	$Log: Annotation.cxx,v $
 *	Revision 1.11  1999/12/05 18:23:37  nozomi
 *	improve merge code
 *	
 *	Revision 1.10  1999/09/23 06:26:24  nozomi
 *	resolve method using Resolver
 *	
 *	Revision 1.9  1999/09/20 14:13:32  nozomi
 *	modification relationg deta addition
 *	
 *	Revision 1.8  1999/08/31 12:13:10  nozomi
 *	d_Ref<NameRecord>s are held as lists intead of sets
 *	
 *	Revision 1.7  1999/08/16 07:03:05  nozomi
 *	NameRecord::persistentID() version 2 support
 *	
 *	Revision 1.6  1999/08/11 07:33:01  nozomi
 *	add type entry
 *	
 *	Revision 1.5  1999/03/21 22:32:33  nozomi
 *	ptr() check in merge()
 *	
 *	Revision 1.4  1999/03/21 13:47:55  nozomi
 *	minor bug fix in readin format
 *	
 *	Revision 1.3  1999/03/21 05:46:36  nozomi
 *	output format was modified
 *	unused, commented out lines were deleted
 *	
 *	Revision 1.2  1999/03/20 16:06:16  nozomi
 *	deta merge code. still restrictive, i.e. only act presistendIDs are identical
 *	
 *	Revision 1.1  1999/03/14 18:12:20  nozomi
 *	minor modification in pointer resolve
 *	
 *	Revision 1.0  1999/03/14 02:15:33  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "d_Ref.h"
#include "Annotation.h"
#include "NameRecord.h"
#include "Publication.h"
#include "Author.h"

//list of linkage types
const Annotation::annoTuple Annotation::tuple[] = {
  {"Annotation", 4},
  {"refer", 3},      // 1 to 1
  {"sensu", 5},      // 1 to 1
  {"revise", 3},     // 1 to 1
  {"synonymize", 3}, // 1 to n
  {"homonymize", 3}, // n to n
  {"part", 4},       // n to 1
  {"equivate", 2},   // n to zero 
  {"nov", 3},        // 1 to zero 
  {"assign", 3},     // 1 to 1
  {"propagate", 4},     // 1 to 1
  {"combination", 3},     // 1 to 1
  {"nomen", 3},     // 1 to 1
  {NULL, 0},
};

//list of reasoning.... need more consideration
const Annotation::annoTuple Annotation::reasons[] = {
  {"Annotation", 4},
  {"refer", 3},      // 1 to 1
  {"sensu", 5},      // 1 to 1
  {"revise", 3},     // 1 to 1
  {"synonym", 3}, // 1 to n
  {"homonym", 3}, // n to n
  {"part", 4},       // n to 1
  {"equivalence", 2},   // n to zero 
  {"nov", 3},        // 1 to zero 
  {"assign", 3},     // 1 to 1ero 
  {"propagate", 4},     // 1 to 1
  {"combination", 3},     // 1 to 1
  {"nomen", 3},     // 1 to 1
  {NULL, 0},
};


string Annotation::annotation(const char* s)
{ string ret(s); delete [] _annotation; _annotation = new_strdup::strdup(s);return ret;}

string Annotation::persistentID(void) const
{
  string s(_classname);
  s += "::";
  s += _annotation;
  s += "_";
  if(!from.empty()){
    list<string> _from;
    list<d_Ref<NameRecord> >::const_iterator iter = from.begin();
    list<d_Ref<NameRecord> >::const_iterator end = from.end();
    while(iter != end){
      string str("");
      if(NULL != iter->ptr())
	str = iter->ptr()->persistentID();
      else
	str = iter->persistentID();
      _from.push_back(str);
      ++iter;
    }
    _from.sort();
    s += *_from.begin();
  }
  return s;
}

Annotation& Annotation::operator=(const Annotation& a)
{
  from = a.from; to = a.to; 
  delete [] _annotation;
  _annotation = new_strdup::strdup(a._annotation);
  return *this;
}

#if 0
Annotation::Annotation(const char *a, const char *s)
  :d_Object(_classname), from(), to()
{

}
#endif

void Annotation::_Annotation(const char *s)
{
  d_Ref<NameRecord> *nr = new d_Ref<NameRecord>;
  if(!strncmp(_annotation, "nov", 3) && !strcmp(s, "nov")) return;
  if(!strncmp(s, "NameRecord::", 12)){
    nr->persistentID(NameRecord::persistentID(s));
  }
  else{
    string str("NameRecord::");
    str += s;
    char *ss = strdup(str);
    nr->persistentID(ss);
    delete [] ss;
  }
  to.push_back(*nr);
}


void Annotation::_Annotation(const NamedField& nf, const char* fn, size_t n)
{
  if(n == 0) n = strlen(fn);
  if(strncmp(nf.entryName(), fn, n)){_annotation = strdup();return;}

  delete [] _annotation;
  _annotation = new_strdup::strdup(fn);
  const char* s;
  s = nf.strncmp(fn, n);
  if(strlen(s)){_Annotation(s);return;}

  list<NamedField>::const_iterator tmp;
  list<d_Ref<NameRecord> > *pushto;
  for(tmp = nf.subEntries.begin(); tmp != nf.subEntries.end(); ++tmp){
    s = tmp->entryName();
    if(!strcmp(s, "persistentID")){
      s = tmp->contents() + 12;  //strlen("Annotation::");
      if(strncmp(s, _annotation, strlen(_annotation))){
	delete [] _annotation;
	_annotation = s;
	for(;*s && '_' != *s; s++);
	_annotation = strndup(_annotation, s - _annotation);
      }
    }
    else if(!strcmp(s, "reason")){
      delete [] _annotation;
      _annotation = new_strdup::strdup(tmp->contents());
    }
    else{
      pushto = &to;
      if(!strcmp(s, "from"))
	pushto = &from;
      if(strlen(s = tmp->contents())){
	if(!strncmp(s, "NameRecord::", 12)){
	  d_Ref<NameRecord> *dnr = new d_Ref<NameRecord>;
	  dnr->persistentID(NameRecord::persistentID(s));
	  pushto->push_back(*dnr);
	}
	else pushto->push_back(d_Ref<NameRecord>(new NameRecord(s)));
      }
      else{
      	d_Ref<NameRecord> *dnr = new d_Ref<NameRecord>(new NameRecord(*tmp));
	pushto->push_back(*dnr);
      }
    }
  }
}

Annotation::Annotation(void)
  :d_Object(_classname),
   from(), to(),
   _annotation(strdup()),
   _publication(),
   _citation(){}

Annotation::Annotation(const Annotation& a)
  :d_Object(_classname),
   from(a.from), to(a.to),
   _annotation(strdup(a._annotation)),
   _publication(a._publication),
   _citation(a._citation) {}

Annotation::Annotation(const NamedField& nf, const char* fn, size_t n)
  :d_Object(_classname),
   from(), to(),
   _annotation(strdup()),
   _publication(),
   _citation() 
{_Annotation(nf, fn, n);}

Annotation::Annotation(NameRecord* nr, const NamedField& nf, const char* fn, size_t n)
  :d_Object(_classname),
   from(), to(),
   _annotation(strdup()),
   _publication(nr->recorder()->publication()),
   _citation(nr->recorder())
{_Annotation(nf, fn, n); if(strlen(_annotation)) from.push_back(d_Ref<NameRecord>(nr));}

istream& operator>>(istream & s, Annotation& a)
{
  NamedField nf;
  s >> nf;
  bool yet = true;
  const Annotation::annoTuple *t = a.tuple;
  const char* fn = nf.entryName();
  while(t->str && yet){
    if(!strncasecmp(t->str, fn, t->n)){
      a._Annotation(nf, fn, t->n);
      yet = false;
    }
    t++;
  }
  return s;
}

ostream& operator<<(ostream & s, Annotation& a)
{
  if(a.from.empty() && a.to.empty() && 0 == *a._annotation) return s;

  s << a._classname << " = {\n";
  s << " persistentID = {" << a.persistentID() << "}\n";
  /*
  if(!a.from.empty()){
    NameRecord *nr = a.from.begin()->ptr();
    s << " citation = {" << nr->recorder().persistentID() << "}\n";
  }
  */
  /*  if(a._citation.ptr() != NULL){*/
  string pid(a._citation.persistentID());
  if(pid.length() > 0)
    s << " citation = {" << pid << "}\n";
  //}

  s << " reason = {"<< a._annotation << "}\n";
  list<d_Ref<NameRecord> >::const_iterator iter;
  string str;
  if(!a.from.empty()){
    for(iter = a.from.begin(); iter != a.from.end(); ++iter){
      str = NameRecord::persistentID(iter->persistentID().c_str());
      if(!iter->ptr())
	s << "%unsolved\n";
      if(0 != str.length())
	s << " from = {" << str << "}\n";
    }
  }
  if(!a.to.empty() && strcmp(a._annotation, "nov")){
    for(iter = a.to.begin(); iter != a.to.end(); ++iter){
      str = NameRecord::persistentID(iter->persistentID().c_str());
      if(!iter->ptr())
	s << "%unsolved\n";
      if(0 != str.length())
	s << " to = {" << str << "}\n";
    }
  }
  s << "}\n";
  return s;
}

Annotation* Annotation::resolve(hash_map<string, list<NameRecord*>, Hash<string> > &nr,
			 hash_map<string, list<Annotation*>, Hash<string> > &an,
			 hash_map<string, list<Citation*>, Hash<string> > &ci,
			 hash_map<string, list<Publication*>, Hash<string> > &pub,
			 hash_map<string, list<Author*>, Hash<string> > &au,
			 hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr,
			 hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > &uan,
			 hash_map<string, list<d_Ref<Citation>*>, Hash<string> > &uci,
			 hash_map<string, list<d_Ref<Publication>*>, Hash<string> > &upub,
			 hash_map<string, list<d_Ref<Author>*>, Hash<string> > &uau)
{
  string s(persistentID());

  hash_map<string, list<Annotation*>, Hash<string> >::iterator aniter = an.find(s);
  if(aniter != an.end()){
    list<Annotation*>::iterator iter = aniter->second.begin();
    list<Annotation*>::iterator end = aniter->second.end();
    while(iter != end){
      if(this == *iter)
	return NULL; //don't delete this
#if 0 //bad
      else if((*iter)->merge(this))
	return *iter; //delete this
#endif
      ++iter;
    }
  }

  an[s].push_back(this);

  hash_map<string, list<d_Ref<Annotation>*>, Hash<string> >::iterator diter = uan.find(s);

  if(diter != uan.end()){
    list<d_Ref<Annotation>*>::iterator iter = diter->second.begin();
    list<d_Ref<Annotation>*>::iterator end = diter->second.end();
    while(iter != end){
      if(s == (*iter)->persistentID() && NULL == (*iter)->ptr())
	(*iter)->ptr(this);
      ++iter;
    }
  }

  if(!from.empty()){
    list<d_Ref<NameRecord> >::iterator iter = from.begin();
    list<d_Ref<NameRecord> >::iterator end = from.end();
    while(iter != end){
      if(NULL != iter->ptr()){
	NameRecord *p = (*iter)->resolve(nr, an, ci, pub, au, unr, uan, uci, upub, uau);
	if(NULL != p){
	  //delete *iter!
	}
	  
      }
      else{
	iter->resolve(nr, unr);
      }
      ++iter;
    }
  }

  if(!to.empty()){
    list<d_Ref<NameRecord> >::iterator iter = to.begin();
    list<d_Ref<NameRecord> >::iterator end = to.end();
    while(iter != end){
      if(NULL != iter->ptr()){
	NameRecord *p = (*iter)->resolve(nr, an, ci, pub, au, unr, uan, uci, upub, uau);
	if(NULL != p){
	  //delete *iter!
	}
      }
      else{
	iter->resolve(nr, unr);
      }
      ++iter;
    }
  }

  return NULL;
}

Annotation* Annotation::resolve(Resolver &r)
{
  string s(persistentID());

  hash_map<string, list<Annotation*>, Hash<string> >::iterator aniter = r.an.find(s);
  if(aniter != r.an.end()){
    list<Annotation*>::iterator iter = aniter->second.begin();
    list<Annotation*>::iterator end = aniter->second.end();
    while(iter != end){
      if(this == *iter)
	return this; //don't delete this
      else if((*iter)->merge(this))
      	return *iter; //delete this
      ++iter;
    }
  }

  r.an[s].push_back(this);
  r.newAnnotations.push_back(this);

  hash_map<string, list<d_Ref<Annotation>*>, Hash<string> >::iterator diter = r.uan.find(s);

  if(diter != r.uan.end()){
    register list<d_Ref<Annotation>*>::iterator iter = diter->second.begin();
    register list<d_Ref<Annotation>*>::iterator end = diter->second.end();
    register list<d_Ref<Annotation>*>::iterator current;
    while(iter != end){
      current = iter;
      ++iter;
      if(s == (*current)->persistentID() && NULL == (*current)->ptr()){
	(*current)->ptr(this);
	diter->second.erase(current);
      }
    }
  }

  if(!from.empty()){
    list<d_Ref<NameRecord> >::iterator iter = from.begin();
    list<d_Ref<NameRecord> >::iterator end = from.end();
    while(iter != end){
      NameRecord *p = iter->ptr();
      if(NULL != p){
	NameRecord *q = p->resolve(r);
	if(q != p)
	  iter->ptr(q);
      }
      else{
	iter->resolve(r.nr, r.unr);
      }
      ++iter;
    }
  }

  if(!to.empty()){
    list<d_Ref<NameRecord> >::iterator iter = to.begin();
    list<d_Ref<NameRecord> >::iterator end = to.end();
    while(iter != end){
      NameRecord *p = iter->ptr();
      if(NULL != p){
	NameRecord *q = p->resolve(r);
	if(q != p)
	  iter->ptr(q);
      }
      else{
	iter->resolve(r.nr, r.unr);
      }
      ++iter;
    }
  }

  return this;
}

static bool sameLinkType(const char *type1, const char *type2)
{
  return 0 == strcasecmp(type1, type2);
}

bool Annotation::merge(Annotation* a)
{
  static const bool refuse = false;
  bool ret = refuse;

  /*
   * identical object's' can't be merged
   */
  if(this == a) 
    return refuse;

  /*
   * if 'linktypes' are differ, cant merged;
   */
  if(!sameLinkType(_annotation, a->_annotation))
    return refuse;

#if 0
  delete[] a->_annotation;
  a->_annotation = strdup();
#endif

  /*
   * Before merging pointer to NameRecords, make pointers pointing to Annotation
   * to be merged to point to this Annotation
   */
  register list<d_Ref<NameRecord> >::iterator iter = a->from.begin();
  register list<d_Ref<NameRecord> >::iterator end = a->from.end();
  while(iter != end){
    NameRecord *nr = iter->ptr();
    if(NULL != nr){
      register list<d_Ref<Annotation> >::iterator ai = nr->annotation.begin();
      register list<d_Ref<Annotation> >::iterator ae = nr->annotation.end();
      while(ai != ae){
	if(ai->ptr() == a)
	  ai->ptr(this);
	ai++;
      }
    }
    ++iter;
  }

  /*
   * and then merge NameRecords
   */
  from.merge(a->from);
  //  from.unique();

  /*
   * 'to' pointers can be merged directly
   */
  to.merge(a->to);
  //  to.unique();

  /*
   * merge Citations
   */
  Citation *c = (a->_citation).ptr();

  if(c != NULL){
    register list<d_Ref<Annotation> >::iterator ai = c->annotations.begin();
    register list<d_Ref<Annotation> >::iterator ae = c->annotations.end();
    while(ai != ae){
      if(ai->ptr() == a)
	ai->ptr(this);
      ai++;
    }
    if(_citation.ptr() == NULL)
      _citation.ptr(c);
    else{
      _citation.ptr()->merge(c);
    }
  }

  else if(_citation.ptr() != NULL)
    (a->_citation).ptr(_citation.ptr());

  else //both _citation are dummy pointr
    _citation.merge(a->_citation);

  return !refuse;
}

bool Annotation::merge(d_Ref<Annotation>* da)
{
  bool ret = false;
  if(persistentID() != da->persistentID()) return ret;
  return merge(da->ptr());
}

bool operator<(const Annotation &a1, const Annotation &a2)
{
  if(a1.persistentID() != a2.persistentID())
    return a1.persistentID() < a2.persistentID();
  return &a1 < &a2; //XXX
}

bool operator==(const Annotation &a1, const Annotation &a2)
{
  if(&a1 == &a2 || a1.persistentID() == a2.persistentID())
    return true;
  return false;
}
