/*
 *
 * Annotation.h: a definition of annotational persistent class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Annotation.h,v 1.7 1999/12/05 20:47:23 nozomi Exp $
 *	$Log: Annotation.h,v $
 *	Revision 1.7  1999/12/05 20:47:23  nozomi
 *	removed unnecessary include/declare
 *	
 *	Revision 1.6  1999/12/05 18:20:19  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.5  1999/09/23 06:27:11  nozomi
 *	resolve method using Resolver class
 *	
 *	Revision 1.4  1999/08/31 12:12:32  nozomi
 *	d_Ref<NameRecord> are held as lists intead of sets
 *	
 *	Revision 1.3  1999/08/21 06:17:03  nozomi
 *	method _Annotation add
 *	
 *	Revision 1.2  1999/03/20 16:07:24  nozomi
 *	bool Annotation::merge(Annotation *) add
 *	
 *	Revision 1.1  1999/03/15 16:42:45  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:15:41  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// Annotation class has type descriptor (such as revision) as string, 
// two sets of pointers to NameRecord named from and to, respectively.
// Because it holds descriptor as string, you can add any type of
// relationship as you want.  Two sets of pointers to NameRecod hold
// information that of which NameRecords are related by the annotation.
// Annotatoin class may be abstracted from information in Citation
// class (level two abstraction), but mainly abstracted from
// Publication class (level one abstraction).  Hence it has say
// 2.5th level abstraction.  As same as NameRecord, we may be able to
// specify the first page mentioned about the annotation, and extract 
// statement phrase from publication entity.  This style enables us to put
// Annotation class into third level abstraction.  The formalism is
// attractive, but if we choose it we need to pick up the statements
// from publication, otherwise we can not distinguish two or more
// citation mentioning on annotations appeared in the same page of
// publication.  In case of NameRecrod abstraction from Citation,
// corresponding appearance string is deduced from NameRecord if the
// appearance is not given (I'll add deduced symbol say `*' before the
// string).  It is harder task for annotation, and hence we'd better
// careful for the formalism.
//

#if (!defined (_INCLUDED_ANNOTATION_H))
#define _INCLUDED_ANNOTATION_H
#include "d_Object.h"
#include "d_Ref.h"
#if (!defined (_INCLUDED_NAMEDFIELD_H))
#include "NamedField.h"
#endif

#if (__GNUC_MINOR__ > 7)
#include <set>
#else
#include <set.h>
#endif

class NameRecord;
class Publication;
class Citation;
class Author;
class NRnode;
class Resolver;

class Annotation:public d_Object
{
  friend class d_Ref<NameRecord>;
  friend class d_Ref<Annotation>;
  friend class NRnode;
public:
  struct annoTuple{const char* str; size_t n;};
  static const annoTuple reasons[];
  static const annoTuple tuple[];

  Annotation(void);
  Annotation(const Annotation&);
  Annotation& operator=(const Annotation&);

  Annotation(NameRecord* nr, const NamedField& nf, const char* fn, size_t n = 0);
  Annotation(const NamedField& nf, const char*, size_t n = 0);
  ~Annotation(void);

  friend istream& operator>>(istream & s, Annotation& a);
  friend ostream& operator<<(ostream & s, Annotation& a);
  ostream& printTo(ostream & os) const;

  const char* annotation(void) const;
  string annotation(const char*);
  string persistentID(void) const;
  
  Annotation* resolve(hash_map<string, list<NameRecord*>, Hash<string> > &nr,
		      hash_map<string, list<Annotation*>, Hash<string> > &an,
		      hash_map<string, list<Citation*>, Hash<string> > &ci,
		      hash_map<string, list<Publication*>, Hash<string> > &pub,
		      hash_map<string, list<Author*>, Hash<string> > &au,
		      hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr,
		      hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > &uan,
		      hash_map<string, list<d_Ref<Citation>*>, Hash<string> > &uci,
		      hash_map<string, list<d_Ref<Publication>*>, Hash<string> > &upub,
		      hash_map<string, list<d_Ref<Author>*>, Hash<string> > &uau);

  Annotation* resolve(Resolver &);

  bool merge(Annotation*);
  bool merge(d_Ref<Annotation>*);

  list<d_Ref<NameRecord> > from;
  list<d_Ref<NameRecord> > to;

  friend bool operator==(const Annotation &, const Annotation &);
  friend bool operator!=(const Annotation &, const Annotation &);
  friend bool operator<(const Annotation &, const Annotation &);
  friend bool operator>(const Annotation &, const Annotation &);
  friend bool operator>=(const Annotation &, const Annotation &);
  friend bool operator<=(const Annotation &, const Annotation &);

private:
  const char* _annotation;
  d_Ref<Publication> _publication;  // necessary?
  d_Ref<Citation> _citation;  // necessary?
  static const char * const _classname = "Annotation";

  void _Annotation(const char* s);
  void _Annotation(const NamedField& nf, const char* fn, size_t n);
};

inline ostream& Annotation::printTo(ostream & os) const { return os << *(Annotation*)this; }

#if (!defined(_INCLUDED_NAMERECORD_H))
#include "NameRecord.h"
#endif

#if (!defined(_INCLUDED_PUBLICATION_H))
#include "Publication.h"
#endif

#if (!defined(_INCLUDED_CITATION_H))
#include "Citation.h"
#endif

#if (!defined(_INCLUDED_AUTHOR_H))
#include "Author.h"
#endif

#if (!defined(_INCLUDED_NRNODE_H))
#include "NRnode.h"
#endif

#if (!defined(_INCLUDED_RESOLVER_H))
#include "Resolver.h"
#endif

inline const char* Annotation::annotation(void) const {return _annotation;}

inline Annotation::~Annotation(void){delete [] _annotation;}

inline bool operator!=(const Annotation &a1, const Annotation &a2)
{return !(a1 == a2);}

inline bool operator>=(const Annotation &a1, const Annotation &a2)
{return !(a1 < a2);}

inline bool operator<=(const Annotation &a1, const Annotation &a2)
{return (a1 < a2)||(a1 == a2);}

inline bool operator > (const Annotation &a1, const Annotation &a2)
{return !(a1 < a2) && !(a1 == a2);}

#if 0
inline bool Annotation::resolve(const list<d_Ref<NameRecord> > &lnr, const list<d_Ref<Annotation> > &lan,
		  const list<d_Ref<Publication> > &lpb, const list<d_Ref<Author> > &lau)
{return resolve(lnr);}
#endif
#endif //_INCLUDED_ANNOTATION_H
