/*
 *
 * Citation.cxx: an implementation of persistent Citation class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Citation.cxx,v 1.11 1999/12/05 18:24:06 nozomi Exp $
 *	$Log: Citation.cxx,v $
 *	Revision 1.11  1999/12/05 18:24:06  nozomi
 *	improve merge code
 *	
 *	Revision 1.10  1999/09/23 06:28:51  nozomi
 *	resolve method using Rresolver class
 *	
 *	Revision 1.9  1999/09/20 14:14:37  nozomi
 *	modification relating data addition
 *	
 *	Revision 1.8  1999/08/18 13:34:15  nozomi
 *	add methods int year(void) and void year(int)
 *	
 *	Revision 1.7  1999/08/16 08:05:52  nozomi
 *	fix persistentID() calling bug
 *	
 *	Revision 1.6  1999/08/16 07:03:32  nozomi
 *	NameRecord::persistentID() version 2 support
 *	
 *	Revision 1.5  1999/08/06 07:40:14  nozomi
 *	self push to Publication if given in constructors
 *	
 *	Revision 1.4  1999/03/24 11:02:27  nozomi
 *	bug fix relating Author class
 *	
 *	Revision 1.3  1999/03/20 16:08:12  nozomi
 *	Data merge code, still restrictive, i.e. only works when presistentIDs are identical.
 *	
 *	Revision 1.2  1999/03/15 11:23:11  nozomi
 *	persistentID related modifications
 *	
 *	Revision 1.1  1999/03/14 18:04:50  nozomi
 *	minor modificatoin in constructors and its supporter.
 *	re-examine of construction may be necessary,
 *	especially in relationship with Pubilcation class.
 *	
 *	Revision 1.0.0  1999/03/14 02:16:06  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "d_Ref.h"
#include "Citation.h"

#include "NameRecord.h"
#include "Annotation.h"
#include "Publication.h"

#include <strings.h>
#include <stdlib.h>
#include <stdio.h>

#if 0
#else
void Citation::page(int p) {
  char pg[10];
  sprintf(pg, "%d", p);
  delete [] _page;
  _page = new_strdup::strdup(pg);
}
#endif

// is it acceptable?
Citation::Citation(void)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(0), _appearance(strdup()){}
  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(strdup()), _appearance(strdup()){}

Citation::Citation(const Citation& c)
  :d_Object(_classname), 
   namerecords(c.namerecords), annotations(c.annotations),
   //   _publication(c._publication), _page(c._page), _appearance(new_strdup::strdup(c._appearance)){}
   _publication(c._publication), _page(new_strdup::strdup(c._page)), _appearance(new_strdup::strdup(c._appearance)){}

Citation::Citation(const char* s)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(0), _appearance(strdup())
  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(strdup()), _appearance(strdup())
{_Citation(s);}

Citation::Citation(const string& s)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(0), _appearance(strdup())
  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(strdup()), _appearance(strdup())
{_Citation(s.c_str());}

Citation::Citation(const d_Ref<Publication> &dp)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(dp), _page(0), _appearance(strdup())
  :d_Object(_classname), namerecords(), annotations(), _publication(dp), _page(strdup()), _appearance(strdup())
{
  list<d_Ref<Citation> >::iterator iter = dp->citations.begin();
  list<d_Ref<Citation> >::iterator end = dp->citations.end();
  while(iter != end && iter->ptr() != this)
    ++iter;
  if(iter != end)
    dp->citations.push_back(this);
}

Citation::Citation(Publication &p)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(&p), _page(0), _appearance(strdup())
  :d_Object(_classname), namerecords(), annotations(), _publication(&p), _page(strdup()), _appearance(strdup())
{
  list<d_Ref<Citation> >::iterator iter = p.citations.begin();
  list<d_Ref<Citation> >::iterator end = p.citations.end();
  while(iter != end && iter->ptr() != this)
    ++iter;
  if(iter != end)
    p.citations.push_back(this);
}

Citation::Citation(Publication* pb, int p, const char* n)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(pb), _page(p), _appearance(new_strdup::strdup(n))
  :d_Object(_classname), namerecords(), annotations(), _publication(pb),  _appearance(new_strdup::strdup(n))
{
    pb->citations.push_back(this);
    page(p);
}

Citation::Citation(Publication* pb, const char* p, const char* n)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(pb), _page(p), _appearance(new_strdup::strdup(n))
  :d_Object(_classname), namerecords(), annotations(), _publication(pb), _page(strdup(p)), _appearance(new_strdup::strdup(n))
{
#if 0
  list<d_Ref<Citation> >::iterator iter = pb->citations.begin();
  list<d_Ref<Citation> >::iterator end = pb->citations.end();
  while(iter != end && iter->ptr() != this)
    ++iter;
  if(iter != end)
#endif
    pb->citations.push_back(this);
}

//Citation::Citation(Publication &pb, int p, const char* n)
//  :d_Object(_classname), namerecords(), annotations(), _publication(&pb), _page(p), _appearance(new_strdup::strdup(n)){}

// Since _publication may instance or pointer depending on
// contents of NamedField, its initializatoin is potponed.
Citation::Citation(const NamedField &nf, const char* fn)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(0), _appearance(strdup()){_Citation(&nf, fn);}
  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(strdup()), _appearance(strdup()){_Citation(&nf, fn);}

// Since _publication may instance or pointr depending on
// contents of NamedField, its initializatoin is postponed.
Citation::Citation(const NamedField *nf, const char* fn)
  //  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(0), _appearance(strdup()){_Citation(nf, fn);}
  :d_Object(_classname), namerecords(), annotations(), _publication(), _page(strdup()), _appearance(strdup()){_Citation(nf, fn);}

Citation::~Citation(void){

#if 0
  if(_publication.ptr() != NULL && !_publication->citations.empty()){
    list<d_Ref<Citation> >::iterator iter = _publication->citations.begin();
    list<d_Ref<Citation> >::iterator end = _publication->citations.end();
    list<d_Ref<Citation> >::iterator rmv;
    while(iter != end){
      rmv = iter;
      ++iter;
      if(rmv->ptr() == this)
	_publication->citations.remove(*rmv);
    }
  }
#endif
#if 0
  if(!namerecords.empty()){

    list<d_Ref<NameRecord> >::iterator iter = namerecords.begin();
    list<d_Ref<NameRecord> >::iterator end = namerecords.end();
    while(iter != end){
      if(iter->ptr()->recorder() == this)
	iter->ptr()->recorder(NULL);
      ++iter;
    }

    namerecords.clear();
  }

  if(!annotations.empty()){
#if 0
    list<d_Ref<Annotation> >::iterator iter = annotations.begin();
    list<d_Ref<Annotation> >::iterator end = annotations.end();
    while(iter != end){
      if((*iter)->recorder->ptr() == this)
	(*iter)->recorder->ptr(NULL);
      ++iter;
    }
#endif
    annotations.clear();
  }
#endif

  //  if(!!_publication)
  //    _publication.ptr()->operator--();
  delete [] _appearance;
  delete [] _page;
}

string Citation::emptyPID(void)
{
  string s(_classname);
  s += "::__";
  s += Publication::emptyPID();
  return s;
}

string Citation::persistentID(void) const
{
  string s(_classname);
  s += "::";
  s += _appearance; s += "_";
  //  if(0 != _page){char p[10]; sprintf(p, "%d", _page); s+= p;}
  s += _page;
  s += "_";
  if(NULL != _publication.ptr())
    s += _publication->persistentID();
  else
    s += _publication.persistentID();
 return s;
}

void Citation::_Citation(const char *s)
{
  int l = strlen(s);
  int i;
  const char *f = s;

#if 1
  if(!strncmp(s, "Citation::", 10)){
    s += 10; l -= 10;
    for(i = 0, f = s;i < l && '_' != *f; f++, i++){}
    if(f != s)
      _appearance = strndup(s, f - s);
    s = f + 1;
    for(f = s;i < l && '_' != *f; f++, i++){}
    if(f != s)
      //      _page = atoi(s);
      _page = new_strdup::strdup(s);
    s = f + 1;
  }
#endif
  if(!strncmp(s, "Publication::", 13)){_publication.persistentID(s); return; }

  for(i = 0, f = s;i < l && 
	(isalnum(*f) || isspace(*f) || '.' == *f || ',' == *f); f++, i++){}
  Publication *p = new Publication();
  p->citations.push_back(this);
  _publication.ptr(p);
  if(i == l){
    p->authors(s);
  }
  else{
    string str(s, 0, i);
    p->authors(str.c_str());
    for(;i < l && !isdigit(*f); f++, i++){}
    if(i < l){
      p->year(atoi(f));
    }
  }
}

void Citation::_Citation(const NamedField *nf, const char* fn)
{
  //empty case
  if(strcmp(nf->entryName(), fn)) return;

  const char* s;

  // direct contents
  if(strlen(s = nf->strcmp(fn))){_Citation(s); return;}

  list<NamedField>::const_iterator tmp;

  // we have page
  if(NULL != (s = nf->strcasecmp("publication"))){
    if(!strncmp(s, "Publication::", 13)){
      _publication.persistentID(s);
      goto setpage;
    }
    else if (strlen(s)){
      _publication = new Publication(string(s));
      goto setpage;
    }
    else{
      //      list<NamedField>::const_iterator tmp;
      for(tmp = nf->subEntries.begin(); tmp != nf->subEntries.end(); ++tmp){
	if(!strcasecmp(tmp->entryName(), "Publication")){
	  _publication = new Publication(&*tmp);
	  goto setpage;
	}
      }
    }
  }
#if 1
  //fields are given separately.
  //they can not be handled simply by 
  _publication =  new Publication;
  //  list<NamedField>::const_iterator tmp;
  const char* en;
  for(tmp = nf->subEntries.begin(); tmp != nf->subEntries.end(); ++tmp){
    en = tmp->entryName();
    if(!strcasecmp(en, "title"))
      _publication->title(tmp->strcmp(en));
    if(!strmcasecmp(en, "year", 4))
      _publication->year(atoi(tmp->strcmp(en)));
    if(!strcasecmp(en, "author") || !strcasecmp(en, "authors"))
      _publication->authors(tmp->strcmp(en));
    if(!strncasecmp(en, "vol", 3))
      _publication->volume(tmp->strcmp(en));
    if(!strncasecmp(en, "number", 3))
      _publication->number(atoi(tmp->strcmp(en)));
    if(!strcasecmp(en, "pages")){
      s = tmp->strcmp(en);
      _publication->from(atoi(s));
      int l = strlen(s);
      register int i;
      for(i = 0; i < l && isdigit(*s);s++, i++){}
      if(i != l)
	for(; i < l && !isdigit(*s);s++, i++){}
      if(i != l) 
	_publication->to(atoi(s));
    }
    else{
      if(!strcasecmp(en, "from")){
	_publication->from(atoi(tmp->strcmp(en)));
      }
      if(!strcasecmp(en, "to")){
	_publication->to(atoi(tmp->strcmp(en)));
      }
    }
  }
#else 
  // need fix of Author handling in publication
  _publication =  new Publication(nf, fn);
#endif
  setpage:
  //  if(NULL != (s = nf->strcasecmp("page"))) _page = atoi(s);
  if(NULL != (s = nf->strcasecmp("page"))) _page = new_strdup::strdup(s);

  if(NULL != (s = nf->strcasecmp("appearance"))){delete [] _appearance; _appearance = new_strdup::strdup(s);}
  if(NULL != nf->strcasecmp("NameRecord")){
    list<NamedField>::const_iterator iter = nf->subEntries.begin();
    list<NamedField>::const_iterator end = nf->subEntries.end();
    while(iter != end){
      if(NULL != (s = iter->strcasecmp("NameRecord"))){
	if(!strncmp(s, "NameRecord::", 12)){
	  d_Ref<NameRecord> dnr;
	  dnr.persistentID(NameRecord::persistentID(s));
	  namerecords.push_back(dnr);
	}
	else{
	  namerecords.push_back(new NameRecord(*iter));
	}
      }
      ++iter;
    }
  }
#if 0
  if(NULL != nf->strcasecmp("Annotation")){
    list<NamedField>::const_iterator iter = nf->subEntries.begin();
    list<NamedField>::const_iterator end = nf->subEntries.end();
    while(iter != end){
      if(NULL != (s = iter->strcasecmp("Annotation"))){
	if(!strncmp(s, "Annotaiton::", 12)){
	  d_Ref<Annotation> dan;
	  dan.persistentID(s);
	  annotations.push_back(dan);
	}
	else{
	  annotations.push_back(new Annotation(*iter, "Annotation"));
	}
      }
      ++iter;
    }
  }
#endif
}

Citation& Citation::operator= (const Citation& c)
{
  //  _page = c._page;
  _page = new_strdup::strdup(c._page);
  _publication = c._publication; 
  annotations = c.annotations;
  namerecords = c.namerecords;
  delete [] _appearance;
  _appearance = new_strdup::strdup(c._appearance);
  return *this;
}

ostream& operator<<(ostream & s, const Citation &c)
{
  s << c._classname << " = {\n";s<<flush;
  s << "  persistentID = {" << c.persistentID()<< "}\n";s<<flush;
  string str(c._publication.persistentID());
  if(str.length())
    s << "  Publication = {" << str << "}\n";s<<flush;
  //  if(c._page)
  if(strlen(c._page))
     s << "  page = {" << c._page << "}\n";s<<flush;
  if(strlen(c._appearance))
    s << "  appearance = {" << c._appearance << "}\n";s<<flush;
  if(!c.namerecords.empty()){
    list<d_Ref<NameRecord> >::const_iterator iter = c.namerecords.begin();
    list<d_Ref<NameRecord> >::const_iterator end  = c.namerecords.end();
    while(iter != end){
      s << "  NameRecord = {" << NameRecord::persistentID(iter->persistentID().c_str()) << "}\n";s<<flush;	
      s << "  NameRecord = {" << (*iter)->persistentID(3) << "}\n";s<<flush;	
      ++iter;
    }
  }

  if(!c.annotations.empty()){
    list<d_Ref<Annotation> >::const_iterator aiter = c.annotations.begin();
    list<d_Ref<Annotation> >::const_iterator aend  = c.annotations.end();
    while(aiter != aend){
      s << "  Annotation = {" << aiter->persistentID() << "}\n";s<<flush;	
      ++aiter;
    }
  }
  else if(!c.namerecords.empty()){
    list<d_Ref<NameRecord> >::const_iterator iter = c.namerecords.begin();
    list<d_Ref<NameRecord> >::const_iterator end  = c.namerecords.end();
    while(iter != end){
      list<d_Ref<Annotation> >::const_iterator aiter = (*iter)->annotation.begin();
      list<d_Ref<Annotation> >::const_iterator aend  = (*iter)->annotation.end();
      while(aiter != aend){
	s << "  Annotation = {" << aiter->persistentID() << "}\n";s<<flush;	
	++aiter;
      }
      ++iter;
    }
  }
  s << "}\n";s<<flush;    
  return s;
}

Citation* Citation::resolve(Resolver &r)
{
  string s(persistentID());
  hash_map<string, list<Citation*>, Hash<string> >::iterator citer = r.ci.find(s);
  if(citer != r.ci.end()){
    list<Citation*>::iterator iter = citer->second.begin();
    list<Citation*>::iterator end = citer->second.end();
    while(iter != end){
      if(this == *iter)
	return this;
      else if((*iter)->merge(this))
      	return *iter;
      ++iter;
    }
  }

  r.ci[s].push_back(this);
  r.newCitations.push_back(this);

  hash_map<string, list<d_Ref<Citation>*>, Hash<string> >::iterator uciter = r.uci.find(s);

  if(uciter != r.uci.end()){
    register list<d_Ref<Citation>*>::iterator iter = uciter->second.begin();
    register list<d_Ref<Citation>*>::iterator end = uciter->second.end();
    register list<d_Ref<Citation>*>::iterator current;
    while(iter != end){
      current = iter;
      ++iter;
      if(s == (*current)->persistentID() && NULL == (*current)->ptr()){
	(*current)->ptr(this);
	uciter->second.erase(current);
      }
    }
  }

  bool ret;
  Publication *p = _publication.ptr();
  if(NULL != p){
    Publication *q = p->resolve(r);
    if(q != p)
      _publication.ptr(q);
  }
  else
    _publication.resolve(r.pub, r.upub);

  if(!namerecords.empty()){
    list<d_Ref<NameRecord> >::iterator iter = namerecords.begin();
    list<d_Ref<NameRecord> >::iterator end  = namerecords.end();
    while(iter != end){
      NameRecord *p = iter->ptr();
      if(NULL != p){
	NameRecord *q = p->resolve(r);
	if(q  != p){
	  iter->ptr(q);
	}
      }
      else
	iter->resolve(r.nr, r.unr);
      ++iter;
    }
  }

#if 1
  if(!annotations.empty()){
    list<d_Ref<Annotation> >::iterator iter = annotations.begin();
    list<d_Ref<Annotation> >::iterator end= annotations.end();
    while(iter != end){
      Annotation *p = iter->ptr();
      if(NULL != p){
	Annotation *q = p->resolve(r);
	if(q != p){
	  iter->ptr(q);
	}
      }
      else
	iter->resolve(r.an, r.uan);
      ++iter;
    }
  }
#endif
  return this;
}

Citation* Citation::resolve(hash_map<string, list<NameRecord*>, Hash<string> > &nr,
			    hash_map<string, list<Annotation*>, Hash<string> > &an,
			    hash_map<string, list<Citation*>, Hash<string> > &ci,
			    hash_map<string, list<Publication*>, Hash<string> > &pub,
			    hash_map<string, list<Author*>, Hash<string> > &au,
			    hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr,
			    hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > &uan,
			    hash_map<string, list<d_Ref<Citation>*>, Hash<string> > &uci,
			    hash_map<string, list<d_Ref<Publication>*>, Hash<string> > &upub,
			    hash_map<string, list<d_Ref<Author>*>, Hash<string> > &uau)
{
#if 0
  hash_map<string, list<NRnode*>, Hash<string> > nrn;
  Resolver r(nr, an, ci, pub, au, nrn);
  Citation *ret = resolve(r);
  unr = r.unr;
  uan = r.uan;
  uci = r.uci;
  upub = r.upub;
  uau = r.uau;
  return ret;
#else
  string s(persistentID());

  hash_map<string, list<Citation*>, Hash<string> >::iterator citer = ci.find(s);
  if(citer != ci.end()){
    list<Citation*>::iterator iter = citer->second.begin();
    list<Citation*>::iterator end = citer->second.end();
    while(iter != end){
      if(this == *iter)
	return NULL;
      else if((*iter)->merge(this))
      	return *iter;
      ++iter;
    }
  }

  ci[s].push_back(this);

  hash_map<string, list<d_Ref<Citation>*>, Hash<string> >::iterator uciter = uci.find(s);

  if(uciter != uci.end()){
    list<d_Ref<Citation>*>::iterator iter = uciter->second.begin();
    list<d_Ref<Citation>*>::iterator end = uciter->second.end();
    while(iter != end){
      if(s == (*iter)->persistentID() && NULL == (*iter)->ptr())
	**iter = this;
      ++iter;
    }
  }

  if(NULL != _publication.ptr()){
    Publication *p = _publication->resolve(nr, an, ci, pub, au, unr, uan, uci, upub, uau);
    if(NULL != p)
      _publication.ptr(p);
  }
  else
    _publication.resolve(pub, upub);

  if(!namerecords.empty()){
    list<d_Ref<NameRecord> >::iterator iter = namerecords.begin();
    list<d_Ref<NameRecord> >::iterator end  = namerecords.end();
    while(iter != end){
      if(NULL != iter->ptr()){
	NameRecord *p = (*iter)->resolve(nr, an, ci, pub, au, unr, uan, uci, upub, uau);
	if(NULL != p){
	  //delete *iter!
	}
      }
      else
	iter->resolve(nr, unr);
      ++iter;
    }
  }

#if 0
  if(!annotations.empty()){
    list<d_Ref<Annotation> >::iterator iter = annotations.begin();
    list<d_Ref<Annotation> >::iterator end= annotations.end();
    while(iter != end){
      if(NULL != iter->ptr()){
	Annotation *p = (*iter)->resolve(nr, an, ci, pub, au, unr, uan, uci, upub, uau);
	if(NULL != p){
	  //delete *iter!
	}
      }
      else
	iter->resolve(an, uan);
      ++iter;
    }
  }
#endif
  return NULL;
#endif
}

static string skipFirst(const string &str)
{
  register const char *p = str.begin();
  register const char *q = str.end();
  while(p < q && *p != '_') p++;
  if(p == q && ++p < q)
    return string("");
  return string(str, p - str.begin());
}

/*
 * Citation merger
 */

bool Citation::merge(Citation *c)
{
  static const bool refuse = false;

  bool ret = !refuse;
  if(NULL == c ||this == c)
    return refuse;
  string pid(persistentID());
  string cpid(c->persistentID());
  string ppid(skipFirst(skipFirst(pid)));
  string cppid(skipFirst(skipFirst(cpid)));

  //  cerr << "merging..."<< persistentID();
  //  cerr << "\nmerging..."<< c->persistentID()<<"\n";
  //  cerr << "merging..."<< ppid;
  //  cerr << "\nmerging..."<< cppid<<"\n";
  //  if(persistentID() == c->persistentID()){
  if(ppid == cppid){
    Publication *p = _publication.ptr();
    Publication *cp = c->_publication.ptr();
    if(p != NULL && cp != NULL && p != cp &&
       refuse == p->merge(cp)){
      //      cerr << "fail for pub\n";
      return refuse;
    }

    Citation empty;
    if(persistentID().length() <= empty.persistentID().length() ||
       c-> persistentID().length() <= empty.persistentID().length()){
      //      cerr << "fail for pid length\n";
      return refuse;
    }

    if(p == cp && NULL != p){

    }
    else if (p != cp) { //otherwise both are NULL
      if(NULL == p){
	_publication.ptr(cp);
      }
      else if(NULL == cp){
	c->_publication.ptr(p);
      }
      else {  //p anc cp are already merged
	list<d_Ref<Citation> >::iterator iter = cp->citations.begin();
	list<d_Ref<Citation> >::iterator end = cp->citations.end();
	while(iter != end){
	  if(iter->ptr() == c)
	    iter->ptr(this);
	  ++iter;
	}
      }
      namerecords.sort();
      c->namerecords.sort();
      namerecords.merge(c->namerecords);
      namerecords.unique();

      annotations.sort();
      c->annotations.sort();
      annotations.merge(c->annotations);
      annotations.unique();
    }
    //    cerr << "success?\n";
    return ret;
  }
  //else. non-trivial work, will be implemented
  //    cerr << "success??\n";
    //  return ret;
  return refuse;
}

void Citation::year(int y)
{
  if(NULL != _publication.ptr())
    _publication->year(y);
}

int Citation::year(void) const 
{
  if(NULL != _publication.ptr())
    return _publication->year();
  else
    return 0;
}

bool operator<(const Citation &c1, const Citation &c2)
{
  if(c1._publication != c2._publication || 
     c1._publication.ptr() != c2._publication.ptr())
    return c1._publication < c2._publication;

  //  if(c1._page != c2._page)
  int pgcmp = strcasecmp(c1._page, c2._page);
  if(pgcmp != 0)
    return pgcmp < 0;

  return strcmp(c1.persistentID(), c2.persistentID()) < 0;
}
