/*
 *
 * Citation.h: a definition of persistent Citation class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Citation.h,v 1.7 1999/12/05 18:20:31 nozomi Exp $
 *	$Log: Citation.h,v $
 *	Revision 1.7  1999/12/05 18:20:31  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.6  1999/09/23 06:29:17  nozomi
 *	resolve method using Resolver class
 *	
 *	Revision 1.5  1999/09/20 14:15:38  nozomi
 *	modification relating data addition
 *	
 *	Revision 1.4  1999/08/18 13:33:23  nozomi
 *	add methods int year(void) and void year(int)
 *	change include files
 *	
 *	Revision 1.3  1999/08/06 07:40:50  nozomi
 *	self push of Publication if given in constructors
 *	
 *	Revision 1.2  1999/03/20 16:09:00  nozomi
 *	bool Citation::merge(Citation *) add
 *	
 *	Revision 1.1  1999/03/15 16:42:47  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:16:13  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// class Citation is a second level abstraction from publication entity.
// It has slots for information abstracted from Publication class, 
// i.e. name appearance in the publication entity and precise page 
// where it appear at first.  It also has pointer to the Publication,
// list of pointers to NameRecord object and list of pointer to Annotation object.
// Appearance name sometime contains Annotational information,
// and hence it has slot for pointer to Annotation.  However, it may unnecessary.
//

#if (!defined(_INCLUDED_CITATION_H))
#define _INCLUDED_CITATION_H

#include "d_Object.h"
#include "d_Ref.h"
#if (!defined(_INCLUDED_NAMEDFIELD_H))
#include "NamedField.h"
#endif

#if (__GNUC_MINOR__ > 7)
#if (!defined(_INCLUDED_LIST))
#include <list>
#defien _INCLUDED_LIST
#endif
#else
#include <list.h>
#if (!defined(_INCLUDED_LIST))
#defien _INCLUDED_LIST
#endif
#endif

class Annotation;
class Author;
class NameRecord;
class Publication;
class Resolver;

class Citation:public d_Object{
friend class NameRecord;

public:
  static const int invalidPage = 0;
  //constructors
  Citation(void);
  Citation(const Citation&);
  Citation& operator=(const Citation&);
  Citation(const char*);
  Citation(const string&);
  Citation(const d_Ref<Publication>&);
  Citation(Publication &p);
  Citation(const NamedField& nf, const char *fn = "Citation");
  Citation(const NamedField* nf, const char *fn = "Citation");
  Citation(Publication* pb, const char* p = "", const char *n = "");
  Citation(Publication* pb, int p, const char *n = "");
  //  Citation(Publication& pb, int p = invalidPage);

  //destractors
  ~Citation();

  //accessors
  const d_Ref<Publication> publication(void) const;
#if 0
  int page(void) const;
#else
  string page(void) const;
#endif

  int year(void) const;
  string appearance(void) const;

  //manipulators
  void publication(Publication*);
  void publication(Publication&);
  void publication(const char*);
  void publication(const string&);
  //  void publication(d_Ref<Publication>*);
  void publication(d_Ref<Publication>&);
  void page(int);
  void page(const char*);
  void year(int);
  void appearance(const char*);
  void appearance(const string&);

  //housekeeping
  string persistentID(void) const;
  static string emptyPID(void);

  list<d_Ref<NameRecord> > namerecords;
  list<d_Ref<Annotation> > annotations;
  friend istream& operator>>(istream & s, Citation &c);
  friend ostream& operator<<(ostream & s, const Citation &c);
  ostream& printTo(ostream & os) const;

  Citation* resolve(Resolver &);
  Citation* resolve(hash_map<string, list<NameRecord*>, Hash<string> > &nr,
		    hash_map<string, list<Annotation*>, Hash<string> > &an,
		    hash_map<string, list<Citation*>, Hash<string> > &ci,
		    hash_map<string, list<Publication*>, Hash<string> > &pub,
		    hash_map<string, list<Author*>, Hash<string> > &au,
		    hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr,
		    hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > &uan,
		    hash_map<string, list<d_Ref<Citation>*>, Hash<string> > &uci,
		    hash_map<string, list<d_Ref<Publication>*>, Hash<string> > &upub,
		    hash_map<string, list<d_Ref<Author>*>, Hash<string> > &uau);
  
  bool merge(Citation *);

  friend bool operator<(const Citation &, const Citation &);

private:
  d_Ref<Publication> _publication;
#if 0
  int _page; // precise page where the description appear at firstn
#else
  char *_page; // precise page where the description appear at first
#endif
  const char *_appearance;

  void _Citation(const char *);
  void _Citation(const NamedField *nf, const char* fn);

  static const char * const _classname = "Citation" ;
};

#include "NameRecord.h"
#include "Annotation.h"

#if (!defined(_INCLUDED_PUBLICATION_H))
#include "Publication.h"
#endif

#if (!defined(_INCLUDED_RESOLVER_H))
#include "Resolver.h"
#endif

inline ostream& Citation::printTo(ostream & os) const { return os << *(Citation*)this; }

inline const d_Ref<Publication> Citation::publication(void) const
{return _publication; }

#if 0
inline int Citation::page(void) const
{ return _page; }
#else
inline string Citation::page(void) const
{ return string(_page); }
#endif
inline void Citation::publication(Publication* p) { _publication = p; }

//inline void Citation::publication(d_Ref<Publication> *p) { _publication = &p; }
inline void Citation::publication(d_Ref<Publication> &p) { _publication = p; }

// bad idea
//inline Publication* Citation::publication(Publication& p)
//{ _publication = &p; }

#if 0
inline void Citation::page(int p) { _page = p;}
#else
inline void Citation::page(const char* p) { delete [] _page; _page = new_strdup::strdup(p); }
#endif

inline string Citation::appearance(void) const {return string(_appearance);}

inline void Citation::appearance(const char* n)
{delete [] _appearance; _appearance = new_strdup::strdup(n);}

inline void Citation::appearance(const string &n)
{delete [] _appearance; _appearance = strdup(n);}

inline istream& operator>>(istream & s, Citation &c)
{ NamedField nf; s >> nf; c = Citation(&nf); return s;}

inline void Citation::publication(const char* s)
{_publication.persistentID(s);}

inline void Citation::publication(const string &s)
{_publication.persistentID(s.c_str());}

#endif //_INCLUDED_CITATION_H
