/*
 *
 * Date.cxx: an implementation of Date class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Date.cxx,v 1.1 1999/03/15 16:42:36 nozomi Exp $
 *	$Log: Date.cxx,v $
 *	Revision 1.1  1999/03/15 16:42:36  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:16:20  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "Date.h"
#if (__GNUC_MINOR__ > 7)
#include <cstring>
#else
#include <cstring.h>
#endif

static int atom(const char* m);

void Date::_Date(const char* s, int lim)
{
  int l;
  if(NULL == s || 0 == (l = strlen(s))) return;
  if(lim != 0) l = lim;
  char separator = 0;
  const char *f = s;
  int i;
  for(i = 0; i < l && isalnum(*f); f++, i++){}
  if(i < l)
    separator = *f;
  f = s;
  yr = atoi(f);
  if(separator){
    for(i = 0; i < l && separator != *f++; i++){}
    if(i < l){
      if(isdigit(*f)){mon = atoi(f);}
	else{mon = atom(f);}
	for(; i < l && separator != *f++; i++){}
	if(i < l)dy = atoi(f);
      }
    }
    else{
      for(i = 0; i < l && isdigit(*f); f++,i++){}
      if(i < l){
	mon = atom(f);
	for(;i < l && isalpha(*f); f++,i++){}
	if(i < l) dy = atoi(f);
      }
    }
}


void Date::_Date(NamedField *nf, const char* fn)
{
  if(strcmp(nf->entryName(), fn)) return;

  const char* s;
  if(strlen(s = nf->strcmp(fn))){_Date(s); return;}

  if(NULL != (s = nf->strcasecmp("year"))) yr = atoi(s);
  if(NULL != (s = nf->strncasecmp("mon", 3))) mon = atom(s);
  if(NULL != (s = nf->strcasecmp("day"))) dy = atoi(s);
}

static char *monthTable[] =
{"(null)", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

ostream& operator<<(ostream & s, const Date &d)
{
  if(d.yr != Date::invalidYear){
    s << d.yr;
    if(d.mon != Date::invalidMonth){
      s <<monthTable[d.mon];
      if(d.dy != Date::invalidDay){
	s <<d.dy;
      }
    }
  }
  return s;
}

#include <stdio.h>

Date::operator string(void) const
{
  string s("");
  if(yr != Date::invalidYear){char y[5]; sprintf(y, "%d", yr); s+= y;}
  if(mon != Date::invalidMonth){ s += monthTable[mon]; }
  if(dy != Date::invalidDay){char d[3]; sprintf(d, "%d", dy); s+= d;}
  return s;
}

static int atom(const char* m)
{
  int mon = Date::invalidMonth;
  if(strncmp(m, "null", 4)){
    switch(toupper(*m)){
    case 'F': mon = 2; break; //Feb
    case 'S': mon = 9; break; //Sep
    case 'O': mon = 10; break; //Oct
    case 'N': mon = 11; break; //Nov
    case 'D': mon = 12; break; //Dec
    case 'A':
      if(strncasecmp(m,"Apr",3)) mon = 8;
      else mon = 4;
      break;
    case 'M':
      if(strncasecmp(m,"Mar",3)) mon = 5;	  
      else mon = 3;
      break;
    case 'J':
      if(!strncasecmp(m,"Jan",3)) mon = 1;
      else if(!strncasecmp(m,"Jun",3)) mon = 6;
      else mon =7;
      break;
    }
  }
  return mon;
}

