/*
 *
 * NRnode.cxx: an implementation of persistent navigation node NRnode class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: NRnode.cxx,v 1.10 1999/12/05 18:24:15 nozomi Exp $
 *	$Log: NRnode.cxx,v $
 *	Revision 1.10  1999/12/05 18:24:15  nozomi
 *	improve merge code
 *	
 *	Revision 1.9  1999/09/23 06:35:58  nozomi
 *	resolve method using Resolver class
 *	
 *	Revision 1.8  1999/09/20 14:20:13  nozomi
 *	modification relating data addition
 *	
 *	Revision 1.7  1999/08/31 12:15:26  nozomi
 *	modifications relating changes in Annotation (from set to list)
 *	
 *	Revision 1.6  1999/08/26 07:24:44  nozomi
 *	_persistentID(string &) was modified
 *	
 *	Revision 1.5  1999/08/16 07:07:22  nozomi
 *	NameRecord::persistentID() version 2 support
 *	
 *	Revision 1.4  1999/08/15 01:25:11  nozomi
 *	hierarchy reconstruction was modified to eliminate reference duplication
 *	
 *	Revision 1.3  1999/08/13 13:07:23  nozomi
 *	higher and lower support as I/O key words
 *	
 *	Revision 1.2  1999/08/08 11:33:12  nozomi
 *	reference resolver add
 *	
 *	Revision 1.1  1999/08/08 04:19:07  nozomi
 *	Partial support of hierarchy
 *	
 *	Revision 1.0.0  1999/03/14 02:17:05  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "NRnode.h"

NRnode::NRnode(void)
  :d_Object(_classname), namerecord(), annotations(), from(), to(), higher(), lower(){}

NRnode::NRnode(const NRnode &nrn)
  :d_Object(_classname), namerecord(nrn.namerecord), annotations(nrn.annotations), 
   from(nrn.from), to(nrn.to), higher(nrn.higher), lower(nrn.lower){}

NRnode::NRnode(const d_Ref<NameRecord> &dnr)
  :d_Object(_classname), namerecord(dnr), annotations(), from(), to(), higher(), lower()
{
  NameRecord *pnr = dnr.ptr();
  if(NULL == pnr) return;
  _NRnode(pnr);
}

NRnode::NRnode(const string &s)
  :d_Object(_classname), namerecord(), annotations(), from(), to(), higher(), lower()
{
  string str("");
  if(!strncmp(s.c_str(), NameRecord::_classname))
    str = s;
  else{
    string str("NameRecord");
    int i = 0;
    int l = s.length();
    if(l > 0){
      while(i < l && s[i] != ':'){
	i++;
      }
      if(i < l)
	str += string(s, i);
    }
  }
  namerecord.persistentID(str);
}

NRnode::NRnode(const NameRecord &nr)
  :d_Object(_classname),
   //   namerecord(&nr), annotations(), from(), to(), 
   namerecord(&((NameRecord &) nr)), annotations(), from(), to(), 
   higher(),lower()
{
  _NRnode(&nr);
}

NRnode::NRnode(const NameRecord *nr)
  :d_Object(_classname), namerecord((NameRecord *)nr), annotations(), 
   from(), to(), higher(), lower()
{
  _NRnode(nr);
}

void NRnode::_NRnode(const NameRecord *nr)
{
  if(NULL == nr)
    return;
  //  _copyAnnotation(nr);
#if 0
  string s((nr->_higherNR).persistentID());
#else
  string s("");
  if(NULL != (nr->_higherNR).ptr())
    s = (nr->_higherNR).ptr()->persistentID();
  else
    s = (nr->_higherNR).persistentID();
#endif
  if(0 != s.length())
    //    return;
    higher.persistentID(_persistentID(s));
  _lowerCopy(nr);
}


NRnode& NRnode::operator=(const NRnode& nrn)
{
  namerecord = nrn.namerecord; 
  annotations = nrn.annotations;
  from = nrn.from;
  to = nrn.to;
  higher = nrn.higher;
  lower = nrn.lower;
  return *this;
}

NRnode::~NRnode(void)
{
}

string NRnode::persistentID(void) const
{
  if(NULL != namerecord.ptr()){
    return _persistentID(namerecord->persistentID());
  }
  else{
    return _persistentID(namerecord.persistentID());
  }
}

string NRnode::_persistentID(const string &str) const
{
#if 1
  string s("");
  if(!strncmp(str.c_str(), NameRecord::_classname)){
    s += _classname;
    s += string(NameRecord::persistentID(str.c_str()), strlen(NameRecord::_classname));
  }
#else
  string s(_classname);
  string nrster;
  if(!strncmp(str.c_str(), "NameRecord::", 12)){
    nrstr = NameRecord::persistentID(str.c_str());
  }
  else{
    nrstr = NameRecord::emptyPID();
  }
  s += string(nrstr, 10);
#endif
  return s;
}

#if 0
string _pidConv(const char* str)
{
  register char *p = str;
  register char *end = str + strlen(str);
  while(p < end && *p != ':' && *++p != ':') p++;

  if(p == end)
    return string(str);

  p++;

#if 1
  NameRecord nr;
  string s(nr.persistentID())
#endif
  if(!strncmp(str, "NameRecord::")){
  }
  else if(!strncmp(str, _classname)){
  if(str.length() > 10){
    s += string(NameRecord::persistentID(str.c_str()), 10);
  }
  else
    s += "::__________";
  return s;
}
#endif

void NRnode::_NRnode(const NamedField& nf)
{
  if(strcmp(nf.entryName(), _classname) || strlen(nf.contents()))
    return;
  const char *s;
  if(NULL != (s = nf.strcmp("NameRecrod")))
    namerecord.persistentID(string(s));
  if(NULL != (s = nf.strcmp("Annotation"))){
    list<NamedField>::const_iterator tmp;
    for(tmp = nf.subEntries.begin(); tmp != nf.subEntries.end(); ++tmp){
      if(!strcasecmp(tmp->entryName(), "Annotation")){
	d_Ref<Annotation> d;
	d.persistentID(tmp->entryName());
	annotations.push_back(d);
      }
    }
  }
  list<NamedField>::const_iterator tmp;
  for(tmp = nf.subEntries.begin(); tmp != nf.subEntries.end(); ++tmp){
    if(!strcasecmp(tmp->entryName(), "from")){
      d_Ref<NRnode> d;
      d.persistentID(tmp->entryName());
      from.push_back(d);
    }
    else if(!strcasecmp(tmp->entryName(), "to")){
      d_Ref<NRnode> d;
      d.persistentID(tmp->entryName());
      to.push_back(d);
    }
    else if(!strcasecmp(tmp->entryName(), "higher")){
      higher.persistentID(tmp->entryName());
    }
    else if(!strcasecmp(tmp->entryName(), "lower")){
      d_Ref<NRnode> d;
      d.persistentID(tmp->entryName());
      lower.push_back(d);
    }
  }
}

istream& operator>>(istream& s, NRnode& n)
{
  NamedField nf;
  if(s)
    s >> nf;
  if(s)
    n._NRnode(nf);
  return s;
}

ostream& operator<<(ostream& s, const NRnode& n)
{
  if(!n.namerecord) return s;
  s << n._classname << " = {\n";
  s << " persistentID = {" << n.persistentID() << "}\n";
  s << " NameRecord = {" << n.namerecord->persistentID() << "}\n";
  if(!n.annotations.empty()){
    list<d_Ref<Annotation> >::const_iterator iter;
    for(iter = n.annotations.begin();iter != n.annotations.begin();++iter)
      s << " Annotation = {" << iter->persistentID() << "}\n";
  }
  if(!n.from.empty()){
    list<d_Ref<NRnode> >::const_iterator ni = n.from.begin();
    list<d_Ref<NRnode> >::const_iterator ne = n.from.end();
    while(ni != ne){
      s << " from = {" << ni->persistentID() << "}\n";
      ++ni;
    }
  }
  if(!n.to.empty()){
    list<d_Ref<NRnode> >::const_iterator ni = n.to.begin();
    list<d_Ref<NRnode> >::const_iterator ne = n.to.end();
    while(ni != ne){
      s << " to = {" << ni->persistentID() << "}\n";
      ++ni;
    }
  }
#if 1
  string str(n.higher.persistentID());
  if(0 != str.length())
    s << " higher = {" << str << "}\n";
  list<d_Ref<NRnode> >::const_iterator iter = n.lower.begin();
  list<d_Ref<NRnode> >::const_iterator end  = n.lower.end();
  while(iter != end){
    s << " lower = {" << iter->persistentID() << "}\n";
    iter++;
  }
#endif
  s << "}\n";
  return s;
}

#if 0
list<NRnode*> navigate(const NRnode *node)
{
  list<NRnode*> ret;
  navigate(node, ret);
  return ret;
}
#endif

void navigate(const NRnode *node, set<NRnode*>& s)
{
  if(s.end() != s.find((NRnode*)node)) return;
  s.insert((NRnode *)node);
  register list<d_Ref<NRnode> >::const_iterator i = node->from.begin();
  list<d_Ref<NRnode> >::const_iterator end = node->from.end();
  while(i != end){
    navigate(i->ptr(), s);
    ++i;
  }
  i = node->to.begin();
  end = node->to.end();
  while(i != end){
    navigate(i->ptr(), s);
    ++i;
  }
}

void navigate(const NRnode *node, list<NRnode*>& s)
{
  register list<NRnode*> ::const_iterator iter = s.begin();
  register list<NRnode*> ::const_iterator e = s.end();
  while(e != iter && *iter != node)iter++;
  if(e != iter) return;

  s.push_back((NRnode*)node);
  register list<d_Ref<NRnode> >::const_iterator i = node->from.begin();
  list<d_Ref<NRnode> >::const_iterator end = node->from.end();
  while(i != end){
    navigate(i->ptr(), s);
    ++i;
  }
  i = node->to.begin();
  end = node->to.end();
  while(i != end){
    navigate(i->ptr(), s);
    ++i;
  }
}


list<NRnode*> navigate(const NRnode *node)
{
  list<NRnode*> s;
  s.push_back((NRnode*)node);
  register list<d_Ref<NRnode> >::const_iterator i = node->from.begin();
  list<d_Ref<NRnode> >::const_iterator end = node->from.end();
  while(i != end){
    navigate(i->ptr(), s);
    ++i;
  }
  i = node->to.begin();
  end = node->to.end();
  while(i != end){
    navigate(i->ptr(), s);
    ++i;
  }
  s.sort();
  s.unique();
  return s;
}


list<NRnode*> current(const NRnode *node)
{
  list<NRnode*> ret;
  list<NRnode*> s(navigate(node));
  register list<NRnode*>::const_iterator i = s.begin();
  list<NRnode*>::const_iterator end = s.end();
  while(i != end){
    if(((*i)->from).empty())
      ret.push_back(*i);
    ++i;
  }
  ret.sort();
  ret.unique();
  ret.sort(NRnode::gt());
  return ret;
}

list<NRnode*> origine(const NRnode *node)
{
  list<NRnode*> ret;
  list<NRnode*> s(navigate(node));
  register list<NRnode*>::const_iterator i = s.begin();
  list<NRnode*>::const_iterator end = s.end();
  while(i != end){
    if(((*i)->to).empty())
      ret.push_back(*i);
    ++i;
  }
  ret.sort();
  ret.unique();
  ret.sort(NRnode::gt());
  return ret;
}

list<NRnode*> synonymize(const NRnode *node)
{
  list<NRnode*> ret;
  list<NRnode*> s(navigate(node));
  register list<NRnode*>::const_iterator i = s.begin();
  list<NRnode*>::const_iterator end = s.end();
  while(i != end){
    if(!((*i)->namerecord->annotation).empty()){
      list <d_Ref<Annotation> >::const_iterator iter
	= ((*i)->namerecord->annotation).begin();
      list <d_Ref<Annotation> >::const_iterator e
	= ((*i)->namerecord->annotation).end();
      while(iter != e){
	if(strncmp((*iter)->annotation(), "rev", 3) &&
	   strncmp((*iter)->annotation(), "nov", 3))
	  break;
	iter++;
      }
      if(iter != e){
	ret.push_back(*i);
	register list<d_Ref<NRnode> >::const_iterator diter = (*i)->to.begin();
	list<d_Ref<NRnode> >::const_iterator end = (*i)->to.end();
	while(diter != end){
	  ret.push_back(diter->ptr());
	  ++diter;
	}
      }
    }
    ++i;
  }
  ret.sort();
  ret.unique();
  ret.sort(NRnode::gt());
  return ret;
}

list<NRnode*> revise(const NRnode *node)
{
  list<NRnode*> ret;
  list<NRnode*> s(navigate(node));
  register list<NRnode*>::const_iterator i = s.begin();
  list<NRnode*>::const_iterator end = s.end();
  while(i != end){
    if(!((*i)->namerecord->annotation).empty()){
      list <d_Ref<Annotation> >::const_iterator iter
	= ((*i)->namerecord->annotation).begin();
      list <d_Ref<Annotation> >::const_iterator e
	= ((*i)->namerecord->annotation).end();
      while(iter != e){
	if(!strncmp((*iter)->annotation(), "rev", 3))
	  break;
	iter++;
      }
      if(iter != e)
	ret.push_back(*i);
    }
    ++i;
  }
  ret.sort();
  ret.unique();
  ret.sort(NRnode::gt());
  return ret;
}



bool NRnode::lt_by_year::operator()(NRnode& r1, NRnode& r2){
  NameRecord::lt_by_year op;
  return op(*(r1.namerecord), *(r2.namerecord));
}

bool NRnode::lt_by_year::operator()(NRnode *r1, NRnode *r2){
  NameRecord::lt_by_year op;
  return op(*(r1->namerecord), *(r2->namerecord));
}

bool NRnode::gt_by_year::operator()(NRnode& r1, NRnode& r2){
  NameRecord::gt_by_year op;
  return op(*(r1.namerecord), *(r2.namerecord));
}

bool NRnode::gt_by_year::operator()(NRnode* r1, NRnode* r2){
  NameRecord::gt_by_year op;
  return op(*(r1->namerecord), *(r2->namerecord));
}


bool NRnode::lt::operator()(NRnode& r1, NRnode& r2){
  NameRecord::lt op;
  return op(*(r1.namerecord), *(r2.namerecord));
}

bool NRnode::lt::operator()(NRnode *r1, NRnode *r2){
  NameRecord::lt op;
  return op(*(r1->namerecord), *(r2->namerecord));
}

bool NRnode::gt::operator()(NRnode& r1, NRnode& r2){
  NameRecord::gt op;
  return op(*(r1.namerecord), *(r2.namerecord));
}

bool NRnode::gt::operator()(NRnode* r1, NRnode* r2){
  NameRecord::gt op;
  return op(*(r1->namerecord), *(r2->namerecord));
}

NRnode* NRnode::top(void)
{
  NRnode *pnr = this;
  NRnode *upper = this;
  while(NULL != (upper = pnr->higher.ptr()))
    pnr = upper;

  return pnr;
}

#if 0
NRnode* NRnode::higher(void)
{
  if(0 == higher.persisntentID().length())
    return this;

  else
    retrn _higher.ptr();
}
#endif

list<NRnode*> NRnode::bottom(void)
{
  list<NRnode*> ret;
  if(lower.empty()){
    ret.push_back(this);
    return ret;
  }
  list<d_Ref<NRnode> >::iterator iter = lower.begin();
  list<d_Ref<NRnode> >::iterator end  = lower.end();
  while(iter != end){
    //    ret.merge(((NRnode*)((*iter).ptr()))->bottom());
    list<NRnode*> tmp((*iter).ptr()->bottom());  //why?
    ret.merge(tmp);
    ++iter;
  }
  return ret;
}


void NRnode::_lowerCopy(const NameRecord *pnr)
{
  if(pnr == NULL){
    return;
  }

  list<d_Ref<NameRecord> >::const_iterator iter = pnr->lowerNR.begin();
  list<d_Ref<NameRecord> >::const_iterator end  = pnr->lowerNR.end();
  while(iter != end){
    d_Ref<NRnode> dnrn;
    string s("");
    if(NULL != iter->ptr())
      s = iter->ptr()->persistentID();
    else
      s = iter->persistentID();
    dnrn.persistentID(_persistentID(s));
    lower.push_back(dnrn);
    ++iter;
  }
}

NRnode* NRnode::resolve(Resolver &r)
{

  string s(NRnode::persistentID());

  hash_map<string, list<NRnode*>, Hash<string> >::iterator nrniter = r.nrn.find(s);
  hash_map<string, list<NRnode*>, Hash<string> >::iterator nrnend = r.nrn.end();
  if(nrniter != nrnend){
    list<NRnode*>::iterator iter = nrniter->second.begin();
    list<NRnode*>::iterator end = nrniter->second.end();
    while(iter != end){
      if(this == *iter)
	return this;
      if((*iter)->merge(this))
	return *iter;
      ++iter;
    }
  }

  r.nrn[s].push_back(this);
  r.newNRnodes.push_back(this);

  hash_map<string, list<d_Ref<NRnode>*>, Hash<string> >::iterator unrniter = r.unrn.find(s);

  if(unrniter != r.unrn.end()){
    register list<d_Ref<NRnode>*>::iterator iter = unrniter->second.begin();
    register list<d_Ref<NRnode>*>::iterator end = unrniter->second.end();
    register list<d_Ref<NRnode>*>::iterator current;
    while(iter != end){
      current = iter;
      ++iter;
      if(NULL == (*current)->ptr() && s == (*current)->persistentID()){
	  (*current)->ptr(this);
	  unrniter->second.erase(current);
      }
    }
  }

  if(NULL != namerecord.ptr()){
    NameRecord *q = namerecord->resolve(r);
    if(namerecord.ptr() != q)
      namerecord.ptr(q);
  }
  //  else if(namerecord.persistentID().length() > NameRecord().persistentID().length())
  else{
    if(namerecord.persistentID().length() > 0)
      namerecord.resolve(r.nr, r.unr);
  }


  if(NULL != higher.ptr()){
    NRnode *q = higher->resolve(r);
    if(higher.ptr() != q)
      higher.ptr(q);
  }
  else {
    string hpid(higher.persistentID());
    if(0 != hpid.length()){
      higher.resolve(r.nrn, r.unrn);
    }
  }

  if(!lower.empty()){
    list<d_Ref<NRnode> >::iterator iter = lower.begin();
    list<d_Ref<NRnode> >::iterator end = lower.end();
    while(iter != end){
      if(NULL != iter->ptr()){
	NRnode *q = (*iter)->resolve(r);
	if(iter->ptr() != q){
	  iter->ptr(q);
	}
      }
      else{
	iter->resolve(r.nrn, r.unrn);
      }
      ++iter;
    }
  }

  list<d_Ref<NRnode> >::iterator i = from.begin();
  list<d_Ref<NRnode> >::iterator e = from.end();
  while(i != e){
    if(NULL != i->ptr()){
      NRnode *q = i->ptr()->resolve(r);
      if(q != i->ptr())
	i->ptr(q);
    }
    else{
      (*i).resolve(r.nrn, r.unrn);
    }
    i++;
  }

  i = to.begin();
  e = to.end();
  while(i != e){
    if(NULL != i->ptr()){
      NRnode *q = i->ptr()->resolve(r);
      if(q != i->ptr())
	i->ptr(q);
    }
    else{
      (*i).resolve(r.nrn, r.unrn);
    }
    i++;
  }

  //  return NULL;
  return this;
}

NRnode* NRnode::resolve(hash_map<string, list<NRnode*>, Hash<string> > &nrn,
		     hash_map<string, list<NameRecord*>, Hash<string> > &nr,
		     hash_map<string, list<d_Ref<NRnode>*>, Hash<string> > &unrn,
		     hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr)
{
  string s(NRnode::persistentID());
  hash_map<string, list<NRnode*>, Hash<string> >::iterator nrniter = nrn.find(s);
  hash_map<string, list<NRnode*>, Hash<string> >::iterator nrnend = nrn.end();
  if(nrniter != nrnend){
    list<NRnode*>::iterator iter = nrniter->second.begin();
    list<NRnode*>::iterator end = nrniter->second.end();
    while(iter != end){
      if(this == *iter)
	return NULL;
      //      else if((*iter)->persistentID() == s){
      if((*iter)->merge(this)){
	return *iter;
      }
      ++iter;
    }
  }

  nrn[s].push_back(this);

  hash_map<string, list<d_Ref<NRnode>*>, Hash<string> >::iterator unrniter = unrn.find(s);

  if(unrniter != unrn.end()){
    list<d_Ref<NRnode>*>::iterator iter = unrniter->second.begin();
    list<d_Ref<NRnode>*>::iterator end = unrniter->second.end();
    while(iter != end){
      if(NULL == (*iter)->ptr()){
	string istr((*iter)->persistentID());
	if(s == istr)
	  (*iter)->ptr(this);
      }
      ++iter;
    }
  }

  if(NULL == namerecord.ptr()){
    namerecord.resolve(nr, unr);
  }
  if(NULL != higher.ptr()){
    NRnode *p = higher->resolve(nrn, nr, unrn, unr);
    if(NULL != p){
      //delete higehr.ptr();
    }
  }
  else {
    string hpid(higher.persistentID());
    if(0 != hpid.length()){
      higher.resolve(nrn, unrn);
    }
  }

  if(!lower.empty()){
    list<d_Ref<NRnode> >::iterator iter = lower.begin();
    list<d_Ref<NRnode> >::iterator end = lower.end();
    while(iter != end){
      if(NULL != iter->ptr()){
	NRnode *p = (*iter)->resolve(nrn, nr, unrn, unr);
	if(NULL != p){
	  //delete iter->ptr()!
	}
      }
      else{
	iter->resolve(nrn, unrn);
      }
      ++iter;
    }
  }
  return NULL;
}

void NRnode::_copyAnnotation(NameRecord *pnr)
{
  if(!pnr->annotation.empty()){
    list<d_Ref<Annotation> >::iterator aniter = pnr->annotation.begin();
    list<d_Ref<Annotation> >::iterator anend  = pnr->annotation.end();
    while(aniter != anend){
      annotations.push_back(*aniter);
      aniter++;
    }
  }
}

bool NRnode::merge(NRnode *n)
{
  static const bool refuse = false;
  if(n == NULL || n == this)
    return refuse;
  if(persistentID() != n->persistentID())
    return refuse;

  if(n->namerecord.ptr() != NULL){
    if(namerecord.ptr() != NULL)
      namerecord.ptr()->merge(n->namerecord.ptr());
    else
      namerecord.ptr(n->namerecord.ptr());
  }
  else if(namerecord.ptr() != NULL){
    n->namerecord.ptr(namerecord.ptr());
  }
  else
    namerecord.merge(n->namerecord);

  annotations.sort();
  n->annotations.sort();
  annotations.merge(n->annotations);
  annotations.unique();

  list<d_Ref<NRnode> >::iterator iter = n->from.begin();
  list<d_Ref<NRnode> >::iterator end  = n->from.end();
  register list<d_Ref<NRnode> >::iterator i;
  register list<d_Ref<NRnode> >::iterator e;
  while(iter != end){
    i = (*iter)->to.begin();
    e = (*iter)->to.end();
    while(i != e){
      if(i->ptr() == n)
	i->ptr(this);
      i++;
    }
    iter++;
  }

  iter = n->to.begin();
  end  = n->to.end();
  while(iter != end){
    i = (*iter)->from.begin();
    e = (*iter)->from.end();
    while(i != e){
      if(i->ptr() == n)
	i->ptr(this);
      i++;
    }
    iter++;
  }

  from.sort();
  n->from.sort();
  from.merge(n->from);
  from.unique();

  to.sort();
  n->to.sort();
  to.merge(n->to);
  to.unique();


  NRnode *h = n->higher.ptr();
  higher.merge(n->higher);

  if(h != NULL){
    i = h->lower.begin();
    e = h->lower.end();
    while(i != e){
      if(i->ptr() == n)
	i->ptr(this);
      i++;
    }
  }

  i = n->lower.begin();
  e  = n->lower.end();
  while(i != e){
    if(i->ptr() != NULL && i->ptr()->higher.ptr() == n){
      i->ptr()->higher.ptr(this);
    }
    i++;
  }

  lower.sort();
  n->lower.sort();
  lower.merge(n->lower);
  lower.unique();

  return !refuse;
}

bool NRnode::operator<(NRnode &n)
{
  if(this == &n)
    return false;
  if(namerecord.ptr() != NULL &&
     n.namerecord.ptr() != NULL)
    return *namerecord < *(n.namerecord);
  return persistentID() < n.persistentID();
}

bool NRnode::operator==(NRnode &n)
{  
  if(this == &n)
    return true;
  if(namerecord.ptr() != NULL &&
     n.namerecord.ptr() != NULL)
    return *namerecord == *(n.namerecord);
  return persistentID() == n.persistentID();
}
