/*
 *
 * NRnode.h: a definition of persistent navigation node NRnode class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: NRnode.h,v 1.8 1999/12/05 20:48:14 nozomi Exp $
 *	$Log: NRnode.h,v $
 *	Revision 1.8  1999/12/05 20:48:14  nozomi
 *	removed unnecessary include/declare
 *	
 *	Revision 1.7  1999/12/05 18:20:45  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.6  1999/09/23 06:36:22  nozomi
 *	resolve method using Resolver class
 *	
 *	Revision 1.5  1999/09/20 14:20:35  nozomi
 *	modification relatiog data addition
 *	
 *	Revision 1.4  1999/08/31 12:15:00  nozomi
 *	modificaitons relating change in Annotation (from set to list)
 *	
 *	Revision 1.3  1999/08/08 11:32:54  nozomi
 *	reference resolver add
 *	
 *	Revision 1.2  1999/08/08 04:18:44  nozomi
 *	Partial support of hierarchy
 *	
 *	Revision 1.1  1999/03/15 16:42:58  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:17:11  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// class NRnode (NameRecord node) is fourth level abstraction class.
// It is intensively used for navigation between NameRecords; core object of the NHM.
// NRnode has pointer to a NameRecord object and two lists of pointers
// to NRnode named from and to, and list of pointers to Annotation.
// Those two lists of NRnode pointer contains NRnode of which
// NameRecord's Annotation points to and pointed from the NRnode's
// NameRecord, respectively (it would be use figure to explain).
// NRnode is intended to be used as navigational node.  
//

#if (!defined(_INCLUDED_NRNODE_H))
#define _INCLUDED_NRNODE_H

#include "d_Object.h"
#include "d_Ref.h"

#if (!defined(_INCLUDED_NAMERECORD_H))
#include "NameRecord.h"
#endif

#if (!defined (_INCLUDED_ANNOTATION_H))
#include "Annotation.h"
#endif

#if (!defined(_INCLUDED_LIST) && !defined(_INCLUDED_SET))
#if (__GNUC_MINOR__ > 7)
#include <list>
#include <set>
#else
#include <list.h>
#include <set.h>
#endif
#define _INCLUDED_LIST
#define _INCLUDED_SET
#endif

class Resolver;

class NRnode:public d_Object{

public:
  NRnode(void);
  NRnode(const NRnode&);
  NRnode(const d_Ref<NameRecord>&);
  NRnode(const NameRecord&);
  NRnode(const NameRecord*);
  NRnode(const string &);
  NRnode& operator=(const NRnode&);
  ~NRnode(void);

  d_Ref<NameRecord> namerecord;
  list<d_Ref<Annotation> > annotations;
  list<d_Ref<NRnode> > from;
  list<d_Ref<NRnode> > to;

  d_Ref<NRnode> higher;
  list<d_Ref<NRnode> > lower;

  NRnode* top(void);
  //  NRnode* higher(void);
  list<NRnode*> bottom(void);
  bool merge(NRnode*);

  bool operator<(NRnode &);
  bool operator==(NRnode &);

  friend istream& operator>>(istream&, NRnode&);
  friend ostream& operator<<(ostream&, const NRnode&);
  string persistentID(void) const;

  struct lt:public binary_function<NRnode, NRnode, bool>{
    bool operator()(NRnode& r1, NRnode& r2);
    bool operator()(NRnode* r1, NRnode* r2);
  };

  struct gt:public binary_function<NRnode, NRnode, bool>{
    bool operator()(NRnode& r1, NRnode& r2);
    bool operator()(NRnode* r1, NRnode* r2);
  };

  struct lt_by_year:public binary_function<NRnode, NRnode, bool>{
    bool operator()(NRnode& r1, NRnode& r2);
    bool operator()(NRnode* r1, NRnode* r2);
  };

  struct gt_by_year:public binary_function<NRnode, NRnode, bool>{
    bool operator()(NRnode& r1, NRnode& r2);
    bool operator()(NRnode* r1, NRnode* r2);
  };

  struct lt_by_name:public binary_function<NRnode, NRnode, bool>{
    bool operator()(NRnode& r1, NRnode& r2);
    bool operator()(NRnode* r1, NRnode* r2);
  };

  struct gt_by_name:public binary_function<NRnode, NRnode, bool>{
    bool operator()(NRnode& r1, NRnode& r2);
    bool operator()(NRnode* r1, NRnode* r2);
  };

  NRnode* resolve(hash_map<string, list<NRnode*>, Hash<string> > &nrn,
	       hash_map<string, list<NameRecord*>, Hash<string> > &nr,
	       hash_map<string, list<d_Ref<NRnode>*>, Hash<string> > &unrn,
	       hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr);

  NRnode* resolve(Resolver &);

  ostream& printTo(ostream &) const;

private:
  static const char* const _classname = "NRnode";
  //  d_Ref<NRnode> _higher;

  void _NRnode(const NamedField&);
  void _NRnode(const NameRecord*);

  string _persistentID(const string &str) const;
  void _lowerCopy(const NameRecord *pnr);
  void _copyAnnotation(NameRecord *pnr);

};

inline ostream& NRnode::printTo(ostream & os) const { return os << *(NRnode*)this; }

#include "Resolver.h"

void navigate(const NRnode *node, set<NRnode*>& s);
void navigate(const NRnode *node, list<NRnode*>& s);
list<NRnode*> navigate(const NRnode *node);
list<NRnode*> current(const NRnode *node);
list<NRnode*> origine(const NRnode *node);
list<NRnode*> synonymize(const NRnode *node);
list<NRnode*> revise(const NRnode *node);

#endif //_INCLUDED_NRNODE_H
