/*
 *
 * NameRecord.h: a definition of persistent NameRecord class
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: NameRecord.h,v 1.13 1999/12/05 20:48:22 nozomi Exp $
 *	$Log: NameRecord.h,v $
 *	Revision 1.13  1999/12/05 20:48:22  nozomi
 *	removed unnecessary include/declare
 *	
 *	Revision 1.12  1999/12/05 18:20:53  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.11  1999/09/20 14:19:02  nozomi
 *	modification relating data addition
 *	
 *	Revision 1.10  1999/08/18 13:35:43  nozomi
 *	change include files
 *	add methods year and page
 *	Some return values are d_Ref<Citation>& instead of d_Ref<Citation>; is it OK?
 *	
 *	Revision 1.9  1999/08/16 06:56:43  nozomi
 *	PID converter name changed
 *	
 *	Revision 1.8  1999/08/16 06:52:32  nozomi
 *	persistentID version 2 supporting functions add
 *	
 *	Revision 1.7  1999/08/08 11:35:53  nozomi
 *	delete prototypes not used anymore
 *	
 *	Revision 1.6  1999/08/08 04:16:21  nozomi
 *	Methods top and bottom to navigate hierarchy defined
 *	
 *	Revision 1.5  1999/08/06 07:38:06  nozomi
 *	add constructor
 *	
 *	Revision 1.4  1999/03/20 16:10:24  nozomi
 *	bool NameRecord::marge(NameRecord *) and relatings.
 *	
 *	Revision 1.3  1999/03/15 16:42:56  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.2  1999/03/15 11:24:52  nozomi
 *	persistentID related modifications
 *	
 *	Revision 1.1  1999/03/14 18:19:17  nozomi
 *	add author string private function
 *	
 *	Revision 1.0  1999/03/14 02:17:25  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// class NameRecord is third level abstraction from publication enitity.
// It is abstraction from Citation class.
// NameRecord has slots for hierarchy name, generic name, specific name,
// two pointers to Citation object named authority and recorder
// respectively, list of pointers to Annotation object, pointer to 
// NameRecord named type, typeOf, higher, and a list of pointers to
// NameRecord named lowerNR.  Pointer to Citation named recorder pints
// from where the NameRecord abstracted.  The authority points original
// citation of the name expressed by the NameRecord object. Pointer
// type points type NameRecord if there is, and typeOf pointer is its
// inverse.  Pointer higher points a NameRecord object expressing
// higher hierarchy.  List named lowerNR holds pointer to instances of
// the taxon if it has (i.e. if the NameRecord is an instance of genus,
// is may hold pointers to belonging species in lowerNR list).
// List of pointers to Annotation object holds annotational information
// appeared in the source publication entity, hence it contains only
// annotations on PAST works.
//

#if (!defined(_INCLUDED_NAMERECORD_H))
#define _INCLUDED_NAMERECORD_H

#if (__GNUC_MINOR__ > 7)
#if !defined(_INCLUDED_LIST)
#include <list>
#define _INCLUDED_LIST
#endif
#if !defined(_INCLUDED_IOSTREAM)
#include <iostream>
#define _INCLUDED_STREAM
#endif
#if !defined(_INCLUDED_FUNCTIONAL)
#include <functional>
#define _INCLUDED_FUNCTIONAL
#endif
#else
#if !defined(_INCLUDED_LIST)
#include <list.h>
#define _INCLUDED_LIST
#endif
#if !defined(_INCLUDED_IOSTREAM)
#include <iostream.h>
#define _INCLUDED_ISSTREAM
#endif
#if !defined(_INCLUDED_FUNCTIONAL)
#include <functional.h>
#define _INCLUDED_FUNCTIONAL
#endif
#endif

#include "d_common.h"
#include "d_Object.h"
#include "d_Ref.h"
#if (!(defined _INCLUDED_NAMEDFIELD_H))
#include "NamedField.h"
#define _INCLUDED_NAMEDFIELD_H
#endif
#include "Date.h"

class Author;
class Annotation;
class Citation;
//class Nomencurator;
class NRnode;
class Publication;
class Resolver;

template <class T> struct d_Ref_unify;

class NameRecord:public d_Object{ 
  friend class d_Ref<NameRecord>;
  friend class NRnode;
  //  friend class Nomencurator;
  friend struct d_Ref_unify<NameRecord>;
public:
  //constructor
  NameRecord(void);
  NameRecord(const char* s);
  NameRecord(const string& s);
  NameRecord(const NameRecord& nr);
  NameRecord& operator=(const NameRecord& nr);
  //NameRecord(string mj, string mn, string g, string r = "", string a = "");
  //NameRecord(string mj, string mn, string g, Publication *r, string pr, Publication *a= NULL, string pa ="");
  NameRecord(const char *recorder, int recorded, 
	     const char *specific = "", const char *generic = "", const char *group = "",
	     const char *authoizer = "", int authorized = Date::invalidYear);
  NameRecord(Citation& r, 
	     const char * specific = NULL, const char * generic = NULL, const char * group = NULL);
  NameRecord(d_Ref<Citation>& r, 
	     const char * specific, const char * generic, const char * group,
	     d_Ref<Citation>& a);
  NameRecord(Citation& r, 
	     const char * specific, const char * generic, const char * group,
  	     Citation& a);
  NameRecord(Citation *r, 
	     const char * specific, const char * generic, const char * group,
  	     Citation *a);
  NameRecord(Publication& r, 
	     const char * specific = "", const char * generic = "", const char * group = "");
  NameRecord(Publication &r, 
	     const char * specific, const char * generic, const char * group,
	     Publication &a);
  NameRecord(const NamedField *nf, const char* fn = "NameRecord");
  NameRecord(const NamedField &nf, const char* fn = "NameRecord");

  //destructor
  ~NameRecord();

  //accesor
  bool isA(NameRecord*);
  bool has(NameRecord*);
  bool isTypeOf(NameRecord*);
  //  NameRecord* type(void);

  string name(void) const;
  string generic(void) const;
  string specific(void) const;
  string group(void) const;
  int year(void) const;
  string page(void) const;
  NameRecord* top(void);
  list<NameRecord*> bottom(void);

  d_Ref<Citation> authority() const;
  d_Ref<Citation> recorder() const;

  string authorityStr(void) const;
  string recorderStr(void) const;
  d_Ref<NameRecord>& type(void);
  d_Ref<NameRecord>& typeOf(void);
  d_Ref<NameRecord>& higher(void);

  //manipulator
  void generic(const char*);
  void specific(const char*);
  void group(const char*);
  void generic(const string &);
  void specific(const string &);
  void group(const string &);
  void year(int);
  void page(int);
  void page(const char*);

  void authority(Citation*);
  void recorder(Citation*);
  void authority(const d_Ref<Citation>&);
  void recorder(const d_Ref<Citation>&);

  void type(d_Ref<NameRecord> dnr);
  void typeOf(d_Ref<NameRecord> dnr);
  void higher(d_Ref<NameRecord> dnr);
  
  //register... have you ever use them?
  NameRecord* regist(NameRecord*);
  NameRecord* registTo(NameRecord*);
  NameRecord* unregistFrom(NameRecord*);
  NameRecord* unregist(NameRecord*);
  //NameRecord* type(NameRecord* t=NULL);

  //I/O
  friend istream& operator>>(istream & s, NameRecord& nr);
  friend ostream& operator<<(ostream & s, NameRecord& nr);
  ostream& printTo(ostream &) const;

private:  
  static const int _currentPIDversion = 3/*2*/;

public:
  string persistentID(void) const;
  string persistentID(int) const;
  static string persistentID(const char* s, int v = _currentPIDversion);
  static string persistentID(const string &s, int v = _currentPIDversion);
  string recorderID(void) const;
  string authorityID(void) const;
  string recorderPublicationID(void) const;
  string authorityPublicationID(void) const;
  string recorderPublicationString(void) const;
  string authorityPublicationString(void) const;

  static int pidVersion(const char*);

  list<d_Ref<Annotation> > annotation; 
  list<d_Ref<NameRecord> > lowerNR;  // list of pointers to lower hierarchy group

  //  friend bool operator==(NameRecord* nr1, NameRecord* nr2);
  //  friend bool operator==(NameRecord& nr1, NameRecord& nr2);
  //  friend bool unique(NameRecord* nr1, NameRecord* nr2);
  //  friend bool unique(NameRecord& nr1, NameRecord& nr2);
  //  friend bool unify(NameRecord* nr1, NameRecord* nr2);
  //  friend bool unify(NameRecord& nr1, NameRecord& nr2);
  //  friend bool unify(d_Ref<NameRecord>* nr1, d_Ref<NameRecord>* nr2);
  //  friend bool unify(d_Ref<NameRecord>& nr1, d_Ref<NameRecord>& nr2);
  friend bool operator==(const NameRecord& nr, const string& s);
  friend bool operator==(const string& s, const NameRecord& nr);
  friend bool operator!=(const NameRecord& nr, const string& s);
  friend bool operator!=(const string& s, const NameRecord& nr);

  friend bool operator==(const NameRecord&, const NameRecord&);
  friend bool operator!=(const NameRecord&, const NameRecord&);
  friend bool operator<(const NameRecord&, const NameRecord&);
  friend bool operator>(const NameRecord&, const NameRecord&);
  friend bool operator<=(const NameRecord&, const NameRecord&);
  friend bool operator>=(const NameRecord&, const NameRecord&);

  NameRecord* resolve(Resolver &);
  NameRecord* resolve(hash_map<string, list<NameRecord*>, Hash<string> > &nr,
		      hash_map<string, list<Annotation*>, Hash<string> > &an,
		      hash_map<string, list<Citation*>, Hash<string> > &ci,
		      hash_map<string, list<Publication*>, Hash<string> > &pub,
		      hash_map<string, list<Author*>, Hash<string> > &au,
		      hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > &unr,
		      hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > &uan,
		      hash_map<string, list<d_Ref<Citation>*>, Hash<string> > &uci,
		      hash_map<string, list<d_Ref<Publication>*>, Hash<string> > &upub,
		      hash_map<string, list<d_Ref<Author>*>, Hash<string> > &uau);

  bool merge(NameRecord*);
  bool eq(const NameRecord nr, int skip = 0, int ignore = 0) const;
  const d_Ref<NameRecord>* find(const list<d_Ref<NameRecord> > &lnr, int skip = 0, int ignore = 0) const;

  struct lt:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct gt:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct lt_by_year:public binary_function<const NameRecord, const NameRecord, bool>{
    bool operator()(const NameRecord& r1, const NameRecord& r2);
  };
  struct gt_by_year:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct lt_by_group:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct gt_by_group:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct lt_by_generic:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct gt_by_generic:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct lt_by_name:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };
  struct gt_by_name:public binary_function<NameRecord, NameRecord, bool>{
    bool operator()(NameRecord& r1, NameRecord& r2);
  };

private:  
  static const char* const _classname = "NameRecord";

  //  static const int _currentPIDversion = 2/*3*/;

  string _trinityName(void) const;
  string _persistentID(int) const;
  static string* _pidParse(const char*s);
  int _underscores(int version = _currentPIDversion) const;

  //name tags
  char* _genericName; // generic name
  char* _specificName; // specific name
  char* _hierarchy; // name of its hierarchy...a key to registrate 

  //identity tags
  d_Ref<Citation> _authority;
  d_Ref<Citation> _recorder;


  //relations
  d_Ref<NameRecord> _type;
  d_Ref<NameRecord> _typeOf;
  d_Ref<NameRecord> _higherNR;  // pointer to higher hierarchy group
  //d_Ref<void*> _anyUse;

  void _NameRecord(const char* s);
  void _NameRecord(const string& s);
  void _NameRecord(const NamedField *nf, const char* fn);
  bool _weakcmp(const string& s) const;
  bool _weakcmp(const NameRecord& nr) const;
  string _authorWithYear(const Citation &) const;
  string _authorWithYear(const d_Ref<Citation>& c) const;
  string _publicationStr(const d_Ref<Citation>& c) const;
  bool _mergeCitations(d_Ref<Citation> &first, d_Ref<Citation> &second);
  bool _mergetypes(NameRecord* from);
  bool _mergeNames(NameRecord* from);
  bool _mergeRecorders(NameRecord* from);
  bool _mergeAuthorities(NameRecord* from);
};

inline ostream& NameRecord::printTo(ostream & os) const { return os << *(NameRecord*)this; }

inline string NameRecord::persistentID(void) const
{ return _persistentID(_currentPIDversion); }

inline string NameRecord::persistentID(int version) const
{ return _persistentID(version); }

inline string NameRecord::persistentID(const string &s, int castTo)
{ return persistentID(s.c_str(), castTo); }

#if (!defined(_INCLUDED_AUTHOR_H))
#include "Author.h"
#endif

#include "Annotation.h"
#if (!defined(_INCLUDED_CITATION_H))
#include "Citation.h"
#endif
/*
#if (!defined(_INCLUDED_NOMENCURATOR_H))
#include "Nomencurator.h"
#endif
*/
#if (!defined(_INCLUDED_NRNODE_H))
#include "NRnode.h"
#endif

#if (!defined(_INCLUDED_PUBLICATION_H))
#include "Publication.h"
#endif

#if (!defined(_INCLUDED_RESOLVER_H))
#include "Resolver.h"
#endif

inline d_Ref<Citation> NameRecord::authority(void) const{ return _authority;}
inline d_Ref<Citation> NameRecord::recorder(void) const{ return _recorder;}

inline void NameRecord::authority(Citation* a){ _authority = a;}
inline void NameRecord::recorder(Citation* r){ _recorder = r;}
inline void NameRecord::authority(const d_Ref<Citation> &a){ _authority = a;}
inline void NameRecord::recorder(const d_Ref<Citation> &r){ _recorder = r;}

inline d_Ref<NameRecord>& NameRecord::type(void) {return _type;}
inline d_Ref<NameRecord>& NameRecord::typeOf(void) {return _typeOf;}
inline d_Ref<NameRecord>& NameRecord::higher(void) {return _higherNR;} 

inline void NameRecord::type(d_Ref<NameRecord> dnr) {_type = dnr;}
inline void NameRecord::typeOf(d_Ref<NameRecord> dnr) {_typeOf = dnr;}
inline void NameRecord::higher(d_Ref<NameRecord> dnr) {_higherNR =dnr;} 

//inline bool unique(NameRecord& nr1, NameRecord& nr2)
//{return unique(& nr1, & nr2);}

inline bool operator==(const NameRecord& nr, const string& s){return nr._weakcmp(s);}
inline bool operator==(const string& s, const NameRecord& nr){return nr._weakcmp(s);}
inline bool operator!=(const NameRecord& nr, const string& s){return !nr._weakcmp(s);}
inline bool operator!=(const string& s, const NameRecord& nr){return !nr._weakcmp(s);}

inline bool operator!=(const NameRecord& nr1, const NameRecord& nr2)
{ return !(nr1 == nr2);}

inline bool operator>(const NameRecord& nr1, const NameRecord& nr2)
{ return !(nr1 <= nr2);}

inline bool operator<=(const NameRecord& nr1, const NameRecord& nr2)
{ return (nr1 == nr2) || (nr1 < nr2); }

inline bool operator>=(const NameRecord& nr1, const NameRecord& nr2)
{ return  !(nr1 < nr2);}

inline string NameRecord::authorityStr(void) const{ return _authorWithYear(_authority);}

inline string NameRecord::recorderStr(void) const{ return _authorWithYear(_recorder);}


inline string NameRecord::group(void) const {return _hierarchy;}

#if 0
#include <functional>
class Majror_eq:public unary_function<NameRecord, bool>{
  string s;
public:
  explicit Majror_eq(const char* str):s(str){}
  explicit Majror_eq(const string str):s(str){}
  bool operator()(const NameRecord& nr) const
  {return nr.generic() == s;}
};

class Minor_eq:public unary_function<NameRecord, bool>{
  string s;
public:
  explicit Minor_eq(const char* str):s(str){}
  explicit Minor_eq(const string str):s(str){}
  bool operator()(const NameRecord& nr) const
  {return nr.specific() == s;}
};

#endif

#endif //_INCLUDED_NAMERECORD_H
