/*
 *
 * NamedField.cxx: an implementation of class handling structured text
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: NamedField.cxx,v 1.1 1999/03/15 16:42:38 nozomi Exp $
 *	$Log: NamedField.cxx,v $
 *	Revision 1.1  1999/03/15 16:42:38  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:17:32  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

static bool isCommnetLine(char* line);
static bool isEmptyField(char* line);
#if 0
static bool isEmptyLine(char* line);
#endif
static char* entryOpened(char *buffer);

#include "NamedField.h"
#if (__GNUC_MINOR__ > 7)
#include <stack>
#else
#include <stack.h>
#endif

NamedField::NamedField(const NamedField &r)
  :_entryName(new_strdup::strdup(r._entryName)),
	      _contents(new_strdup::strdup(r._contents)), subEntries(r.subEntries){}

NamedField& NamedField::operator=(const NamedField & r)
{
  delete[] _entryName;delete[] _contents;
  _entryName = new_strdup::strdup(r._entryName);
  _contents = new_strdup::strdup(r._contents);
  subEntries = r.subEntries;
  return *this;
}

const char* NamedField::_cmp(int (*cmpfunc)(const char *, const char *),  const char* s) const
{
  if(!cmpfunc(_entryName, s)) return _contents;

  list<NamedField>::const_iterator tmp;
  for(tmp = subEntries.begin(); tmp != subEntries.end(); ++tmp)
    {if(!cmpfunc(tmp->_entryName, s)) return tmp->_contents;}
  return NULL;
}

const char* NamedField::_ncmp(int (*cmpfunc)(const char *, const char *, size_t),  const char* s, size_t n) const
{
  if(!cmpfunc(_entryName, s, n)) return _contents;

  list<NamedField>::const_iterator tmp;
  for(tmp = subEntries.begin(); tmp != subEntries.end(); ++tmp)
    { if(!cmpfunc(tmp->_entryName, s, n)) return tmp->_contents; }
  return NULL;
}

istream& operator>>(istream & s, NamedField &e)
{
  char *fn, *cnt, *tail;
  const int buflen = 256;
  char buffer[buflen];  //XXX
  int length;
  int depth = 0, prevDepth = 0;
  char *atOpen, *atClose;
  char *lastOpen, *lastClose;
  bool continuedLine = false;
  bool toBeContinued = false;
  bool isEmpty;
  char *continued = NULL;
  char *continuedField = NULL;
  char *newField = NULL;
  char *prevNewField = NULL;
  NamedField *writeTo = &e;
  stack<NamedField*> entryStack;
  atOpen = 0;
  atClose = 0;

  //recursive clean of subEntries
  if(!e.subEntries.empty())
    {
      while(!writeTo->subEntries.empty()){
	entryStack.push(writeTo);
	writeTo = &*(writeTo->subEntries.begin());
      }
      while(writeTo != &e){
	writeTo = entryStack.top();
	entryStack.pop();
	writeTo->subEntries.clear();
      }
      e.subEntries.clear();
    }

  delete[] e._entryName;delete[] e._contents;
  e._entryName = new char[1];*e._entryName = 0;
  e._contents = new char[1];*e._contents = 0;
  

  // skip blank lines to find the first record
  do{
    s.getline(buffer, buflen, '\n');
    length = s.gcount() - 1;
    newField = entryOpened(buffer);
  }while(s && NULL == newField);

  bool preRead = true;

  do{
    if(preRead)
      preRead = false;
    else{
      s.getline(buffer, buflen, '\n');
      length = s.gcount() - 1;
      newField = entryOpened(buffer);
    }

    if(isCommnetLine(buffer))
      goto _read_next_line;

    toBeContinued = false;

    fn = buffer; atOpen = 0; atClose = 0;

    //weak inconsistency check.
    for(int i = fn - buffer; i < length; fn++,i++){
      switch(*fn){
      case '{': depth++; if(!atOpen) atOpen = fn; lastOpen = fn; break;
      case '}': depth--; if(!atClose) atClose = fn; lastClose = fn;break;
      }
    }

    if(atClose){
      *atClose = 0;
      toBeContinued = false;
    }
    else{
      tail = buffer + length - 1;
      for(int i = 0; i  < length && isspace(*tail); i++, tail--) {};
      if('\\' == *tail)
	*tail = 0;
      else if(tail < buffer + length - 1)
	*(tail + 1) = 0;
      toBeContinued = true;
    }

    // skip ws
    fn = buffer;
    for(int i = 0; i < length && isspace(*fn); fn++,i++){}

    if(newField){
      cnt = newField;
      int len = cnt - buffer;
      for(int i = 0; i < len && '=' != *cnt-- ; i++){}
      // skilp ws tailing to field name
      if(isspace(*cnt)){
	len = cnt - buffer;
	for(int i = 0; i < len && isspace(*cnt) ; cnt--, i++){}
      }
	*(cnt+1) = 0; //zero terminate fieldname pointed by fn
      cnt = newField;
    }

    else
      cnt = fn;
    
    if(continuedLine){

      if(newField){
	if(prevNewField){
	  if(prevDepth > 1){
	    //	    writeTo->subEntries.push_front(NamedField(continuedField));
	    writeTo->subEntries.push_back(NamedField(continuedField));
	    entryStack.push(writeTo);
	    //	    writeTo = &(*writeTo->subEntries.begin());
	    writeTo = &(*(--(writeTo->subEntries.end())));
	  }
	  else{
	    delete [] writeTo->_entryName;
	    writeTo->_entryName = new_strdup::strdup(continuedField);
	  }
	}
	if(continuedField)
	  delete [] continuedField;
	continuedField = new char[strlen(fn) + 1];
	strcpy(continuedField, fn);
      }

      if(newField){
	if(continued)
	  delete [] continued;
	continued = new char[strlen(cnt) + 1];
	strcpy(continued, cnt);
	if(depth == prevDepth)
	  toBeContinued = false;
      }
      else{
	unsigned int catlen = strlen(continued);
	if(!isspace(continued[catlen - 1]))
	  catlen ++;
	char *tmp = new char[catlen + strlen(fn) + 1];
	if(NULL != tmp){
	  strcpy(tmp, continued);
	  if(catlen > strlen(continued))
	    strcat(tmp, " ");
	  strcat(tmp, fn);
	  delete [] continued;
	  continued = tmp;
	  tmp = NULL;
	}
      }
      if(!toBeContinued){
	fn = continuedField;
	cnt = continued;
	isEmpty = false;
      }
    }
    
    else{ // !continuedLine
      //fieldname generation
      if(NULL == newField)
	cnt = buffer;
      tail = cnt;

      isEmpty = isEmptyField(cnt);


      if(toBeContinued){
	isEmpty = true;
	if(newField){
	  if(continuedField)
	    delete [] continuedField;
	  continuedField = new char[strlen(fn) + 1];
	  strcpy(continuedField, fn);
	}
	if(strlen(cnt)){
	  continued = new char[strlen(cnt) + 1];
	  strcpy(continued, cnt);
	}
	else{
	  continued = new char[1];
	  *continued = 0;
	}
      }
    }

    if(!isEmpty && !toBeContinued)
      {
	if(continuedLine){
	  if(depth){
	    //	    //	    writeTo->subEntries.push_front(NamedField (continuedField, continued));
	    //writeTo->subEntries.push_front(NamedField(fn, cnt));
	    writeTo->subEntries.push_back(NamedField(fn, cnt));
	  }
	  //else ?

	  delete [] continuedField;
	  continuedField = NULL;
	  delete [] continued;
	  continued = NULL;
	}
	else{
	  if(depth)
	    //	    writeTo->subEntries.push_front(NamedField(fn, cnt));
	    writeTo->subEntries.push_back(NamedField(fn, cnt));
	  else if (newField){
	    delete [] writeTo->_entryName;
	    writeTo->_entryName = new_strdup::strdup(fn);
	    delete [] writeTo->_contents;
	    writeTo->_contents = new_strdup::strdup(cnt);
	  }
	}
      }
  _read_next_line:
    if (prevDepth > depth){
      if(writeTo != &e){
	writeTo = entryStack.top();
	entryStack.pop();
      }
    }
    
    continuedLine = toBeContinued;
    prevDepth = depth;
    prevNewField = newField;

  }while(depth && s);

  if(continuedField)
    delete [] continuedField;
  if(continued)
    delete [] continued;
  return s;
}

static bool isCommnetLine(char* line)
{
  int l = strlen(line);
  char* p = line;
  bool ret = false;
  for(int i = 0; i < l && isspace(*p);p++, i++){}

  switch(*p){
  case '!':
  case '%':
  case ';':
  case '#':
    ret = true;
    break;
  case '/':
    if('/' == *(p+ 1))
      ret = true;
    break;
  }

  return ret;
}

static bool isEmptyField(char* line)
{
  int l = strlen(line);

  char *openAt = line;
  char *closeAt = line + l - 1;

  for(int i = 0; i < l && '{' != (*openAt);openAt++, i++){}
  for(int i = 0; i < l && '}' != (*closeAt);closeAt--, i++){}

  if('{' == *openAt)
    openAt++;
  else
    openAt = line;
  if('}' == *closeAt)  
    closeAt--;
  else
    closeAt = line+l-1;

  if(openAt == closeAt)
    return isalnum(*openAt)? false:true;

  char *p = openAt;
  bool ret = true;

  for(int i = openAt - line; i < closeAt - line; p++,i++){
    if(isalnum(*p))
      ret = false;
  }
  return ret;
}

#if 0
static bool isEmptyLine(char* line)
{
  bool ret = true;
  if(NULL !=  line){
    int l = strlen(line);
    for(int i = 0; i < l; line++,i++)
      if(!isspace(*line))
	ret = false;
  }
  return ret;
}
#endif

static char* entryOpened(char *buffer)
{
  char* newField = NULL;

  if(NULL != buffer){
    char* fn = buffer;
    const int length = strlen(buffer) - 1;
    // skip ws
    for(int i = 0; i < length && isspace(*fn); fn++,i++){}
    char* cnt = fn;
    for(int i = fn - buffer; i < length && '=' !=*cnt; cnt++, i++){}
    if('=' == *cnt)
      {
	int i;
	cnt++;
	for(i = cnt - buffer; i < length && isspace(*cnt); cnt++,i++){}
	if('{' == *cnt  // new block opend by a '{'
	   || i == length //
	   || '\\' == *cnt
	   || isCommnetLine(cnt)      
	   )
	  newField = cnt+1;
      }
  }
  return newField;
}


//for test purpose only
ostream& operator<<(ostream & s, const NamedField &e)
{
  s << e._entryName;
  if(strlen(e._contents)){
    s << " = " << e._contents << endl;
  }
  else{
    list<NamedField>::const_iterator tmp;
    int l = 0;
    for(tmp = e.subEntries.begin(); tmp != e.subEntries.end(); ++tmp, l++){}
    
    if(l){
      s << " = {" << endl;
      tmp = e.subEntries.begin();
      for(int i = 0; i < l; ++tmp, i++){
	s << "\t" << *tmp;
      }
      s << "} //" << e._entryName << endl;
    }
  }

  return s;
}

