/*
 *
 * Nomencurator.h: a definition of navigational collection of persistent classes
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Nomencurator.h,v 1.10 1999/12/05 20:48:41 nozomi Exp $
 *	$Log: Nomencurator.h,v $
 *	Revision 1.10  1999/12/05 20:48:41  nozomi
 *	fix MACRO definition for include guard
 *	
 *	Revision 1.9  1999/12/05 18:25:21  nozomi
 *	class NHM renamed to Nomencurator
 *	
 *	Revision 1.8  1999/09/23 06:35:22  nozomi
 *	resolve method using Resolver class
 *	
 *	Revision 1.7  1999/09/20 14:19:46  nozomi
 *	data add/data merge support
 *	
 *	Revision 1.6  1999/08/26 07:22:08  nozomi
 *	some inline methods were moved to NHM.cxx
 *	
 *	Revision 1.5  1999/08/23 06:59:42  nozomi
 *	Add hash table of Publication by Author name
 *	
 *	Revision 1.4  1999/08/08 11:33:41  nozomi
 *	change in NRnode handling
 *	
 *	Revision 1.3  1999/08/07 08:53:36  nozomi
 *	hash table for persistentID support
 *	
 *	Revision 1.2  1999/03/15 16:42:57  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.1  1999/03/14 07:25:14  nozomi
 *	verbose parameter add
 *	
 *	Revision 1.0  1999/03/14 02:16:58  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// class Nomencurator: integration of classes conposing the Nomencurator.
// Nomencurator means Nomenclature Heuristic Model.
// Another name candidate is NNN, Nomenclature Navigational Network.  
// It is a container of all objects, rather than the next level
// abstraction.  However, it is clearly the next level meta data.  From 
// first to third level abstraction, classes used to analyze data
// structure.  NRnode and Nomencurator are used to integrate these objects.
// Nomencurator contains list of all basic objects, i.e. Author, Publication,
// Citation, NameRecord, Annotation, NRnode, and hash tables of
// NRnode accessible via generic name, specific name, combined name, 
// and hash tables of Author object and Publications.  The last two
// hash tables are retained, but not used (yet?).  Nomencurator also has access
// to hash tables.  It can be core of the `database' because it has
// hole list of persistent objects and way to access them.
// From view point of application program, it is the database.
// Basic application has style as:
//
//  class Nomencurator Nomencurator;
//  ifstream fin(filename);  //C++ style file open
//  while(fin) fin >> Nomencurator;   //read in data into Nomencurator
//  cout << Nomencurator.query("Cryptomonas");  //write to standard output
//

#if (!defined(_INCLUDED_NOMENCURATOR_H))
#define _INCLUDED_NOMENCURATOR_H

#if (!defined(_INCLUDED_D_REF_H))
#include "d_Ref.h"
#endif

#if (!defined(_INCLUDED_AUTHOR_H))
#include "Author.h"
#endif

#if (!defined(_INCLUDED_PUBLICATION_H))
#include "Publication.h"
#endif

#if (!defined(_INCLUDED_CITATION_H))
#include "Citation.h"
#endif

#if (!defined(_INCLUDED_NAMERECORD_H))
#include "NameRecord.h"
#endif

#if (!defined (_INCLUDED_ANNOTATION_H))
#include "Annotation.h"
#endif

#if (!(defined _INCLUDED_NAMEDFIELD_H))
#include "NamedField.h"
#endif

#if (!defined(_INCLUDED_NRNODE_H))
#include "NRnode.h"
#endif

#if (__GNUC_MINOR__ > 7)

#if (!defined(_INCLUDED_LIST))
#include <list>
#define _INCLUDED_LIST
#endif

#if (!defined(_INCLUDED_STRING))
#include <string>
#define _INCLUDED_STRING
#endif

#else

#if (!defined(_INCLUDED_LIST))
#include <list.h>
#define _INCLUDED_LIST
#endif

#if (!defined(_INCLUDED_STRING))
#include <string.h>
#define _INCLUDED_STRING
#endif

#endif

#if 0
template <class T>
struct eq:binary_function<T, T, bool>
{
  bool operator()(T& r1, T& r2)
  {return (r1 == r2);}
};
#endif

class Resolver;

class Nomencurator{
public:

  /*
   * Constructors
   */
  Nomencurator(void);
  Nomencurator(const Nomencurator&);
  Nomencurator& operator=(const Nomencurator&);
  ~Nomencurator(void);
  NameRecord* find_NameRecord(const string &);
  NameRecord* find_NR(const char*);

  bool clear(void);

  list<NRnode*> query(const char*);// const; //!!!
  
  list<NRnode*> name(const string &);
  list<NRnode*> generic(const string &);
  list<NRnode*> specific(const string &);
  list<d_Object*> ptr(const string &);
  list<NameRecord*> ptrNameRcord(const string &);
  list<Author*> ptrAuthor(const string &);
  list<Author*> author(const string &);
  list<Citation*> ptrCitation(const string &);
  list<Publication*> ptrPublication(const string &);
  list<Annotation*> ptrAnnotation(const string &);
  list<NRnode*> queryNRnodeByPtr(const string &);
  list<NRnode*> queryNRnodeByNR(const string &);
  list<NRnode*> queryNRnodeByNRPtr(const string &);

  friend istream& operator>> (istream &, Nomencurator&);
  friend ostream& operator<< (ostream &, const Nomencurator&);

  //which one is the easiest to use?
  friend Nomencurator& operator>> (Nomencurator&, Nomencurator&);
  friend Nomencurator& operator<< (Nomencurator&, Nomencurator&);
  friend Nomencurator& operator += (Nomencurator& n, Nomencurator& m);
  // Nomencurator operator + (Nomencurator&);
  bool merge(Nomencurator&);

  friend Nomencurator& operator += (Nomencurator& n, NameRecord*);
  friend Nomencurator& operator += (Nomencurator& n, Author*);
  friend Nomencurator& operator += (Nomencurator& n, Citation*);
  friend Nomencurator& operator += (Nomencurator& n, Publication*);
  friend Nomencurator& operator += (Nomencurator& n, Annotation*);
  friend Nomencurator& operator += (Nomencurator& n, NRnode*);

  int verbose(void);
  void verbose(int);

private:
  int _verbose;

#if 0
  list<NameRecord*> _nr;
  list<Author*>_auth;
  list<Citation*> _cite;
  list<Publication*> _pub;
  list<Annotation*> _anno;
  list<NRnode*> _nodes;
#else
  list<d_Ref<NameRecord> > _nr;
  list<d_Ref<Author> > _auth;
  list<d_Ref<Citation> > _cite;
  list<d_Ref<Publication> > _pub;
  list<d_Ref<Annotation> > _anno;
  list<d_Ref<NRnode> > _nodes;
#endif
  hash_map<string, NRnode*, Hash<string> > _hnr;

  hash_map<string, list<NRnode*>, Hash<string> > _name;
  hash_map<string, list<NRnode*>, Hash<string> > _generic;
  hash_map<string, list<NRnode*>, Hash<string> > _specific;
  hash_map<string, Author*, Hash<string> > _hauth;
  hash_map<string, list<Author*>, Hash<string> > _hauthorByName;
  hash_map<string, Publication*, Hash<string> > _hpub;
  hash_map<string, list<Publication*>, Hash<string> > _hashPubByAuthor;

  //pointr hash tables
  //pointers to anything
  hash_map<string, list<d_Object*>, Hash<string> > _ptr;
  //pointers to NameRecord
  hash_map<string, list<NameRecord*>, Hash<string> > _ptrNameRecord;
  //pointers to Author...same as hauth if hash functionis good
  hash_map<string, list<Author*>, Hash<string> > _ptrAuthor;
  //pointers to Citation
  hash_map<string, list<Citation*>, Hash<string> > _ptrCitation;
 //pointers to Publication...same as hpub if hash functionis good
  hash_map<string, list<Publication*>, Hash<string> > _ptrPublication;
  //pointers to Annotation
  hash_map<string, list<Annotation*>, Hash<string> > _ptrAnnotation;
  //pointers to NRnode
  hash_map<string, list<NRnode*>, Hash<string> > _ptrNRnode;
  //pointers to NRnode, but hashed by NameRecord's persistentID
  hash_map<string, list<NRnode*>, Hash<string> > _ptrNRnodeNR;

  bool _resolve(Resolver &);

  bool _resolve(
		hash_map<string, list<NameRecord*>, Hash<string> > nr,
		hash_map<string, list<Annotation*>, Hash<string> > an,
		hash_map<string, list<Citation*>, Hash<string> > ci,
		hash_map<string, list<Publication*>, Hash<string> > pub,
		hash_map<string, list<Author*>, Hash<string> > au,
		hash_map<string, list<NRnode*>, Hash<string> > nrn,
		hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > unr,
		hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > uan,
		hash_map<string, list<d_Ref<Citation>*>, Hash<string> > uci,
		hash_map<string, list<d_Ref<Publication>*>, Hash<string> > upub,
		hash_map<string, list<d_Ref<Author>*>, Hash<string> > uau,
		hash_map<string, list<d_Ref<NRnode>*>, Hash<string> > unrn
		);
};

#if (!defined(_INCLUDED_RESOLVER_H))
#include "Resolver.h"
#endif

inline int Nomencurator::verbose(void){ return _verbose;}
inline void Nomencurator::verbose(int v){ _verbose = v;}

inline Nomencurator& operator>> (Nomencurator& m, Nomencurator& n) { n.merge(m); return n;}
inline Nomencurator& operator<< (Nomencurator& n, Nomencurator& m) { n.merge(m); return n;}
inline Nomencurator& operator += (Nomencurator& n, Nomencurator& m) { n.merge(m); return n;}

#endif

