/*
 *
 * Period.cxx: a n implementation of Period class, a pair of Dates,
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Period.cxx,v 1.1 1999/12/05 18:24:40 nozomi Exp $
 *	$Log: Period.cxx,v $
 *	Revision 1.1  1999/12/05 18:24:40  nozomi
 *	improve merge code
 *	
 *
 */

#include "Period.h"

Period::Period(void):_from(), _to(){}

Period::Period(const Date& f, const Date& t):_from(f), _to(t){}

Period::Period(const char* f, const char* t):_from(f), _to(t){}

Period::Period(const Period& p):_from(p._from), _to(p._to){}

Period& Period::operator= (const Period& p)
{ _from = p._from; _to = p._to; return *this;}

Period::operator string(void) const
{
  string s(_from);
  s+= "--";
  s+= string(_to);
  return s;
}

ostream& operator<<(ostream & s, const Period &p)
{ s << string(p); return s; }

void Period::from(const Date& f) { _from = f; }
void Period::to(const Date& t) { _to = t; }

bool operator == (const Period& a, const Period& b)
{return  a._from == b._from && a._to == b._to;} 

bool operator < (const Period& a, const Period& b)
{ return !(a._from < b._from || a._to > b._to); } 

bool Period::exclusive(const Period& p) const
{return (_from > p._to || p._from > _to); }

Period Period::operator+(Period &p) const
{
  Period ret;
  if(valid() && p.valid() && !exclusive(p)){
    ret._from = _from < p._from? _from:p._from;
    ret._to   = _to   > p._to?   _to  :p._to;
  }
  return ret;
}

Period Period::operator+=(Period &p)
{
  return *this = *this + p;
}

Period Period::operator-(Period & p) const
{
  Period ret;
  if(!valid() || !p.valid() || exclusive(p) || *this == p || *this < p || *this > p)
    return ret;

  if(_from < p._from){
    ret._from = _from;
    ret._to   = p._from;
  }
  else{
    ret._from = p._to;
    ret._to   = _to;
  }
  return ret;
}

Period Period::operator-=(Period &p)
{
  Period tmp = *this - p;
  if(tmp.valid()) {
    _from = tmp._from;
    _to   = tmp._to;
  }
  return *this;
}

bool Period::valid(void) const
{
  return _from.valid() && _to.valid() && _from <= _to; 
}
