/*
 *
 * Period.h: a definition of Period class, a pair of Dates,
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Period.h,v 1.1 1999/12/05 18:21:18 nozomi Exp $
 *	$Log: Period.h,v $
 *	Revision 1.1  1999/12/05 18:21:18  nozomi
 *	improve redundant include guard
 *	
 *
 */

// Period class is abstraction of period defined as a pair of dates.

#if (!defined (__PERIOD_H))
#define __PERIOD_H
#include "Date.h"

class Period{

public:
  // constructors
  Period(void);
  Period(const Date&, const Date&);
  Period(const char*);
  Period(const char*, const char*);
  Period(const Period&);
  Period& operator= (const Period&);
  operator string() const;

  // I/O
  // friend istream& operator>>(istream & s, Period &d);
  friend ostream& operator<<(ostream & s, const Period &d);

  //accessors
  Date from(void) const;
  Date to(void) const;

  //manipulators
  void from(const Date&);
  void to(const Date&);

  //boolians
  friend bool operator == (const Period& a, const Period& b);
  friend bool operator != (const Period& a, const Period& b);
  friend bool operator > (const Period& a, const Period& b);
  friend bool operator < (const Period& a, const Period& b);

  bool overlap(const Period&) const;
  bool exclusive(const Period&) const;
  friend bool overlap(const Period& a, const Period& b);
  friend bool exclusive(const Period& a, const Period& b);

  bool valid(void) const;
  bool invalid(void) const;

  Period operator+(Period &) const;
  Period operator+=(Period &);
  Period operator-(Period &) const;
  Period operator-=(Period &);

private:
  Date _from, _to;
};

inline Date Period::from(void) const {return _from;}
inline Date Period::to(void) const {return _to;}
inline bool operator != (const Period& a, const Period& b) {return !(a == b);}
inline bool operator > (const Period& a, const Period& b) {return b < a;}
inline bool Period::overlap(const Period& p) const { return !exclusive(p);}
inline bool overlap(const Period& a, const Period& b) { return !a.exclusive(b);}
inline bool exclusive(const Period& a, const Period& b) { return a.exclusive(b);}
inline bool Period::invalid(void) const{ return !valid(); }
#endif
