/*
 *
 * Resolver.cxx: an implemtation of reference resolver
 * for Nomencurator, a demonstrator or Nomenclature Heuristic Model spec MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Resolver.cxx,v 1.1 1999/09/23 06:38:23 nozomi Exp $
 *	$Log: Resolver.cxx,v $
 *	Revision 1.1  1999/09/23 06:38:23  nozomi
 *	Resolver class implementation to handle reference resolving
 *	
 *
 */

#include "Resolver.h"

Resolver::Resolver(void)
  :/*nr(new hash_map<string, list<NameRecord*>, Hash<string> >),
   an(new hash_map<string, list<Annotation*>, Hash<string> >),
   ci(new hash_map<string, list<Citation*>, Hash<string> >),
   pub(new hash_map<string, list<Publication*>, Hash<string> >),
   au(new hash_map<string, list<Author*>, Hash<string> >),
   nrn(new hash_map<string, list<NRnode*>, Hash<string> >),*/
   nr(), an(), ci(), pub(), au(), nrn(),
   unr(), uan(), uci(), upub(), uau(), unrn(),
   newNameRecords(), newAnnotations(),
   newCitations(), newPublications(),
   newAuthors(), newNRnodes(),  _deallocate(true)
{
}

Resolver::~Resolver(void)
{
  /*  if(_deallocate){
    delete &nr;
    delete &an;
    delete &ci;
    delete &pub;
    delete &au;
    delete &nrn;
  }*/
}

Resolver::Resolver(hash_map<string, list<NameRecord*>, Hash<string> >& rnr,
		   hash_map<string, list<Annotation*>, Hash<string> >& ran,
		   hash_map<string, list<Citation*>, Hash<string> >&   rci,
		   hash_map<string, list<Publication*>, Hash<string> > & rpub,
		   hash_map<string, list<Author*>, Hash<string> > &rau,
		   hash_map<string, list<NRnode*>, Hash<string> > &rnrn)
  :nr(rnr), an(ran), ci(rci), pub(rpub), au(rau), nrn(rnrn),
   unr(), uan(), uci(), upub(), uau(), unrn(),
   newNameRecords(), newAnnotations(),
   newCitations(), newPublications(),
   newAuthors(), newNRnodes(), _deallocate(false)
{
}



