/*
 *
 * Resolver.h: a definition of reference resolver
 * for Nomencurator, a demonstrator or Nomenclature Heuristic Model spec MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: Resolver.h,v 1.2 1999/12/05 18:21:34 nozomi Exp $
 *	$Log: Resolver.h,v $
 *	Revision 1.2  1999/12/05 18:21:34  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.1  1999/09/23 06:38:57  nozomi
 *	definition of Resolver class helping reference resoltion
 *	
 *
 */

#if (!defined(_INCLUDED_RESOLVER_H))
#define _INCLUDED_RESOLVER_H

#include "d_Ref.h"
#if (__GNUC_MINOR__ > 7)
#include <list>
#include <string>
#else
#include <list.h>
#include <string.h>
#endif

class NameRecord;
class Annotation;
class Citation;
class Publication;
class Author;
class NRnode;

class Resolver{
public:
  Resolver(void);
  Resolver(hash_map<string, list<NameRecord*>, Hash<string> >& rnr,
	   hash_map<string, list<Annotation*>, Hash<string> >& ran,
	   hash_map<string, list<Citation*>, Hash<string> >&   rci,
	   hash_map<string, list<Publication*>, Hash<string> > & rpub,
	   hash_map<string, list<Author*>, Hash<string> > &rau,
	   hash_map<string, list<NRnode*>, Hash<string> > &rnrn);

  ~Resolver(void);

  hash_map<string, list<NameRecord*>, Hash<string> > nr;
  hash_map<string, list<Annotation*>, Hash<string> > an;
  hash_map<string, list<Citation*>, Hash<string> > ci;
  hash_map<string, list<Publication*>, Hash<string> > pub;
  hash_map<string, list<Author*>, Hash<string> > au;
  hash_map<string, list<NRnode*>, Hash<string> > nrn;

  hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > unr;
  hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > uan;
  hash_map<string, list<d_Ref<Citation>*>, Hash<string> > uci;
  hash_map<string, list<d_Ref<Publication>*>, Hash<string> > upub;
  hash_map<string, list<d_Ref<Author>*>, Hash<string> > uau;
  hash_map<string, list<d_Ref<NRnode>*>, Hash<string> > unrn;

  list<NameRecord*>  newNameRecords;
  list<Annotation*>  newAnnotations;
  list<Citation*>    newCitations;
  list<Publication*> newPublications;
  list<Author*>      newAuthors;
  list<NRnode*>      newNRnodes;
private:
  bool _deallocate;
};

#include "Author.h"
#include "Publication.h"
#include "Citation.h"
#include "NameRecord.h"
#include "Annotation.h"
#include "NamedField.h"
#include "NRnode.h"

#endif //_INCLUDED_RESOLVER_H

