/*
 *
 * d_Database.h: an definition of a ODMG 2.0 database class
 * for a Nomenclature Heuristic Model
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: d_Database.h,v 1.1 1999/03/15 16:42:51 nozomi Exp $
 *	$Log: d_Database.h,v $
 *	Revision 1.1  1999/03/15 16:42:51  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:20:23  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//note yet used
#if (!defined(__d_Database_h))
#define __d_Database_h 20
#if (!defined(__ODMG__))

#if (__GNUC_MINOR__ > 7)
#include <list>
#else
#include <list.h>
#endif

// This base class is necessary to make a class persistent-capable

class d_Ref_Any;

class d_Object;
class d_Database;

class d_ObjectEntry{

  friend class d_Database;
  friend class d_Object;

  public:
  //private:
  d_ObjectEntry(const char *s = "", const char *c = "", unsigned long idx = 0UL);
  d_ObjectEntry(d_Object *obj, unsigned long idx);
  d_ObjectEntry(const d_ObjectEntry &obje);
  d_ObjectEntry& operator= (const d_ObjectEntry &obje);

  ~d_ObjectEntry(void){};

private:
  char *_className;
  char **_idStrings;
  unsigned long _objectIndex;
  d_Object* _object;

  bool reallocate(const d_ObjectEntry &obje);
};

class d_Database {
  friend class d_Object;
public:
  static d_Database * const transient_memory;
  enum access_status { not_open, read_write, read_only, eclusive };
  d_Database();
  void open(const char *db_name,
	    access_status access = read_write);
  void close();
  void set_object_name(const d_Object *obj /*const d_Ref_Any &objref*/,
		       const char* name);
  void rename_object(const char *oldName,
		     const char *newName);
  //non-ODMG
  unsigned long register_name(const char *name, const char *className = "");
  unsigned long register_object(d_Object* obj);

  //  d_Ref_Any lookup_object(const char *name) const;
  d_Object* lookup_object(const char *name) ;//const;

  d_Object* resolve(unsigned long);
  d_Object* resolve(char*);
  d_Object* resolve(char*, char*);

private:
  d_Database(const d_Database &);
  d_Database& operator=(const d_Database &);
  d_ObjectEntry* lookup_entry(const char *name);// const;

  unsigned long registerdItems;
  list<d_ObjectEntry> objectList;
};



#include "d_Object.h"

inline d_Database::d_Database(void)
  :registerdItems(0UL), objectList(){}

/*
inline d_ObjectEntry::d_ObjectEntry(d_Object *obj, unsigned long idx)
 : _objectIndex(idx), _object(obj),
   _className(obj->_className),_idStrings(obj->_idStrings) {}
   */


#endif // (!defined(__ODMG__))
#endif // __d_Database_h 20
