/*
 *
 * d_Object.h:  definition of a persistent base class
 * for a Nomenclature Heuristic Model
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: d_Object.h,v 1.4 1999/12/05 18:37:00 nozomi Exp $
 *	$Log: d_Object.h,v $
 *	Revision 1.4  1999/12/05 18:37:00  nozomi
 *	add _nextOID which may not be used
 *	
 *	Revision 1.3  1999/09/23 06:30:19  nozomi
 *	merge method
 *	
 *	Revision 1.2  1999/09/20 14:17:29  nozomi
 *	add object ID
 *	
 *	Revision 1.1  1999/03/15 16:42:52  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:20:44  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// class d_Object was designed to have similer interface with d_Object class of 
// ODMG 2.0.  Some are missing, some are added because of basic design of OO`DBMS'.
// Object oriented model was chosen rather RDB model only because pointer tracking 
// navigation is more suitable to handle nomenclature data.  However, it does not
// require based on OODBMS.  It can be implemented also as frontend navigator on
// RDBMS with normalization under paradigm of object oriented methodology.  In lager 
// scale, however, OODBMS would be suit becasue pointer linked network is the 
// essencial stracture of NHM.
//
// d_Object class uses a named pointer system for persistency of reference between
// objects.  d_Object class itself is a pure virtual class and requires its derived
// classes to have string persistentID(void) method as a persistent pointr.  The
// string is usesd as object identifire.  Though it is unnecessary feature in sense of 
// ODMG OODBMS, it is useful in the NHM because it can be used as handy identifier
// based on object contents.  It may be better to change class name to say 
// n_Object (named Object) derived from d_Object when OODBMS is chosen as backend of the NHM. 
//
// d_Object has classname to distinguish devired class, but it may unnecesary.
//

#if (!defined(__d_Object_h))
#define __d_Object_h 20
#if (!defined(__ODMG__))

#include "d_common.h"
#if (__GNUC_MINOR__ > 7)
#include <string>
#else
#include <string.h>
#endif
#include <stdlib.h>

#include "d_Database.h"

class d_Ref_Any;
template <class T> class d_Ref;

class d_Object{
public:

#if (defined(__ODMG__))
  d_Object();
#else
  friend class d_Database;
  //  friend class d_ObjectEntry;
  friend class d_Ref_Any;
  class T;
  friend class d_Ref<T>;
  
  d_Object(const char *s = "", unsigned long l = 0UL);
#endif

  d_Object(const d_Object &obj);
  d_Object & operator= (const d_Object &obj);
  virtual ~d_Object(){};
  void mark_modified();

#if (defined(__ODMG__))
  void *operator new(size_t size);
  void *operator new(size_t size,
		     cosnt d_Ref_Any &clusterObj,
		     const char *typename);
  void *operator new(size_t size, d_Database *db,
		     const char *typename);
  void operator delete(void* );
  virtual void d_activate();
  virtual void d_deactivate();
#else
  virtual string persistentID(void) const = 0;
  virtual string classname(void) const;
  //  virtual void persistentID(const char*) = 0;
  virtual void classname(const char*);
  virtual d_Object & operator++(void);
  virtual d_Object & operator--(void);
  friend bool operator==(const d_Object& o1, const d_Object& o2);
  friend bool operator!=(const d_Object& o1, const d_Object& o2);
  unsigned long oid(void);
  virtual bool merge (d_Object*);

  friend ostream& operator<<(ostream &, const d_Object&);
  virtual ostream& printTo(ostream &) const;
#endif
protected:
  unsigned long _oid;
private:
  const char *_classname;
  unsigned long _refcnt;
  static unsigned long _nextOID;
};

inline unsigned long d_Object::oid(void)
{return _oid;}

inline d_Object & d_Object::operator++(void)
{++_refcnt; return *this;}

inline d_Object & d_Object::operator--(void)
{ --_refcnt; return *this;}

inline d_Object::d_Object(const d_Object &obj)
  :_oid(_nextOID),  _classname(obj._classname), _refcnt(1UL){ ++_nextOID;}

inline string d_Object::classname(void) const { return string(_classname);}

inline void d_Object::classname(const char* s) { _classname = s;}

inline d_Object::d_Object(const char* s, unsigned long l)
  :_oid(_nextOID), _classname(s), _refcnt(1UL)  { ++_nextOID;}

inline bool operator==(const d_Object& o1, const d_Object& o2){return o1.persistentID() == o2.persistentID();}
inline bool operator!=(const d_Object& o1, const d_Object& o2){return o1.persistentID() != o2.persistentID();}

inline ostream& operator<<(ostream & os, const d_Object& obj) {
  os << obj.persistentID() << "\n"; return os;
}

inline ostream& d_Object::printTo(ostream & os) const { return os << *this; }

#endif // (!defined(__ODMG__))
#endif // __d_Object_h 20


