/*
 *
 * d_Ref.cxx: an implementation of a persistent pointer 
 * for a Nomenclature Heuristic Model
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi 'James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: d_Ref.cxx,v 1.5 1999/12/05 18:24:56 nozomi Exp $
 *	$Log: d_Ref.cxx,v $
 *	Revision 1.5  1999/12/05 18:24:56  nozomi
 *	improve merge code
 *	
 *	Revision 1.4  1999/09/23 06:30:55  nozomi
 *	operator == and < improved
 *	
 *	Revision 1.3  1999/08/09 17:22:58  nozomi
 *	spell correction
 *	
 *	Revision 1.2  1999/03/15 04:07:29  nozomi
 *	fix bug in T* ptr(T*)
 *	
 *	Revision 1.1  1999/03/14 12:05:55  nozomi
 *	fix a bug in d_Ref::ptr(T*)
 *	
 *	Revision 1.0  1999/03/14 02:20:55  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "d_Ref.h"

#include "d_Ref_Any.h"

template <class T> d_Ref<T>::d_Ref(void) 
  : _object(new T*), _refcnt(new unsigned long*), _persistentID(new char**)
{
  *_object = NULL;
  *_refcnt = new unsigned long(1);
  *_persistentID = new char *;
  **_persistentID = strdup();
}

template <class T> d_Ref<T>::d_Ref(T *p) 
  : _object(new T*), _refcnt(new unsigned long*), _persistentID(new char**)
{
  *_object = p;
  *_refcnt = new unsigned long(1);
  /*if(*_object)++(**_object);*/
  *_persistentID = new char *;
  **_persistentID = strdup();
}

template <class T> d_Ref<T>::d_Ref(const d_Ref<T> &r)
  :_object(r._object), _refcnt(r._refcnt), _persistentID(r._persistentID)
{(**_refcnt)++; /*if(*_object) ++(**_object);*/}

#if 0
template <class T> d_Ref<T>::d_Ref(const d_Ref_Any &r)
  :_object(r._object), _refcnt(r._refcnt), _persistentID(r._persistentID)
{(**_refcnt)++;}
#endif

template <class T> d_Ref<T>::~d_Ref(void)
{ //if(_object && *_object) --(**_object);
  if(--(**_refcnt) == 0){
    delete *_refcnt;
    delete _refcnt;
    //XXX?
    //if(_object && *_object)
    //  --(**_object);
    delete _object;
    delete [] **_persistentID;
    delete *_persistentID;
    delete _persistentID;
  }
}

template <class T> T* d_Ref<T>::operator->(void) const {return *_object;}

template <class T> T& d_Ref<T>::operator*(void) const {return **_object;}

template <class T> T* d_Ref<T>::ptr(void) const {return *_object;}

template <class T> T* d_Ref<T>::ptr(T *p) 
{*_object = p; delete [] **_persistentID; **_persistentID = strdup(); return *_object;}


template <class T> T** d_Ref<T>::object(void) const {return _object;}

template <class T> T** d_Ref<T>::object(T **p) 
{_object = p; delete [] **_persistentID; **_persistentID = strdup(); return _object;}

template <class T> unsigned long d_Ref<T>::refcount(void) const {return **_refcnt;}

template <class T> void d_Ref<T>::refcount(unsigned long r) {**_refcnt = r;}

template <class T> void d_Ref<T>::refcountPtr(unsigned long *p) {*_refcnt = p;}

template <class T> void d_Ref<T>::refcountPtr(unsigned long **p) {_refcnt = p;}

template <class T> char* d_Ref<T>::pid(void) const {return **_persistentID;}
template <class T> void d_Ref<T>::pid(char* p) {**_persistentID = p;}

template <class T> char** d_Ref<T>::pidPtr(void) const {return *_persistentID;}
template <class T> void d_Ref<T>::pidPtr(char** p) {*_persistentID = p;}

template <class T> char*** d_Ref<T>::pidPtrPtr(void) const {return _persistentID;}
template <class T> void d_Ref<T>::pidPtrPtr(char*** p) {_persistentID = p;}


template <class T> void d_Ref<T>::delete_object(void)
{ if(NULL != *_object){delete *_object; *_object = NULL; **_refcnt= 0;}}

template <class T> d_Ref<T>::operator d_Ref_Any(void) const 
{ if(NULL != *_object) return d_Ref_Any(*_object); return d_Ref_Any(**_persistentID);}

template <class T> string d_Ref<T>::persistentID(void) const
{
  if(NULL != *_object){
    string s((*_object)->persistentID());
    if(s.length()) return s;
  }

  return string(**_persistentID);
}

template <class T> void d_Ref<T>::_reuseResource(void)
{
  if(--(**_refcnt) == 0){
    if(NULL != *_object)*_object = NULL;
    delete [] **_persistentID;
  }
  else{
    _refcnt = new unsigned long*;
    *_refcnt = new unsigned long;
    _object = new T*; *_object = NULL;
    _persistentID = new char**;
    *_persistentID = new char*;
  }
  **_persistentID = strdup();
  **_refcnt = 1UL;
}

template <class T> void d_Ref<T>::persistentID(const char* s)
{
  _reuseResource();
  if(NULL != s) **_persistentID = new_strdup::strdup(s);
  else **_persistentID = strdup();
}

template <class T> void d_Ref<T>::persistentID(const string& s)
{
  _reuseResource();
  **_persistentID = strdup(s);
}

template <class T> d_Ref<T> & d_Ref<T>::operator=(T *p)
{
  //if(*_object) --(**_object);
  _reuseResource();
  *_object = p;
  //if(*_object) ++(**_object);
  return *this;
}

//template <class T> d_Ref<T> & d_Ref<T>::operator=(d_Ref<T> &r)
template <class T> d_Ref<T> & d_Ref<T>::operator=(const d_Ref<T> &r)
{
  //  if(*_object) --(**_object);
  if(this == &r || _refcnt == r._refcnt || 
     _object == r._object || _persistentID == r._persistentID ) return *this;

#if 1
  if(0 == strcmp(persistentID(), r.persistentID()) && 
     0 != persistentID().length()){

    if(--(**_refcnt)){
      delete *_refcnt;
      delete _refcnt;
      delete _object;
      delete [] **_persistentID;
      delete *_persistentID;
      delete _persistentID;
    }

    _refcnt = r._refcnt;
    (**_refcnt)++;
    _object = r._object; 
    _persistentID = r._persistentID;
    return *this;
  }
#endif
  //  if(*_object) --(**_object);
  if(--(**_refcnt) == 0){
    delete *_refcnt;
    delete _refcnt;
    delete _object;
    delete [] **_persistentID;
    delete *_persistentID;
    delete _persistentID;
  }
#if 1
  _object = r._object;
  _persistentID = r._persistentID;
  _refcnt = r._refcnt;
  (**_refcnt)++;
#else
  _object = new T*;
  *_object = *r._object; 
  _refcnt = new unsigned long*;
  *_refcnt = new unsigned long(1UL);
  *_persistentID = new char*;
  **_persistentID = new_strdup::strdup(*r._persistentID);
#endif
  return *this;
}

template <class T> d_Boolean d_Ref<T>::operator!(void) const {return (NULL == *_object);}
template <class T> d_Boolean d_Ref<T>::is_null(void) const {return (NULL == *_object);}

template <class T> d_Boolean _unify (d_Ref<T> *r1, d_Ref<T> *r2)
{
  delete [] **(r2->_persistentID);
  delete *(r2->_persistentID);
  delete r2->_persistentID;
  r2->_persistentID = r1->_persistentID;
  delete r2->_object;
  r2->_object = r1->_object;
  **(r1->_refcnt) += **(r2->_refcnt);
  delete *r2->_refcnt;
  *r2->_refcnt = *r1->_refcnt;
  return true;
}

/*
  Cases in equality:
  1. same "this"
  2. same proxy pointing to non NULL object
  3. pointing to the same object (need merge)
  4. same strings (need merge)

  What cases can not be equal?
  -1. differ strings

  For efficiency, sequence 1 -> 2 -> 3 -> !(-1) -> 4
  would be the best way.
 */

#if 0 
template <class T> d_Boolean operator== (d_Ref<T> &r1, d_Ref<T> &r2)
{ 
  //obvios case 1: same d_Ref objects
  if(&r1 == &r2) 
    return true;

  //Don't warry cases _object are unallocated.  See constructors.
  //obvios case 2: shares the same proxy pointing non NULL
  if(r1._object == r2._object && NULL != *(r1._object))
    return true;

  //obvios case 3: points to the same objects (need to merge)
  if(*(r1._object) == *(r2._object) && NULL != *(r1._object)){
  unifyObjects:
    **(r1._refcnt) += **(r2._refcnt);
    if(0 == --(**r2._refcnt)){
      delete r2._object;
      delete *r2._refcnt;
    }
    r2._object = r1._object;
    *r2._refcnt = *r1._refcnt;
    return true;
  }

  //obvious case -1: different pIDs
  if(r1.persistentID() != r2.persistentID())
    return false;

  //nonobvious case 4: all remaining cases must be same (need merge) 
  if(NULL == *(r1._object) && NULL == *(r2._object)){
    //if(NULL == r1.ptr() && NULL == r2.ptr()){
    //both are empty, so merge names
    if(r1._object == r2._object)
      return true;
    //can we share pID?
    if(**r2.refcnt == 1){
      delete [] **(r2._persistentID);
      delete *(r2._persistentID);
    }
    r2._persistentID = r1._persistentID;

    goto unifyObjects;
  }

  if(NULL != *(r1._object) && NULL != *(r2._object)){
    //do we need non-trivial marege here?
#if 0
    //simply abandon for generality
    return false;
#else
    //or...
    return **(r1._object) == **(r2._object);
    //return *(r1._object)->merge(*(r2._object));
#endif
  }

  d_Ref<T>* entity;
  d_Ref<T>* dummy;
  if(NULL != *(r1._object)){
    entity = &r1;
    dummy = &r2;
  }
  else {
    entity = &r2;
    dummy = &r1;
  }

  **(entity->_refcnt) += **(dummy->_refcnt);
  
  if(0 == --(**(dummy->_refcnt))){
    delete [] **(dummy->_persistentID);
    //    delete **(dummy->_persistentID);
    delete *dummy->_refcnt;
    delete dummy->_object;
  }
  **(dummy->_persistentID) = strdup();
  dummy->_refcnt = entity->_refcnt;
  dummy->_object = entity->_object;
  return true;
}
#endif
template <class T> d_Boolean d_Ref<T>::operator== (d_Ref<T> &r2)
{ 
  //obvious case 1: same d_Ref objects
  if(this == &r2) 
    return true;
  
  //Don't warry cases _object are unallocated.  See constructors.
  //obvious case 2: shares the same proxy pointing non NULL
  if(_object == r2._object && NULL != *(_object))
    return true;
  
  //obvious case 3: points to the same objects (need to merge)
  if(*(_object) == *(r2._object) && NULL != *(_object)){
  unifyObjects:
#if 0
    delete r2._object;
    r2._object = _object;
    *(_refcnt) += *(r2._refcnt);
    delete r2._refcnt;
    r2._refcnt = _refcnt;
#else
    merge(r2);
#endif
    return true;
  }
  
  //obvious case -1: different pIDs
  if(persistentID() != r2.persistentID())
    return false;
  
  //nonobvious case 4: all remaining cases must be same (need merge) 
  if(NULL == *(_object) && NULL == *(r2._object)){
    //if(NULL == r1.ptr() && NULL == r2.ptr()){
    //both are empty, so merge names
    if(_object == r2._object)
      return true;
    //can we share pID?
#if 0
    delete [] **(r2._persistentID);
    
    delete *(r2._persistentID);
    
    r2._persistentID = _persistentID;
#else
    merge(r2);
#endif    
    goto unifyObjects;
  }
  
  if(NULL != *(_object) && NULL != *(r2._object)){
    //do we need non-trivial marege here?
#if 0
    //simply abandon for generality
    return false;
#else
    //or...
    return **(_object) == **(r2._object);
    //return *(r1._object)->merge(*(r2._object));
#endif
  }

  d_Ref<T>* entity;
  d_Ref<T>* dummy;
  if(NULL != *(_object)){
    entity = this;
    dummy = &r2;
  }
  else {
    entity = &r2;
    dummy = this;
  }
#if 1
  //  *entity = *dummy;
  entity->merge(*dummy);
#else
  delete [] **(dummy->_persistentID);
  **(dummy->_persistentID) = strdup();
  **(entity->_refcnt) += **(dummy->_refcnt);
  delete *dummy->_refcnt;
  *dummy->_refcnt = *entity->_refcnt;
  delete dummy->_object;
  dummy->_object = entity->_object;
#endif
  return true;
}

template <class T> d_Boolean d_Ref<T>::operator== (const T *p)
{ 
  bool named = (0 != *(r._persistentID));

  if(*(r._object) == NULL){
    if(!named) return false;
    if(p == NULL) return false;
    if(strcmp(**(r._persistentID), p->persistentID())) return false; 
    r._object = p; 
    delete [] **_persistentID;
    delete *_persistentID;
    _persistentID = NULL;
    return true;
  }
  if(r._object == p) return true;
  return false;
}
#if 0
template <class T> d_Boolean operator== (d_Ref<T> &r, const T *p)
{ 
  bool named = (0 != *(r._persistentID));

  if(*(r._object) == NULL){
    if(!named) return false;
    if(p == NULL) return false;
    if(strcmp(**(r._persistentID), p->persistentID())) return false; 
    r._object = p; 
    delete [] **_persistentID;
    delete *_persistentID;
    _persistentID = NULL;
    return true;
  }
  if(r._object == p) return true;
  return false;
}
#endif
#if 0
template <class T> d_Boolean operator== (d_Ref<T> &r1, d_Ref_Any &r2)
{ return (r2 ==  d_Ref_Any(r1));}

template <class T> d_Boolean operator== (const T *p, d_Ref<T> &r) {return r == p;}

template <class T> d_Boolean operator!= (d_Ref<T> &r1, d_Ref<T> &r2) { return !(r1==r2); }

template <class T> d_Boolean operator!= (const d_Ref<T> &r1, const T *p){return !(r==p);}

template <class T> d_Boolean operator!= (const T *p, const d_Ref<T> &r2){return !(r==p);}

template <class T> d_Boolean operator!= (const d_Ref<T> &r1, const d_Ref_Any &r2){return !(r1==r2);}
#else
template <class T> d_Boolean d_Ref<T>::operator== (const d_Ref_Any &r2)
{ return (r2 ==  d_Ref_Any(this));}

template <class T> d_Boolean operator== (const T *p, d_Ref<T> &r) {return r == p;}

template <class T> d_Boolean d_Ref<T>::operator!= (d_Ref<T> &r2) { return !(this == r2); }

template <class T> d_Boolean d_Ref<T>::operator!= (const T *p){return !( this ==p);}

template <class T> d_Boolean operator!= (const T *p, const d_Ref<T> &r2){return !(r2 ==p);}

template <class T> d_Boolean d_Ref<T>::operator!= (const d_Ref_Any &r2){return !(this == r2);}
#endif

#if 0
//non-ODMG
template <class T> d_Boolean operator< (d_Ref<T> &r1, d_Ref<T> &r2)
{
  //if equal, they can not be ordered
  if(&r1 == &r2) return false;

  // Stronger equality means weaker ordering.
  // So, evaluation in reversed sequence of == operator
  // can give a "reasonable" ordering.
  // However, pointer-first name-second comparison gives
  // better performance of OODBMS....
  T* t1 = r1.ptr();
  T* t2 = r2.ptr();
  if(NULL != t1 && NULL != t2)
    return *t1 < *t2;

  // If both are "dummy" pointer, compare name
  if(NULL == t1 && NULL == t2)
    return r1.persistentID() < r2.persistentID();

  // Otherwise, real pointer is stronger than dummy one
  return NULL != t1? true: false;
}
#else
//non-ODMG
//template <class T> d_Boolean d_Ref<T>::operator< (d_Ref<T> &r2)
template <class T> d_Boolean d_Ref<T>::operator< (const d_Ref<T> &r2) const
{
  //if equal, they can not be ordered
  if(this == &r2) return false;

  // Stronger equality means weaker ordering.
  // So, evaluation in reversed sequence of == operator
  // can give a "reasonable" ordering.
  // However, pointer-first name-second comparison gives
  // better performance of OODBMS....
  T* t1 = ptr();
  T* t2 = r2.ptr();
  if(NULL != t1 && NULL != t2)
    return *t1 < *t2;

  // If both are "dummy" pointer, compare name
  if(NULL == t1 && NULL == t2)
    return persistentID() < r2.persistentID();

  // Otherwise, real pointer is stronger than dummy one
  return NULL != t1? true: false;
}
#endif
#if 0
template <class T> inline d_Boolean operator>= (d_Ref<T> &r1, d_Ref<T> &r2)
{return !(r1 < r2);}
#else
//template <class T> inline d_Boolean d_Ref<T>::operator>= (d_Ref<T> &r2)
template <class T> inline d_Boolean d_Ref<T>::operator>= (const d_Ref<T> &r2) const
{return !(this < r2);}
#endif

#if 0
template <class T> d_Boolean operator> (d_Ref<T> &r1, d_Ref<T> &r2)
{
  if(&r1 == &r2) return false;
#if 1
  if(d1.ptr() != d2.ptr())
    return d1.ptr() > d2.ptr();
  return d1.persistentID() > d2.persistentID();
#else
  if(r1.persistentID() != r2.persistentID())
    return (r1.persistentID() > r2.persistentID());
  if(NULL == *(r1._object) && NULL == *(r2._object))
    return (r1._object > r2._object);
  if(NULL != *(r1._object) && NULL != *(r2._object))
    return (*(r1._object) > *(r2._object));
  if(NULL == *(r2._object))
    return false;
  if(NULL == *(r1._object))
    return true;
#endif
}
#else
//template <class T> d_Boolean d_Ref<T>::operator> (d_Ref<T> &r2)
template <class T> d_Boolean d_Ref<T>::operator> (const d_Ref<T> &r2) const
{
  if(this == &r2) return false;
#if 1
  if(ptr() != r2.ptr())
    return ptr() > r2.ptr();
  return r1.persistentID() > r2.persistentID();
#else
  if(r1.persistentID() != r2.persistentID())
    return (r1.persistentID() > r2.persistentID());
  if(NULL == *(r1._object) && NULL == *(r2._object))
    return (r1._object > r2._object);
  if(NULL != *(r1._object) && NULL != *(r2._object))
    return (*(r1._object) > *(r2._object));
  if(NULL == *(r2._object))
    return false;
  if(NULL == *(r1._object))
    return true;
#endif
}
#endif

#if 0
template <class T> inline d_Boolean operator<= (d_Ref<T> &r1, d_Ref<T> &r2)
{return !(r1 > r2);}

template <class T> inline d_Boolean d_Ref_eq (const d_Ref<T> *r1, const d_Ref<T> *r2)
{return *r1 == *r2;}

template <class T> inline d_Boolean d_Ref_lt (const d_Ref<T> *r1, const d_Ref<T> *r2)
{return *r1 < *r2;}

template <class T> inline d_Boolean d_Ref_gt (const d_Ref<T> *r1, const d_Ref<T> *r2)
{return *r1 > *r2;}
#else
//template <class T> inline d_Boolean d_Ref<T>::operator<= (d_Ref<T> &r2)
template <class T> inline d_Boolean d_Ref<T>::operator<= (const d_Ref<T> &r2) const
{return !(this > r2);}
#if 0
template <class T> inline d_Boolean d_Ref_eq (const d_Ref<T> *r1, const d_Ref<T> *r2)
{return *r1 == *r2;}

template <class T> inline d_Boolean d_Ref_lt (const d_Ref<T> *r1, const d_Ref<T> *r2)
{return *r1 < *r2;}

template <class T> inline d_Boolean d_Ref_gt (const d_Ref<T> *r1, const d_Ref<T> *r2)
{return *r1 > *r2;}
#endif
#endif

/*
  What cases are equal?
  1. same "this"
  2. same proxy pointing non NULL
  3. pointing same object (need merge)
  4. same strings (need merge)

  What cases can not be  equal?
  -1. differ strings
 */
  
template <class T> bool unify(d_Ref<T>& r1, d_Ref<T>& r2)
{
  //obvios case 1: same d_Ref objects
  if(&r1 == &r2) 
    return true;

  //obvios case 2 and 3:
  if(*(r1._object) == *(r2._object) && NULL != *(r1._object)){

    //obvios case 2: shares the same proxy pointing non NULL
    if(r1._object == r2._object && NULL != r1._object)
      return true;

    //obvios case 3: points to the same objects(need merge)
    delete r2._object;
    r2._object = r1._object;
    **(r1._refcnt) += **(r2._refcnt);
    delete *r2._refcnt;
    *r2._refcnt = *r1._refcnt;
    return true;
  }

  //obvious case -1: different pIDs
  if(r1.persistentID() != r2.persistentID())
    return false;

  //nonobvious case 4: all remaining cases must be same (need merge) 
  if(NULL !=r1.ptr() && NULL !=r2.ptr()){
    if(r1.ptr() == r2.ptr()){
      
      return true;
    }
  }
  if(r1.ptr() != r2.ptr() && NULL !=r1.ptr() && NULL !=r2.ptr())
    return r1->persistentID() == r2->persistentID();
  if(r1.persistentID() != r2.persistentID()){
    if(NULL == r1.ptr() && NULL == r2.ptr())
      return false;
#if 0
    //weak comparison, not yet.
    if(NULL == r2.ptr()){
      return *(r1.ptr()) == r2.persistentID();
    }
    if(NULL == r1.ptr())
      if(*(r2.ptr()) != r1.persistentID())
#endif
	return false;
  }
  if(NULL == r1.ptr() && NULL == r2.ptr())
    return true;
  if(r1.ptr() == r2.ptr())
    return true;
  if(NULL != r1.ptr() && NULL != r2.ptr())
    {
      //      return *(r1.ptr()) == *(r2.ptr());
      return false;
    }
  if(NULL == r2.ptr())
    return true;
  if(NULL == r1.ptr())
    {
      d_Ref<T> tmp(r1);
      r1 = r2;
      r2 = r1;
      return  true;
    }
  return false;
}

template <class T> T* d_Ref<T>::find(list<d_Ref<T> > &l) const
{
  list<d_Ref<T> >::iterator iter;
  string s(persistentID());
  for(iter = l.begin(); iter != l.end(); ++iter)
    if(s == iter->persistentID()) return iter->ptr();
  return NULL;
}

template <class T> T* d_Ref<T>::find(list<T> &l) const
{
  list<T>::iterator iter;
  string s(persistentID());
  for(iter = l.begin(); iter != l.end(); ++iter)
    if(s == iter->persistentID()) return &*iter;
  return NULL;
}

template <class T> bool d_Ref<T>::resolve(list<d_Ref<T> > *l) const
{
  if(NULL == *_object) return false;
  l->push_back(*this); return true;
}

template <class T> bool d_Ref<T>::resolve(list<T> *l) const
{
  if(NULL == *_object) return false;
  l->push_back(*_object); return true;
}

template <class T> bool d_Ref<T>::resolve(const list<d_Ref<T> > &l)
{
  if(NULL != *_object) return true; //do we need to search?
  if(**_persistentID == 0) return false;
  list<d_Ref<T> >::const_iterator i;
  string s(*_persistentID);
  for(i = l.begin(); i != l.end(); ++i){
    if(s == i->persistentID() && NULL != *(i->_object)){
      delete _object;
      _object = i->_object;
      delete [] **_persistentID;
      delete *_persistentID;
      delete _persistentID;
      _persistentID = i->_persistentID;
      **(i->_refcnt) += **_refcnt;
      delete *_refcnt;
      *_refcnt = *(i->_refcnt);
      return true;
    }
  }
  return false;
}

template <class T> bool d_Ref<T>::resolve(const list<T> &l) 
{
  if(NULL != *_object) return true; //do we need to search?
  if(**_persistentID == 0) return false;
  list<T>::const_iterator i;
  for(i = l.begin(); i != l.end(); ++i){
    if(NULL != &*i && s == i->persistentID()){
      *_object = &*i;
      delete [] **_persistentID;
      **_persistentID = strdup();
      return true;
    }
  }
  return false;
}

template <class T> T* d_Ref<T>::resolve(hash_map<string, list<T*>, Hash<string> > &entity,
					  hash_map<string, list<d_Ref<T>* >, Hash<string> > &unsolved)
{
  string s(persistentID());
  hash_map<string, list<T*>, Hash<string> >::iterator hiter = entity.find(s);
  if(NULL != *_object){
    if(hiter != entity.end()){
      list<T*>::iterator iter = hiter->second.begin();
      list<T*>::iterator end = hiter->second.end();
      while(iter != end){
	if(this->ptr() == *iter)
	  return NULL;
	else
	  return *iter;
	++iter;
      }
    }

    entity[s].push_back(*_object);

    hash_map<string, list<d_Ref<T>*>, Hash<string> >::iterator diter = unsolved.find(s);
    if(diter != unsolved.end()){
      list<d_Ref<T>* >::iterator iter = diter->second.begin();
      list<d_Ref<T>* >::iterator end = diter->second.end();
      while(iter != end){
	if(s == (*iter)->persistentID() && NULL == (*iter)->ptr())
#if 1
	  {
	    if(--(**((*iter)->_refcnt)) == 0){
	      delete *((*iter)->_refcnt);
	      delete (*iter)->_object;
	      delete [] **((*iter)->_persistentID);
	      delete *((*iter)->_persistentID);
	      //      delete (*iter)->_persistentID;
	    }
	    (*iter)->_object = _object;
	    (*iter)->_persistentID = _persistentID;
	    *((*iter)->_refcnt) = *_refcnt;
	    (**_refcnt)++;
	  }
#else
	  {
	    (*_refcnt) += *((*iter)->_refcnt);
	    delete (*iter)->_refcnt;
	    (*iter)->_refcnt = _refcnt;

	    delete (*iter)->_object;
	    (*iter)->_object = _object;

	    delete [] **((*iter)->_persistentID);
	    delete *((*iter)->_persistentID);
	    (*iter)->_persistentID = _persistentID;
	  }

#endif
	++iter;
      }
    }
    return NULL /* *_object*/;
  }

  //I don't points object
  if(hiter != entity.end()) {
    list<T*>::iterator iter = hiter->second.begin();
    list<T*>::iterator end = hiter->second.end();
    while(iter != end){
      if(s == (*iter)->persistentID())
	{
	  _reuseResource();
	  *_object = (*iter);
	  return *iter;  //resolved
	}
      ++iter;
    }
  }
  
  hash_map<string, list<d_Ref<T>*>, Hash<string> >::iterator diter = unsolved.find(s);
  if(diter != unsolved.end()){
    list<d_Ref<T>* >::iterator iter = diter->second.begin();
    list<d_Ref<T>* >::iterator end = diter->second.end();
    //    T* entity = *_object;
    while(iter != end){
      if(*iter != this && s == (*iter)->persistentID()) {
	if(0 == --(**_refcnt)){
	  delete *_refcnt;
	  delete _object;
	  delete [] **_persistentID;
	  delete *_persistentID;
	  delete _persistentID;
	}
	_object = (*iter)->_object;
	_persistentID = (*iter)->_persistentID;
	*_refcnt = *((*iter)->_refcnt);
	(**_refcnt)++;
	return *_object;
      }
      ++iter;
    }
  }
  else //?
    unsolved[s].push_back(this);
  return NULL;
}

#include <functional>

template <class T>
struct d_Ref_unify:binary_function<T, T, bool>
{
  bool operator()(d_Ref<T>& r1, d_Ref<T>& r2)
  {return &r1 == &r2;}
    //  {return _unify(&r1, &r2);}
    //  {return unify(r1, r2);}
};

#if 0
template <class T>
bool d_Ref<T>::lt::operator()(d_Ref<T>& d1, d_Ref<T>& d2)
{
  if(d1.ptr() != d2.ptr())
    return d1.ptr() > d2.ptr();
  return d1.persistentID() < d2.persistentID();
}

template <class T>
bool d_Ref<T>::gt::operator()(d_Ref<T>& d1, d_Ref<T>& d2)
{
  return d_Ref<T>::lt(d2, d1);
}

#endif

template <class T>
void d_Ref<T>::merge(d_Ref<T>& r)
{
  T *obj = *(r._object);
  if(0 == --(**(r._refcnt))){
    delete [] **(r._persistentID);
    delete *(r._persistentID);
    delete r._persistentID;
    delete *r._refcnt;
    //    *(r._object)--;
    delete r._object;
  }
  r._object = _object;
  if(*_object == NULL && obj != NULL)
    *_object = obj;
  r._persistentID = _persistentID;
  *(r._refcnt) = *(_refcnt);
  (**_refcnt)++;
  //    *(_object)++;
}
