/*
 *
 * d_Ref.h: a definition of a persistent pointer 
 * for a Nomenclature Heuristic Model
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: d_Ref.h,v 1.3 1999/12/05 18:21:40 nozomi Exp $
 *	$Log: d_Ref.h,v $
 *	Revision 1.3  1999/12/05 18:21:40  nozomi
 *	improve redundant include guard
 *	
 *	Revision 1.2  1999/09/23 06:32:14  nozomi
 *	sharable persistentID
 *	
 *	Revision 1.1  1999/03/15 16:42:53  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.0.0  1999/03/14 02:35:30  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//
// It is based on d_Ref.h of ODMG 2.0, but partly modified to accomodate with
// d_Object with string persistency.
//

// avoid include twice or more
#if (!defined(__d_Ref_h))
#define __d_Ref_h 20

// avoid conflict with ODMG
#if (!defined(__ODMG__))

#include "d_common.h"
#include "nodmg.h"
#include "d_Object.h"
#include "d_Ref_Any.h"
#if (__GNUC_MINOR__ > 7)
#include <list>
#else
#include <list.h>
#endif

template <class T> struct d_Ref_unify;

template <class T> class d_Ref {
  //  friend class T;
  friend T;
  //  template <class T> friend struct d_Ref_unify;
  //  template <T> friend struct d_Ref_unify;
  friend struct d_Ref_unify<T>;
public:
  //OMDG interfaces
  d_Ref(void);
  d_Ref(T *p);
  d_Ref(const d_Ref<T> &r2);
  //  d_Ref(const d_Ref_Any &r2);
  ~d_Ref();
  operator d_Ref_Any() const;
  d_Ref<T> & operator =(T *p);
  //  d_Ref<T> & operator =(d_Ref<T> &r2);
  d_Ref<T> & operator =(const d_Ref<T> &r2);
  void clear(void);  //not yet?
  T* operator->(void) const;
  T& operator*(void) const;
  T* ptr(void) const;
  T* ptr(T *p);
  void delete_object(void);

  T** object(void) const;
  T** object(T **p);

  unsigned long refcount(void) const;
  void refcount(unsigned long);

  unsigned long * refcountPtr(void) const;
  void refcountPtr(unsigned long *);
  void refcountPtr(unsigned long **);

  char* pid(void) const;
  void  pid(char*);

  char** pidPtr(void) const;
  void   pidPtr(char**);

  char*** pidPtrPtr(void) const;
  void   pidPtrPtr(char***);

  // Boolean predicates to check reference
  d_Boolean operator!(void) const;
  d_Boolean is_null(void) const;

  // do these d_Refs and pointers refer to the same objects?
#if 0
  friend d_Boolean operator== <T> (d_Ref<T> &r1, d_Ref<T> &r2);
  friend d_Boolean operator==  (const d_Ref<T> &r1, const T *p);
  friend d_Boolean operator==  (const T *p, const d_Ref<T> &r2);
  friend d_Boolean operator== (const d_Ref<T> &r1, const d_Ref_Any &r2);
  friend d_Boolean operator!= <T> (d_Ref<T> &r1, d_Ref<T> &r2);
  friend d_Boolean operator!= (const d_Ref<T> &r1, const T *p);
  friend d_Boolean operator!= (const T *p, const d_Ref<T> &r2);
  friend d_Boolean operator!= (const d_Ref<T> &r1, const d_Ref_Any &r2);
#else
  d_Boolean operator== (d_Ref<T> &r2);
  d_Boolean operator==  (const T *p);
  friend d_Boolean operator==   (const T *p, const d_Ref<T> &r2);
  d_Boolean operator== (const d_Ref_Any &r2);
  d_Boolean operator!= (d_Ref<T> &r2);
  d_Boolean operator!= (const T *p);
  friend d_Boolean operator!= (const T *p, const d_Ref<T> &r2);
  d_Boolean operator!= (const d_Ref_Any &r2);
#endif

  //Non OMDG
#if 0
  friend d_Boolean operator<  <T> (d_Ref<T> &r1, d_Ref<T> &r2);
  friend d_Boolean operator<= <T> (d_Ref<T> &r1, d_Ref<T> &r2);
  friend d_Boolean operator>  <T> (d_Ref<T> &r1, d_Ref<T> &r2);
  friend d_Boolean operator>= <T> (d_Ref<T> &r1, d_Ref<T> &r2);
  friend d_Boolean d_Ref_eq (const d_Ref<T> *r1, const d_Ref<T> *r2);
  friend d_Boolean d_Ref_lt (const d_Ref<T> *r1, const d_Ref<T> *r2);
  friend d_Boolean d_Ref_gt (const d_Ref<T> *r1, const d_Ref<T> *r2);
#else
  //  d_Boolean operator<  (d_Ref<T> &r2);
  d_Boolean operator<  (const d_Ref<T> &r2) const;
  //  d_Boolean operator<= (d_Ref<T> &r2);
  d_Boolean operator<= (const d_Ref<T> &r2) const;
  //d_Boolean operator>  (d_Ref<T> &r2);
  d_Boolean operator>  (const d_Ref<T> &r2) const;
  //d_Boolean operator>= (d_Ref<T> &r2);
  d_Boolean operator>= (const d_Ref<T> &r2) const;
#if 0
  friend d_Boolean d_Ref_eq (const d_Ref<T> *r1, const d_Ref<T> *r2);
  friend d_Boolean d_Ref_lt (const d_Ref<T> *r1, const d_Ref<T> *r2);
  friend d_Boolean d_Ref_gt (const d_Ref<T> *r1, const d_Ref<T> *r2);
#endif
#endif

  string persistentID(void) const; //done
  void persistentID(const char *);  //done
  void persistentID(const string&);  //done
  // d_Boolean unify(d_Ref<T> &r);
  //friend class list<d_Ref<T> >;
  //  template <class T> friend bool unify(d_Ref<T>& r1, d_Ref<T>& nr2);
  friend bool unify(d_Ref<T>& r1, d_Ref<T>& nr2);
  T* find(list<d_Ref<T> > &) const;
  T* find(list<T> &) const;
  bool resolve(list<d_Ref<T> > *) const;
  bool resolve(const list<d_Ref<T> > &);
  bool resolve(list<T> *) const;
  bool resolve(const list<T> &);

  T* resolve(hash_map<string, list<T*>, Hash<string> > &entity,
	       hash_map<string, list<d_Ref<T>* >, Hash<string> > &unsolved);

  //comparator
  struct lt:public binary_function<d_Ref<T>, d_Ref<T>, bool>{
    bool operator()(d_Ref<T>& d1, d_Ref<T>& d2);
  };

  struct gt:public binary_function<d_Ref<T>, d_Ref<T>, bool>{
    bool operator()(d_Ref<T>& d1, d_Ref<T>& d2);
  };

  void merge(d_Ref<T> &r1);

private:
  T **_object;
  unsigned long **_refcnt;
  char ***_persistentID;

  void _reuseResource(void);
  // template <class T> friend d_Boolean _unify(d_Ref<T> *r1, d_Ref<T> *r2);
  friend d_Boolean _unify(d_Ref<T> *r1, d_Ref<T> *r2);
};

#include "d_Ref.cxx"
#endif // (!defined(__ODMG__))
#endif // __d_Ref_h

