/*
 *
 * d_Ref_Any.h: an implementation of a persistent pointer 
 * for a Nomenclature Heuristic Model
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: d_Ref_Any.cxx,v 1.2 1999/12/05 18:38:03 nozomi Exp $
 *	$Log: d_Ref_Any.cxx,v $
 *	Revision 1.2  1999/12/05 18:38:03  nozomi
 *	modified for improved data merge
 *	
 *	Revision 1.1  1999/08/09 17:23:15  nozomi
 *	sepll correction
 *	
 *	Revision 1.0.0  1999/03/14 02:22:00  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "d_Ref_Any.h"

char * d_Ref_Any::_empty = "";

d_Ref_Any::~d_Ref_Any(void)
{
  if(0 == --(*_refcnt)){
    if(**_persistentID != _empty){
      delete [] **_persistentID; 
      delete *_persistentID; 
    }
  delete _persistentID; delete _object; delete _refcnt;
  }
}

void d_Ref_Any::_reuseResource(void)
{
  if(--(*_refcnt) == 0){
    if(NULL != *_object)*_object = NULL;
    if (**_persistentID != _empty){ delete [] **_persistentID;}
  }
  else{
    _refcnt = new unsigned long;
    _object = new d_Object*;
    *_object = NULL;
    _persistentID = new char**;
    *_persistentID = new char*;
  }
  *_refcnt = 1UL;
}

d_Ref_Any & d_Ref_Any::operator =(const char *s)
{
  _reuseResource();
  if(NULL != s) **_persistentID = new_strdup::strdup(s);
  return *this;
}

d_Ref_Any & d_Ref_Any::operator =(d_Object *p)
{
  _reuseResource();
  *_object = p;
  return *this;
}

d_Ref_Any & d_Ref_Any::operator =(const d_Ref_Any &r)
{
  if(this == &r || _refcnt == r._refcnt || 
     _object == r._object || _persistentID == r._persistentID ) return *this;

  if(!strcmp(persistentID(), r.persistentID())){
    *r._refcnt += *_refcnt;
    delete _refcnt; _refcnt = r._refcnt;
    delete _object; _object = r._object; 
    if(**_persistentID != _empty){
      delete [] **_persistentID;
      delete *_persistentID;
    }
    _persistentID = r._persistentID;
    return *this;
  }

  if(--(*_refcnt) == 0){
    delete _refcnt; delete _object;
    if(**_persistentID != _empty)
      delete [] **_persistentID;
    delete *_persistentID;
    delete _persistentID;
  }
  _object = r._object; _refcnt = r._refcnt;
  _persistentID = r._persistentID;
  (*_refcnt)++;
  return *this;
}
/*
d_Boolean _unify (d_Ref<T> *r1, d_Ref<T> *r2)
{
  if(*(r2->_persistentID) != d_Ref<T>::_empty)
    delete [] *(r2->_persistentID);
  delete r2->_persistentID;
  r2->_persistentID = r1->_persistentID;
  delete r2->_object;
  r2->_object = r1->_object;
  *(r1->_refcnt) += *(r2->_refcnt);
  delete r2->_refcnt;
  r2->_refcnt = r1->_refcnt;
  return true;
}
*/
d_Boolean operator== (const d_Ref_Any &r1, const d_Ref_Any &r2)
{
  // same as pointer
  if(&r1 == &r2 || r1._refcnt == r2._refcnt ||
     r1._object == r2._object || r1._persistentID == r2._persistentID ) return true;

  //possible the same object
  if(*(r1._object) == *(r2._object)){
    if(NULL != *(r1._object)){ //points same object
      return true; 
    }
    if(!strcmp(**(r1._persistentID), **(r2._persistentID))) return true;  //has same name
  }

  //if names differ
  if(strcmp(r1.persistentID(), r2.persistentID())) return false;

  // have the same name
#if 1
  return true;
#else
  if(NULL == *(r1._object)){
    return _unify(&r2, &r1);
  }
  else { /* NULL == r2._object */
    return _unify(&r1, &r2);
  }
#endif
}

d_Boolean synonym (const d_Ref_Any &r1, const d_Ref_Any &r2)
{
  return (strcmp(r1.persistentID(), r2.persistentID())
     && *(r1._object) == *(r2._object)) ;
}

d_Boolean homonym (const d_Ref_Any &r1, const d_Ref_Any &r2)
{
  return (!strcmp(r1.persistentID(), r2.persistentID())
     && *(r1._object) != *(r2._object)) ;
}



