/*
 *
 * d_Ref_Any.h: a definition of a persistent pointer 
 * for a Nomenclature Heuristic Model
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: d_Ref_Any.h,v 1.2 1999/12/05 18:39:45 nozomi Exp $
 *	$Log: d_Ref_Any.h,v $
 *	Revision 1.2  1999/12/05 18:39:45  nozomi
 *	modified for improved data merge
 *	
 *	Revision 1.0.0  1999/03/14 02:21:36  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

//not yet used

#if (!defined(__d_Ref_Any_h))
#define __d_Ref_Any_h 20
#if (!defined (__ODMG__))
#include "d_common.h"
#include "nodmg.h"
//#include "strdup.h"
#include "d_Object.h"
#if (__GNUC_MINOR__ > 7)
#include <list>
#else
#include <list.h>
#endif

#if 0
#include "d_Ref.h"
//typedef d_Ref<d_Object> d_Ref_Any;
#else
class d_Ref_Any {
public:
  d_Ref_Any();
  d_Ref_Any(const char *);  //non-odmg
  d_Ref_Any(const d_Ref_Any &r2);
  d_Ref_Any(/*const*/ d_Object *p);

  ~d_Ref_Any();

  d_Ref_Any & operator =(const char *);  //non-odmg
  d_Ref_Any & operator =(const d_Ref_Any &r2);
  d_Ref_Any & operator =(d_Object *p);
  void clear();
  void delete_object();

  const d_Object* object(void) const;

  // Boolean predicates checking to see if value is null or not
  d_Boolean operator!() const;
  d_Boolean is_null() const;

  friend d_Boolean operator== (const d_Ref_Any &r1, const d_Ref_Any &r2);
  friend d_Boolean operator== (const d_Ref_Any &r1, const d_Object *p);
  friend d_Boolean operator== (const d_Object *p, const d_Ref_Any &r2);
  friend d_Boolean operator!= (const d_Ref_Any &r1, const d_Ref_Any &r2);
  friend d_Boolean operator!= (const d_Ref_Any &r1, const d_Object *p);
  friend d_Boolean operator!= (const d_Object *p, const d_Ref_Any &r2);
  friend d_Boolean synonym (const d_Ref_Any &r1, const d_Ref_Any &r2);
  friend d_Boolean homonym (const d_Ref_Any &r1, const d_Ref_Any &r2);

  // non ODMG
  string persistentID(void) const;
  d_Object* object(void);

private:
  d_Object **_object;
  char ***_persistentID;
  unsigned long *_refcnt;

  void _reuseResource(void);

  static char * _empty;
  //  char* strdup(const char* s);
  //  char* strdup(string s);
};

//inline char* d_Ref_Any::strdup(const char* s){return new_strdup::strdup(s);}
//inline char* d_Ref_Any::strdup(string s){return new_strdup::strdup(s.data());}

inline string d_Ref_Any::persistentID(void) const
{
  if(NULL != *_object) return (*_object)->persistentID();
  else return string(**_persistentID);
}

inline const d_Object* d_Ref_Any::object(void) const{return *_object;}

inline void d_Ref_Any::clear(void) {_reuseResource();}

inline void d_Ref_Any::delete_object(void)
{/* if(NULL != _object){if(--(_object->_refcnt) == 0) delete _object; _object = NULL;}*/ delete *_object;}

inline d_Ref_Any::d_Ref_Any(void)
  :_object(new d_Object*),_persistentID(new char**),_refcnt(new unsigned long(0UL))
{*_object = NULL; *_persistentID = new char*; **_persistentID = strdup();}

inline d_Ref_Any::d_Ref_Any(const char* s)
  :_object(new d_Object*),_persistentID(new char**),_refcnt(new unsigned long(1UL))
{ *_object = NULL; 
*_persistentID = new char*;
  if(NULL == s || 0 == strlen(s)) **_persistentID = strdup();
  else **_persistentID =strdup(s);}

inline d_Ref_Any::d_Ref_Any(d_Object *p)
  :_object(new d_Object*),_persistentID(new char**),_refcnt(new unsigned long(1UL))
{*_object = p; *_persistentID = new char*; **_persistentID= strdup();}

inline d_Ref_Any::d_Ref_Any(const d_Ref_Any &r2)
  :_object(r2._object),_persistentID(r2._persistentID),_refcnt(r2._refcnt)
{ (*_refcnt)++;}


inline d_Boolean d_Ref_Any::operator!(void) const
{return (*_object == NULL && strlen(**_persistentID) == 0);}

inline d_Boolean d_Ref_Any::is_null(void) const
{return (*_object == NULL && strlen(**_persistentID) == 0);}

inline d_Boolean operator== (const d_Ref_Any &r, const d_Object *p)
{ return (*(r._object) == p);}

inline d_Boolean operator== (const d_Object *p, const d_Ref_Any &r)
{return r == p;}

inline d_Boolean operator!= (const d_Ref_Any &r1, const d_Ref_Any &r2){return !(r1==r2);}
inline d_Boolean operator!= (const d_Ref_Any &r, const d_Object *p){return !(r==p);}
inline d_Boolean operator!= (const d_Object *p, const d_Ref_Any &r){return !(r==p);}

inline d_Object* d_Ref_Any::object(void){return *_object;}
#endif // 1
#endif // !defined (__ODMG__)
#endif // __d_Ref_Any_h 20








