/*
 *
 * strmcmp.cxx: implementations of string comparison functions
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: strmcmp.cxx,v 1.1 1999/03/20 16:12:52 nozomi Exp $
 *	$Log: strmcmp.cxx,v $
 *	Revision 1.1  1999/03/20 16:12:52  nozomi
 *	strscmp and strscasecmp for shorter or shrinked comparison.
 *	
 *	Revision 1.0.0  1999/03/14 02:23:25  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include "strmcmp.h"
#include <ctype.h>

int strmcmp(const char* s1, const char* s2, size_t m)
{
  if(strlen(s1) >= m) s1 = s1 + strlen(s1) - m; 
  if(strlen(s2) >= m) s2 = s2 + strlen(s2) - m;
  return strncmp(s1, s2, m);
}

int  strmcasecmp(const char* s1, const char* s2, size_t m)
{
  if(strlen(s1) >= m) s1 = s1 + strlen(s1) - m; 
  if(strlen(s2) >= m) s2 = s2 + strlen(s2) - m;
  return strncasecmp(s1, s2, m);
}

int strfcmp(const char* s1, const char* s2, size_t m)
{
  size_t l1 = strlen(s1);
  size_t l2 = strlen(s2);
  return strncmp(s1, s2, l1<l2?l1-m:l2-m);
}

int  strfcasecmp(const char* s1, const char* s2, size_t m)
{
  size_t l1 = strlen(s1);
  size_t l2 = strlen(s2);
  return strncasecmp(s1, s2, l1<l2?l1-m:l2-m);
}

int strscmp(const char* s1, const char* s2)
{
  size_t l1 = strlen(s1);
  size_t l2 = strlen(s2);
  register const char* s = s1 + l1;
  while(isspace(*s) && s > s1){--s;--l1;}
  switch(*s){ 
  case '.':  case ',':  case ':':  case ';':
    --l1;
  }

  s = s2 + l2;
  while(isspace(*s) && s > s2){--s;--l2;}
  switch(*s){ 
  case '.':  case ',':  case ':':  case ';':
    --l2;
  }

  return strncmp(s1, s2, l1<l2?l1:l2);
}

int strscasecmp(const char* s1, const char* s2)
{
  size_t l1 = strlen(s1);
  size_t l2 = strlen(s2);
  register const char* s = s1 + l1;
  while(isspace(*s) && s > s1){--s;--l1;}
  switch(*s){ 
  case '.':  case ',':  case ':':  case ';':
    --l1;
  }

  s = s2 + l2;
  while(isspace(*s) && s > s2){--s;--l2;}
  switch(*s){ 
  case '.':  case ',':  case ':':  case ';':
    --l2;
  }

  return strncasecmp(s1, s2, l1<l2?l1:l2);
}

