/*
 *
 * strmcmp.h: definitions of string comparison functions
 * for a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: strmcmp.h,v 1.2 1999/12/05 19:01:19 nozomi Exp $
 *	$Log: strmcmp.h,v $
 *	Revision 1.2  1999/12/05 19:01:19  nozomi
 *	add some functions
 *	
 *	Revision 1.1  1999/03/20 16:13:52  nozomi
 *	strscmp and strscasecmp for shrinked comparison
 *	
 *	Revision 1.0.0  1999/03/14 02:23:32  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

// strm[case]cpm compares given two strings, but only last m characters specified 
// by the last paramter.  strmcasecmp is not case sensitive.

// strf[case]cpm compares given two strings, except last m characters specified 
// by the last paramter.  strfcasecmp is not case sensitive.

#if (!defined(__strmcmp_h))
#define __strmcmpn_h
#if (__GNUC_MINOR__ > 7)
#include <string>
#else
#include <string.h>
#endif

//compare m characters at tail 
int strmcmp(const char* s1, const char* s2, size_t m);
int strmcasecmp(const char* s1, const char* s2, size_t m);

int strmcmp(const char* s1, const char* s2);
int strmcasecmp(const char* s1, const char* s2);

//ignore m characters at tail
int strfcmp(const char* s1, const char* s2, size_t m);
int strfcasecmp(const char* s1, const char* s2, size_t m);


//compare strings only in leght of the shoter one
//period at end will be ignored
int strscmp(const char* s1, const char* s2);
int strscasecmp(const char* s1, const char* s2);

int strncmp(const char* s1, const char* s2);
int strncasecmp(const char* s1, const char* s2);

inline int strncmp(const char* s1, const char* s2)
{ return strncmp(s1, s2, strlen(s2)); }

inline int strncasecmp(const char* s1, const char* s2)
{ return strncasecmp(s1, s2, strlen(s2)); }

inline int strmcmp(const char* s1, const char* s2)
{ return strmcmp(s1, s2, strlen(s2)); }

inline int strmcasecmp(const char* s1, const char* s2)
{ return strmcasecmp(s1, s2, strlen(s2)); }

inline int strcasecmp(const string &s, const char* c)
{ return strcasecmp(s.c_str(), c);}

inline int strcasecmp(const char* c, const string &s) 
{ return strcasecmp(c, s.c_str());}

inline int strncmp(const string &s, const char* c, size_t n)
{ return strncmp(s.c_str(), c, n);}

inline int strcmp(const char* c, const string &s, size_t n) 
{ return strncmp(c, s.c_str(), n);}

inline int strncmp(const string &s, const char* c)
{ return strcmp(s.c_str(), c, strlen(c));}

inline int strncasecmp(const string &s, const char* c, size_t n)
{ return strncasecmp(s.c_str(), c, n);}

inline int strncasecmp(const string &s, const char* c)
{ return strncasecmp(s.c_str(), c, strlen(c));}


#endif
