/*
 *
 * testNomencuratorp.cxx: sample implementation of a Nomenclature Heuristic Model.
 * It may be called also N3, Nomenclature Netowrok Navigator
 * or more simply, MkII.
 *
 * Copyright (c) 1999 Nozomi `James' Ytow
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Where this Software is combined with software released under the terms of 
 * the GNU Public License ("GPL") and the terms of the GPL would require the 
 * combined work to also be released under the terms of the GPL, the terms
 * and conditions of this License will apply in addition to those of the
 * GPL with the exception of any terms or conditions of this License that
 * conflict with, or are expressly prohibited by, the GPL.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: testNomencurator.cxx,v 1.29 1999/12/05 20:47:41 nozomi Exp $
 *	$Log: testNomencurator.cxx,v $
 *	Revision 1.29  1999/12/05 20:47:41  nozomi
 *	fix errors
 *	
 *	Revision 1.28  1999/12/05 18:25:29  nozomi
 *	class NHM renamed to Nomencurator
 *	
 *	Revision 1.27  1999/09/20 14:22:38  nozomi
 *	data addition, commit, dump to file add
 *	
 *	Revision 1.26  1999/08/31 12:34:03  nozomi
 *	out command reports current output mode if mode is not specified
 *	
 *	Revision 1.25  1999/08/31 12:16:15  nozomi
 *	use list rather than set
 *	
 *	Revision 1.24  1999/08/26 07:21:04  nozomi
 *	higher and lower support
 *	
 *	Revision 1.23  1999/08/23 06:48:54  nozomi
 *	output format modified
 *	
 *	Revision 1.22  1999/08/21 00:51:02  nozomi
 *	modify display design
 *	
 *	Revision 1.21  1999/08/16 07:08:46  nozomi
 *	some verbose messages deleted
 *	
 *	Revision 1.20  1999/08/15 01:43:53  nozomi
 *	variety support
 *	
 *	Revision 1.19  1999/08/13 13:08:22  nozomi
 *	Hierarchy suppor (incomplete)
 *	
 *	Revision 1.18  1999/08/11 07:32:37  nozomi
 *	change handling of nov
 *	
 *	Revision 1.17  1999/08/09 00:06:38  nozomi
 *	change equiv handling
 *	
 *	Revision 1.16  1999/08/08 11:31:52  nozomi
 *	PTR mode support
 *	
 *	Revision 1.15  1999/08/06 12:28:03  nozomi
 *	Publication::volume() does not return int anymore.  Fixed.
 *	
 *	Revision 1.14  1999/03/22 17:06:08  nozomi
 *	minor modification of output format
 *	
 *	Revision 1.13  1999/03/19 06:42:59  nozomi
 *	zombies clean up code for fork
 *	threads works now
 *	
 *	Revision 1.12  1999/03/18 10:21:16  nozomi
 *	reorganization in query routine.
 *	more organization is possible,
 *	but we also need to improve query `language' design.
 *	
 *	Revision 1.11  1999/03/17 19:45:47  nozomi
 *	delete yet another debug code
 *	
 *	Revision 1.10  1999/03/17 19:44:36  nozomi
 *	delete debug info
 *	thread included, but not yet work.
 *	
 *	Revision 1.9  1999/03/17 18:33:44  nozomi
 *	server mode support
 *	
 *	Revision 1.8  1999/03/16 03:50:31  nozomi
 *	raw command supported to show raw data
 *	
 *	Revision 1.7  1999/03/15 18:36:37  nozomi
 *	minor modification in show command output format
 *	
 *	Revision 1.6  1999/03/15 16:42:42  nozomi
 *	gcc 2.7 support macro
 *	
 *	Revision 1.5  1999/03/15 13:23:13  nozomi
 *	minor modifications in help message etc.
 *	
 *	Revision 1.4  1999/03/14 09:49:49  nozomi
 *	display homonym with -> symbol
 *	select set with negative index supported
 *	show command without number shous all records
 *	
 *	Revision 1.3  1999/03/14 08:58:26  nozomi
 *	Annotation keyword "propagate" is supported.
 *	It is translated into comb in case of species
 *	
 *	Revision 1.2  1999/03/14 08:30:58  nozomi
 *	fix unset verbose number bug
 *	ostream& operator<<(ostream&, set<NRnode*>&) is static to avoid its misuse
 *	
 *	Revision 1.1  1999/03/14 07:40:50  nozomi
 *	option -v was added to support verbose mode of class NHM
 *	
 *	Revision 1.0  1999/03/14 02:24:21  nozomi
 *	Initial version, though aka MkII
 *	
 *
 */

#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include "socketstream.h"
#include "Nomencurator.h"
#include "Query.h"
#if (__GNUC_MINOR__ > 7)
#include <list>
#include <string>
#else
#include <list.h>
#include <string.h>
#endif
#include <stdio.h>
#include <errno.h>

//struct used only to show usage
struct usage{
  usage(void){};
  friend ostream& operator<<(ostream&, usage &);
};

enum outputMode {TEXT, PTR, FULL};


static string _NameRecordText(const NRnode *nrn);
static string _NameRecordMinorText(const NRnode *nrn);
static string _NameRecordPtr(const NRnode *nrn);
static list<int> numbersequence(const char* s);
static int queries(istream& ins, ostream& outs, Nomencurator *nomencurator);

#if 1
string publication(NRnode* nrn, outputMode om);
string publication(NameRecord* nrptr, outputMode om);
string publication(Citation* cptr, outputMode om);
string publication(Publication* pubptr, outputMode om);
#endif

string _publicationInText(NRnode* nrn);
string _publicationInText(NameRecord* nrptr);
string _publicationInText(Citation* cptr);
string _publicationInText(Publication* pubptr);
string _publicationInPtr(NRnode* nrn);
string _publicationInPtr(NameRecord* nrptr);
string _publicationInPtr(Citation* cptr);
string _publicationInPtr(Publication* pubptr);

#if 0
struct queries_out{
  ostream& (*outputfunction)(ostream&, list<NRnode*> &);
  string (*_NameRecordMinorExtract)(const NRnode *nr);
  string (*_NameRecordExtract)(const NRnode *nr);
};
#else
struct queries_out{
  outputMode om;
  ostream& (*outputfunction)(ostream&, list<d_Object*> &);
  string (*_NameRecordMinorExtract)(const NRnode *nr);
  string (*_NameRecordExtract)(const NRnode *nr);
};
#endif

#if (defined(PTHREAD))
struct queries_arg{
  int fd;//fstream *f;
  Nomencurator *nomencurator;
};

static void* queries(void*);
//static void* queries(queries_arg*);
#include <pthread.h>
#else
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
void terminateZombies(int signo);
#endif

//global
int verbose = 0;
outputMode _om(TEXT);
#if 0
static ostream& operator<<(ostream&, set<NRnode*>&);
static ostream& textNameRecord(ostream&, set<NRnode*> &);
static ostream& ptrNameRecord(ostream&, set<NRnode*> &);
static ostream& (*outputfunction)(ostream&, set<NRnode*> &)
  = textNameRecord;
static string (*_NameRecordMinorExtract)(const NRnode *nr)
  = _NameRecordMinorText;
static string (*_NameRecordExtract)(const NRnode *nr)
  = _NameRecordText;
#else
static ostream& operator<<(ostream&, list<d_Object*>&);
static ostream& operator<<(ostream&, list<NRnode*>&);
ostream& textNameRecord(ostream&, list<d_Object*> &);
ostream& ptrNameRecord(ostream&, list<d_Object*> &);
ostream& ptrNamedObject(ostream&, list<d_Object*> &);
ostream& (*outputfunction)(ostream&, list<d_Object*> &)
  = textNameRecord;
string (*_NameRecordMinorExtract)(const NRnode *nr)
  = _NameRecordMinorText;
string (*_NameRecordExtract)(const NRnode *nr)
  = _NameRecordText;
#endif

#if 0
static string (*publication)(NRnode* nrn)
 = _publication;
static string (*publication)(NameRecord* nrptr)
 = _publication;
static string (*publication)(Citation* cptr)
 = _publication;
static string (*publication)(Publication* pubptr)
 = _publication;
#endif
int main(int argc, char **argv)
{
  list<char*> filenames;
  bool usecin = false;
  int dump = 0;
  int port = 0;
  char * socketfile = NULL;
  bool batch = false;
  Socket *socket = NULL;
  char * configFile = NULL;
  if(argc > 1){
    for(int i = 1; i < argc; i++){
      if('-' == argv[i][0]){ //option
	switch(argv[i][1]){
	case '0':
	  usecin = true;
	  break;
	case 'd':
	  dump++;
	  break;
	case 'p':
	  port = atoi(argv[++i]);
	  if(socketfile)
	    socketfile = NULL;
	  break;
	case 'u':
	  if(port == 0)
	    socketfile = argv[++i];
	  break;
	case 'v':
	  verbose++;
	  break;
	case 'f':
	  configFile = argv[++i];
	  break;
	}
      }
      else{
	filenames.push_back(argv[i]);
      }
    }
  }

  Nomencurator nomencurator;
  if(verbose)
    nomencurator.verbose(verbose);

  if(!filenames.empty()){
    list<char*>::const_iterator f = filenames.begin();
    list<char*>::const_iterator end = filenames.end();
    while(f != end){
      ifstream fin(*f);
      if(fin) {
	if(0 == port && socketfile == NULL && 0 == dump)
	  cout <<"%reading and analyzing file " << *f << "\r\n";
	while(fin) fin >> nomencurator;
	if(0 == port && socketfile == NULL && 0 == dump)
	  cout <<"%file " << *f << " has been read and analyzed."<< "\r\n";
      }
      else if(0 == port && socketfile == NULL && 0 == dump) {
	cout <<"%can't read file " << *f << "\r\n";
      }
      ++f;
    }
  }
  else{ while(cin) cin >> nomencurator; batch = true; }
  if(dump){ cout << nomencurator; return 0; }
  if(batch)  return 0;
  
  int ret = 0;
  if(port || socketfile){
    if(port)
      socket = new ip4socket(port, 10);
    else
      socket = new unixsocket(socketfile, 10);
    int conn;

#if (defined(PTHREAD))
    while((conn = socket->accept()) > -1 || errno == EINTR){
      pthread_t thread;
      //pthread_attr_t attr;
      queries_arg *arg = new queries_arg;
      arg->fd = conn;
      arg->nomencurator = &nomencurator;

      pthread_create(&thread, NULL/*&attr*/, queries, (void*)arg);
    }
#else
    signal(SIGCHLD, terminateZombies);
    while((conn = socket->accept()) > -1 || errno == EINTR){
      pid_t cpid;
      if(!(cpid = fork())){
	socket->unlisten();
	fstream f(conn);
	queries(f, f, &nomencurator);
	shutdown(conn, 2/*SHUT_RDWR*/);
	close(conn);
	exit(0);
      }
    }
#endif
    delete socket;
  }
  else{
    ret = queries(cin, cout, &nomencurator);
  }
  return ret;
}

ostream& operator<<(ostream& s, usage &u)
{
  s << "help, ?: show this message\r\n";
  s << "Q, q, quit: quit\r\n";
  s << "name                : search specified string\r\n";
  s << "generic             : search specified string as generic part of extended binomen\r\n";
  s << "major               : same as generic.  obsolete\r\n";
  s << "specific            : search specified string as specific part (epithet) of extended binomen\r\n";
  s << "minor               : same as specific.  obsolete\r\n";
  s << "history  [modifier] : navigate by specified string\r\n";
  s << "current  [modifier] : current name of specified string\r\n";
  s << "origin   [modifier] : origin of specified string\r\n";
  s << "synonym  [modifier] : synonym of specified string\r\n";
  s << "author              : search specified author\r\n";
  s << "publication by      : search publications written by specified author\r\n";
  s << "out [text|ptr|raw]  : set output mode to specified one.\r\n";
  s << "                     if notihng specified, returns current output mode.\r\n";
  s << "clear  [numberlist] : clear stored results specified like 1 3 7-12\r\n";
  s << "                    : all query results be deleted without number\r\n";
  s << "select number       : select stored results specified by number\r\n";
  s << "                    : negative number can be used as `prvious' set.\r\n";
  s << "show [numberlist]   : show records specified like 1 3 7-12 \r\n";
  s << "                    : all reacords will be shown without number\r\n";
  s << "raw  [numberlist]   : show raw data specified like 1 3 7-12 \r\n";
  s << "                    : all raw data will be shown if any number is not specified\r\n";
  s << "append              : add new records to a temporal DB. Terminate with empty record \"={}\"\r\n";
  s << "commit              : commit appended records to DB.  Temporal DB will be cleard\r\n";
  s << "abort               : temporal DB will be cleard without commitment\r\n";
  s << "dump [filename]     : write DB to [specified file or] standard output.\r\n";
  s << "\r\n";
  s << " the modifier (one of name, generic [major], specific [minor]) is optional.\r\n";
  s << " indented records are non-current name, including revised.\r\n";
  s << "\r\n";
  return s;
}

#if 0
static ostream& operator<<(ostream& s, set<NRnode*> &st)
{
  list<NRnode*> l;
  set<NRnode*>::iterator si = st.begin();
  set<NRnode*>::iterator se = st.end();
  while(si != se){
    l.push_back(*si);
    si++;
  }
  return outputfunction(s, l);
}

static ostream& setOutputfunction(ostream& s, set<NRnode*> &st, queries_out &output)
{
  list<NRnode*> l;
  set<NRnode*>::iterator si = st.begin();
  set<NRnode*>::iterator se = st.end();
  while(si != se){
    l.push_back(*si);
    si++;
  }
  return output.outputfunction(s, l);
}

static ostream& operator<<(ostream& s, list<NRnode*> &l)
{
  return outputfunction(s, l);
}

#else
static ostream& operator<<(ostream& s, set<NRnode*> &st)
{
  list<d_Object*> l;
  set<NRnode*>::iterator si = st.begin();
  set<NRnode*>::iterator se = st.end();
  while(si != se){
    l.push_back(*si);
    si++;
  }
  return outputfunction(s, l);
}

static ostream& operator<<(ostream& s, set<d_Object*> &st)
{
  list<d_Object*> l;
  set<d_Object*>::iterator si = st.begin();
  set<d_Object*>::iterator se = st.end();
  while(si != se){
    l.push_back(*si);
    si++;
  }
  return outputfunction(s, l);
}

static ostream& setOutputfunction(ostream& s, set<d_Object*> &st, queries_out &output)
{
  list<d_Object*> l;
  set<d_Object*>::iterator si = st.begin();
  set<d_Object*>::iterator se = st.end();
  while(si != se){
    l.push_back(*si);
    si++;
  }
  return output.outputfunction(s, l);
}

static ostream& operator<<(ostream& s, list<d_Object*> &l)
{
  return outputfunction(s, l);
}

static ostream& operator<<(ostream& s, list<NRnode*> &ln)
{
  list<d_Object*> l;
  list<NRnode*>::iterator i = ln.begin();
  list<NRnode*>::iterator e = ln.end();
  while(i != e){
    l.push_back(*i);
    i++;
  }
  return outputfunction(s, l);
}
#endif

/*
 * output function for TEXT mode
 */
ostream& textNameRecord(ostream& s, list<d_Object*> &st)
{
  list<d_Object*>::iterator si = st.begin();
  list<d_Object*>::iterator se = st.end();
  list<NRnode*>::iterator ri;
  list<NRnode*>::iterator re;
  list<NRnode*> l;

  hash_map<string, NRnode*, Hash<string> > h;
  
  while(si != se){
    l.push_back((NRnode*)*si);
    list<NRnode*> r(current((NRnode*)*si));
    ri = r.begin();
    re = r.end();
    while(ri != re){
      h[(*ri)->namerecord->persistentID()] = *ri;
      ++ri;
    }
    ++si;
  };
  //  l.sort(NRnode::gt());
  l.sort(NRnode::lt());
  int cnt = 0;
  hash_map<string, NRnode*, Hash<string> >::iterator he = h.end();
  list<NRnode*>::iterator li = l.begin();
  list<NRnode*>::iterator le = l.end();
  list<int> to;
  list<int> from;

  int recordNum = 1;

  while(li != le){
    recordNum++;
    li++;
  }

  list<int> referred[recordNum];
  for(int i = 0; i < recordNum; i++){
    referred[i].clear();
  }

  li = l.begin();

  while(li != le){
    s << "#";
    if(verbose > 0)
      s << "["<< (*li)->namerecord.ptr() << "]";
    s << ++cnt ;
    if(he == h.find((*li)->namerecord->persistentID()))
      s << "     ";//"\t"
    else{
      if(cnt < 10) s << "  ";
      else s << " ";
    }

    s << _NameRecordExtract(*li);

    list<d_Ref<Annotation> >::iterator ai = 
      (*li)->namerecord->annotation.begin();
    list<d_Ref<Annotation> >::iterator ae = 
      (*li)->namerecord->annotation.end();

    if(ai != ae)
	s << " ";
    while(ai != ae){
      if(!strcmp ((*ai)->annotation(), "nov") && (*ai)->to.empty())
	s << " nov ";
      else{
	bool part = !strcmp ((*ai)->annotation(), "part");
	bool homo = !strncmp ((*ai)->annotation(), "hom", 3);
	bool equiv = !strncmp ((*ai)->annotation(), "equ",3);
	if(part)
	  {s << " part(";}
	else if(homo)
	  {s << " hom(";}
	else if(!strncasecmp ((*ai)->annotation(), "assign",6))
	  {s << " assign(";}
	else if(!strncasecmp ((*ai)->annotation(), "propagate",9)){
	  if((*li)->namerecord->group() == string("species"))
	    {s << " comb(";}
	  else
	    {s << " prop(";}
	}
	else {s << " " << string((*ai)->annotation(), 0, 3) << "(";}
	if(!equiv){
	  list<d_Ref<NameRecord> >::iterator ni = (*ai)->to.begin();
	  list<d_Ref<NameRecord> >::iterator ne = (*ai)->to.end();
	  to.clear();
	  if(ni == ne) s << ni->persistentID()<<  " points empty!\r\n";
	  while(ni != ne){
	    
	    list<NRnode*>::iterator lli = l.begin();
	    int _cnt = 1;
	    while(lli != le){
	      if(li != lli && (&*((*lli)->namerecord) == ni->ptr() ||
		 (*lli)->namerecord->persistentID() == ni->persistentID())){
		to.push_back(_cnt);
		if(_cnt != cnt){
		  referred[_cnt].push_back(cnt);
		}
	      }
	      ++_cnt;
	      ++lli;
	    }
	    ++ni;
	  }
	  to.sort();
	  
	  list<int>::iterator lri = to.begin();
	  list<int>::iterator lre = to.end();
	  if(lri == lre)
	    s << "n/s";
	  else{
	    s << *lri; 
	    ++lri;
	    while(lri != lre){
	      s << "," << *lri;
	      ++lri;
	    }
	  }
	}
	if(part || homo || equiv){
	  list<d_Ref<NameRecord> >::iterator ni = (*ai)->from.begin();
	  list<d_Ref<NameRecord> >::iterator ne = (*ai)->from.end();
	  from.clear();
	  while(ni != ne){
	    list<NRnode*>::iterator lli = l.begin();
	    int _cnt = 1;
	      while(lli != le){
		if(&*((*lli)->namerecord) == ni->ptr()){
		  from.push_back(_cnt);
		  if(_cnt != cnt){
		    referred[_cnt].push_back(cnt);
		  }
		}
		++_cnt;
		++lli;
	      }
	      ++ni;
	  }
	  if(!from.empty()){
	    if(part || homo)
	      s << "->";
	    from.sort();
	    list<int>::iterator lri = from.begin();
	    s << *lri;
	    ++lri;
	    list<int>::iterator lre = from.end();
	    while(lri != lre){
	      s << "," << *lri;
	      ++lri;
	    }
	  }
	}
	s << ")";
      }
      ++ai;
    }

    if(!referred[cnt].empty()){
      referred[cnt].sort();
      referred[cnt].unique();
      register list<int>::iterator ri = referred[cnt].begin();
      s << " <" << *ri;
      ++ri;
      register list<int>::iterator re = referred[cnt].end();
      while(ri != re){
	s << ", " << *ri;
	ri++;
      }
      s << ">";
    }
    s << "\r\n";
    ++li;
  };
 return s;
}

ostream& ptrNamedObject(ostream& s, list<d_Object*> &st)
{
  list<d_Object*>::iterator si = st.begin();
  list<d_Object*>::iterator se = st.end();

  if(si == se)
    return s;

  while(si != se){
    if(strncmp((*si)->persistentID().c_str(), "NRnode::"))
      break;
    si++;
  }

  if(si == se) {
    s << "HERE"<<endl;
    return ptrNameRecord(s, st);
  }

  si = st.begin();
  int cnt = 0;
  while(si != se){
    cnt++;
    si++;
  }
  s << "+" << cnt << "\r\n"; 

  si = st.begin();
  while(si != se){
    s << (*si)->persistentID();
    s << "\r\n";
    si++;
  }
  s << "\r\n";

  return s;
}

ostream& ptrNameRecord(ostream& s, list<d_Object*> &st)
{
  list<d_Object*>::iterator si = st.begin();
  list<d_Object*>::iterator se = st.end();
  list<NRnode*>::iterator ri;
  list<NRnode*>::iterator re;
  list<NRnode*> l;

  hash_map<string, NRnode*, Hash<string> > h;
  
  while(si != se){
    l.push_back((NRnode*)*si);
    list<NRnode*> r(current((NRnode*)*si));
    ri = r.begin();
    re = r.end();
    while(ri != re){
      h[(*ri)->namerecord->persistentID()] = *ri;
      ++ri;
    }
    ++si;
  };
  l.sort(NRnode::gt());
  int cnt = 0;
  //  hash_map<string, NRnode*, Hash<string> >::iterator he = h.end();
  list<NRnode*>::iterator li = l.begin();
  list<NRnode*>::iterator le = l.end();
  while(li != le){
    ++cnt ;
    ++li;
  }

  s << "+" << cnt << "\r\n"; 

  li = l.begin();
  while(li != le){
    s << (*li)->namerecord->persistentID();
    s << "\r\n";
    ++li;
  };
  s << "\r\n";
 return s;
}

ostream& textAuthor(ostream& s, list<d_Object*> &st)
{
  list<d_Object*>::iterator si = st.begin();
  list<d_Object*>::iterator se = st.end();

  while(si != se){
    Author* a = (Author*)(*si);
    si++;
    if(a != NULL) {
      s << a->fullname();
      int birth = a->birthYear();
      int death = a->deathYear();
      if(birth != Date::invalidYear || death != Date::invalidYear) {
	Date birthday = a->birth();
	Date deathday = a->death();
	s << " (";
	if(birth == Date::invalidYear) {
	  s << '?';
	}
	else if(birthday.month() != Date::invalidMonth) {
	  s << birthday << ' ';
	}
	else {
	  s << birth << '?';
	}
	s << "- ";
	if(death == Date::invalidYear) {
	  s << '?';
	}
	else if(deathday.month() != Date::invalidMonth) {
	  s << deathday << ' ';
	}
	else {
	  s << death << '?';
	}
	s << ')';
      }

      list<d_Ref<Publication> >::iterator pi = a->publications.begin();
      list<d_Ref<Publication> >::iterator pe = a->publications.end();
      int cnt = 0;
      
      while(pi != pe){
	++cnt;
	++pi;
      }

      s << ' ' << cnt << " publication" << (cnt > 1 ?"s":"") << "\r\n";
    }
  }
  return s;
}


ostream& rawOutput(ostream& s, list<d_Object*> &st);
ostream& _rawOutput(ostream& s, list<NRnode*> &st){
  list<d_Object*> tmp;
  list<NRnode*>::iterator li = st.begin();
  list<NRnode*>::iterator le = st.end();
  while(li != le){
    tmp.push_back(*li);
    ++li;
  }
  return rawOutput(s, tmp);
}

ostream& rawOutput(ostream& s, list<d_Object*> &st)
{
  int cnt = 0;
  list<d_Object*>::iterator li = st.begin();
  list<d_Object*>::iterator le = st.end();
  while(li != le){
    ++cnt ;
    ++li;
  }

  s << "+" << cnt << "\r\n"; 

  li = st.begin();
  while(li != le){
    (*li)->printTo(s);
    ++li;
  };
  s << "\r\n";
 return s;
}


static list<int> numbersequence(const char* s)
{
  list<int> l;
  while(*s){
    int prv;
    while(*s && !isdigit(*s)){s++;}
    l.push_back(prv = atoi(s));
    while(*s && isdigit(*s)){s++;}
    if('-' == *s){
      while(*s && !isdigit(*s)){s++;}
      int last = atoi(s);
      while(*s && isdigit(*s)){s++;}
      while(prv < last)
	l.push_back(++prv);
    }
  }
  return l;
}

#if (defined(PTHREAD))
//void* queries(queries_arg *arg)
void* queries(void *varg)
{
  queries_arg *arg = (queries_arg*)varg;
  pthread_detach(pthread_self());
  int fd = arg->fd;
  Nomencurator* nomencurator = arg->nomencurator;
  delete arg;
  fstream f(fd);
  queries(f, f, nomencurator);
  shutdown(fd, 2/*SHUT_RDWR*/);
  close(fd);
  return NULL;
}
#else
void terminateZombies(int signo)
{
  pid_t pid;
  //  int stat;
  //  while( (pid = waitpid(-1, &stat, WNOHANG)) > 0);
  while( (pid = waitpid(-1, NULL, WNOHANG)) > 0);
  return;
}
#endif

static void show_raw(ostream & outs, const char* s, list<Query>& query);
static void show_each(ostream & outs, const char* s, list<Query>& query, outputMode om);
static void set_out(ostream & outs, const char* s, list<Query>& query, queries_out& output);
int query_clear(const char *s, list<Query>& query, int seq);

//static void select(ostream & outs, const char* s, list<Query>& query, int seq);
static list<d_Object*> select(ostream & outs, const char* s, list<Query>& query, int seq, queries_out &);

static list<d_Object*> history(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> higher(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out&);
static list<d_Object*> lower(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out&);
static list<d_Object*> subtree(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out&n);
static list<d_Object*> hierarchy(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out&);
list<NRnode*> _lower(ostream &, const char*, Nomencurator*, int, int, NRnode*, int&, queries_out&, bool toOut = true);
/*
static list<d_Object*> top(ostream & outs, const char* s, Nomencurator* nomencurator, int seq);
static list<d_Object*> bottom(ostream & outs, const char* s, Nomencurator* nomencurator, int seq);
*/
static list<d_Object*> thread(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
void ptr(ostream & outs, const char* s, Nomencurator* nomencurator, set<NRnode*> &st, int seq); 
static list<d_Object*> genus(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out&); 
static list<d_Object*> species(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> synonyms(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &); 
static list<d_Object*> origin(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> currents(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> revisions(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> author(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> publication(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> publicationBy(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);
static list<d_Object*> publicationOn(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &);

static bool append(istream & ins, Nomencurator *);
static bool commit(Nomencurator *, Nomencurator *);

int queries(istream& ins, ostream& outs, Nomencurator *nomencurator)
{
  const int buflen = 8192; //256;
  char buffer[buflen];
  list<Query> query;
  bool gen = false, spec = false, nm = false, ptr = false;
  int seq = 1;
  Nomencurator n;
  queries_out output;
  output.outputfunction =  textNameRecord;
  output._NameRecordMinorExtract = _NameRecordMinorText;
  output._NameRecordExtract = _NameRecordText;
  output.om = TEXT;

  while(ins){
    outs << "%" << seq << "> " << flush;
    ins.getline(buffer, buflen);
    int gc = ins.gcount();
    if(ins){
      char *s = buffer;
      if(gc < buflen){
	s = buffer + strlen(buffer);
	while(*s == 0 || isspace(*s)){s--;}
	if(s - buffer < buflen - 1)
	  *++s = 0;
	s = buffer;
      }

      while(isspace(*s)){s++;}
      if(0 == *(s+1) && ('q' == *s || 'Q' == *s)) return 0;
      if(!strncasecmp(s, "quit", 4)) return 0;
      if(!strncasecmp(s, "exit", 4)) return 0;
      if(!strncasecmp(s, "dump", 4)) {
	if(strlen(s) == 4)
	  outs << *nomencurator;
	else{
	  s += 4;
	  while(isspace(*s)){s++;}
	  ofstream f(s);
	  f << *nomencurator;
	}
      }
      else if(!strncasecmp(s, "abort", 5)) {
	outs << (n.clear()?"+SUCCESS":"-FAIL") <<endl;
      }
      else if(!strncasecmp(s, "commit", 6)) {
	outs << (commit(nomencurator, &n)?"+SUCCESS":"-FAIL") <<endl;
      }
      else if(!strncasecmp(s, "append", 6)) {
	outs << (append(ins, &n)?"+SUCCESS":"-FAIL") <<endl;
      }
      else if(!strncasecmp(s, "help", 4)) {usage u; outs << u;}
      //      else if(!strncasecmp(s, "clear", 4)) {query.clear();seq = 1;}
      else if(!strncasecmp(s, "clear", 4)) {seq = query_clear(s, query, seq);}
      else if(!strncasecmp(s, "raw", 3)) show_raw(outs, s, query);
      else if(!strncasecmp(s, "show", 4)) show_each(outs, s, query, output.om);
      else if(!strncasecmp(s, "out", 3)) set_out(outs, s, query, output);
      else{
	Query q(s);
	set<NRnode*> st;
	seq++;
	while(isspace(*s)){s++;}
	if(!strncasecmp(s, "select", 6)) q.ans = select(outs, s, query, seq, output);
	else if(!strncasecmp(s, "history", 7)) q.ans = history(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "thread", 6)) q.ans = thread(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "genus", 5)) q.ans = genus(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "species", 7)) q.ans = species(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "syn", 3)) q.ans = synonyms(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "origin", 6)) q.ans = origin(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "rev", 3)) q.ans = revisions(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "current", 7)) q.ans = currents(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "subtree", 7)) q.ans = subtree(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "hier", 4))  q.ans = hierarchy(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "tree", 4))  q.ans = hierarchy(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "high", 4))  q.ans = higher(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "lower", 5))  q.ans = lower(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "author", 6))  q.ans = author(outs, s, nomencurator, seq, output);
	else if(!strncasecmp(s, "ptr ", 4)) {
	  s += 4;
	  char *tail = s + strlen(s);
	  while(s < tail && isspace(*s)){s++;}
	  q.ans = nomencurator->ptr(s);
	  output.outputfunction(outs, q.ans);
	}
	else if((gen = !strncasecmp(s, "major ", 6)) ||
		(gen = !strncasecmp(s, "generic ", 8)) ||
		(spec = !strncasecmp(s, "minor ", 6)) ||
		(spec = !strncasecmp(s, "specific ", 9)) ||
		(nm = !strncmp(s, "name ", 5))) {
	  if(gen || spec)
	    s+= 5;
	  else
	    s+=4;
	  while(isspace(*s)){s++;}
	  if('=' == *s)
	    while('=' == *s){s++;}
	  while(isspace(*s)){s++;}
	  list<NRnode*> res;
	  if(gen)
	    res = nomencurator->generic(s);
	  else if(spec)
	    res = nomencurator->specific(s);
	  else
	    res = nomencurator->name(s);
	  if(res.empty())
	    outs << "-no record found for " << s << "\r\n";
	  else{
	    res.sort(NRnode::gt());
	    res.unique();
	    list<NRnode*>::iterator iter = res.begin();
	    list<NRnode*>::iterator end = res.end();
	    while(iter != end){
	      q.ans.push_back(*iter);
	      ++iter;
	    };

	    output.outputfunction(outs, q.ans);

	  }
	}

	query.push_back(q);
      }
    }
  }
  return 0;
}

int query_clear(const char *s, list<Query>& query, int seq) 
{
  const char *tail = s + strlen(s) + 1;
  while(s < tail && !isspace(*s)){s++;}
  while(s < tail  && isspace(*s)){s++;}
  if(s >= tail){
    query.clear();
    return 1;
  }

  list<int> l(numbersequence(s));
  if(l.empty()){
    query.clear();
    return 1;
  }

  
  list<int>::iterator iter = l.begin();
  list<int>::iterator end  = l.end();
  while(iter != end){
    if(*iter < 1){
      int *i = &*iter;
      *i = seq - 1 + *iter;
    }
    ++iter;
  }
  l.sort();
  l.unique();

  list<Query>::iterator q = query.begin();
  list<Query>::iterator e = query.end();
  int cnt = 1;
  while(!l.empty()){
    int i = *(l.begin());
    l.pop_front();
    while(q != e){
      if(i == cnt){
	Query *r = &*q;
	query.remove(*r);
	seq--;
	cnt++;
	q++;
	break;
      }
      cnt++;
      q++;
    }
  }
  return seq;
}

void show_raw(ostream & outs, const char* s, list<Query>& query) 
{
  const char *tail = s + strlen(s) + 1;
  while(s < tail && !isspace(*s)){s++;}
  while(s < tail  && isspace(*s)){s++;}
  if(s >= tail)
    return;

  list<int> l(numbersequence(s));
  
  //choose last. may be modified to support -1:1, 2, 5 etc.
  list<Query>::iterator q = query.end();
  --q;
  
  list<d_Object*>::iterator qi = q->ans.begin();
  list<d_Object*>::iterator qe = q->ans.end();
  
  if(l.empty()){
    int i = 0;
    while(qi != qe){
      l.push_back(++i);
      ++qi;
    }
  }
  list<int> ::iterator li = l.begin();
  list<int> ::iterator le = l.end();
  while(li != le){
    qi = q->ans.begin();
    int cnt = 0;
    while(qi != qe && *li > cnt){
      if(*li == ++cnt){
	NameRecord *nr = &*(((NRnode*)(*qi))->namerecord);
	outs << "#" << *li << "\r\n";
#if 0
	outs << "%OID = " << nr << "\r\n";
#endif
	outs << *nr;
	Citation *c = nr->recorder().ptr();
	if(c){
#if 0
	  outs << "%OID = " << c << "\r\n";
#endif
	  outs << *c;
	  Publication *p = c->publication().ptr();
	  if(p){
#if 0
	    outs << "%OID = " << p << "\r\n";
#endif
	    outs<< *p;
	  }
	}
      }
      ++qi;
    }
    ++li;
  }
}

void show_each(ostream & outs, const char* s, list<Query>& query, outputMode om)
{
  while(*s && !isspace(*s)){s++;}
  while(*s && isspace(*s)){s++;}
  list<int> l(numbersequence(s));
  
  //choose last. may be modified to support -1:1, 2, 5 etc.
  list<Query>::iterator q = query.end();
  --q;
  
  list<d_Object*>::iterator qi = q->ans.begin();
  list<d_Object*>::iterator qe = q->ans.end();

  int cnt = 0;  
  if(l.empty()){
    int i = 0;
    while(qi != qe){
      l.push_back(++i);
      ++cnt;
      ++qi;
    }
  }
  else{
    cnt = l.size();
  }
  list<int> ::iterator li = l.begin();
  list<int> ::iterator le = l.end();

  if(om == PTR){
    outs << "+" << cnt << "\r\n";
    while(li != le){
      qi = q->ans.begin();
      cnt = 0;
      while(qi != qe && *li > cnt){
	if(*li == ++cnt){
	  outs << "!" << *li;
	  if(*li < 10)
	    outs << "  ";
	  else
	    outs << " ";
	  outs << (*qi)->persistentID() << "\r\n";
	}
	++qi;
      }
      ++li;
    }
    //    outs << "\r\n";
    return;
  }

  if(om == FULL){
    outs << "+" << cnt << "\r\n";
    while(li != le){
      qi = q->ans.begin();
      cnt = 0;
      while(qi != qe && *li > cnt){
	if(*li == ++cnt){
	  NameRecord *nr = &*(((NRnode*)(*qi))->namerecord);
	  outs << *nr << "\r\n";
	}
	++qi;
      }
      ++li;
    }
    //    outs << "\r\n";
    return;
  }

  while(li != le){
    qi = q->ans.begin();

    cnt = 0;
    while(qi != qe && *li > cnt){
      if(*li == ++cnt){
	NameRecord *nr = &*(((NRnode*)(*qi))->namerecord);
	outs << "!" << *li;
	if(*li < 10)
	  outs << "  ";
	else
	  outs << " ";
	outs << nr->group() << " ";
	if(nr->group() == string("species"))
	  outs << nr->generic() << " ";
	outs << nr->specific() << " "
	     << nr->authorityStr() << " "
	     << nr->recorderStr() << "\r\n";
	//	      Publication *p = nr->recorder()->publication()->ptr();
	
	Citation *c = nr->recorder().ptr();
	if(c->appearance().length()){
	  outs << "!     as " << c->appearance() << "\r\n";
	}
	Publication *p = nr->recorder()->publication().ptr();
	if(NULL == p){
	  string str(c->persistentID());
	  const char *ptr = str.data();
	  register const char *end = ptr + str.length();
	  register const char* pt = ptr;
	  int colons = 0;
	  while(pt < end && colons < 4){
	    if(*++pt == ':')
	      colons ++;
	  }
	  p = new Publication(string(str, ptr - str.data()));
	}
	outs << "!     in " 
	     << p->authors();
	int y = p->year();
	if(y != Date::invalidYear)
	  outs << " (" << y << ") ";
	else
	  outs << "; ";
	string s(p->title());
	if(s.length()){
	  outs << s;
	  string::iterator last = s.end();
	  --last;
	  if('.' != *last)
	    outs << ".";
	}
	
	s = p->volume();
	if(s.length()){
	  outs << " " << s;
	  if(0 != p->number().length())
	    outs << "(" << p->number() << ")";
	  if(0 != (y = p->from())){
	    outs << ":";
	    outs << y;
	    y = p->to();
	    if(y)
	      outs << "-" << y;
	  }
	  //	  if(0 != (y = nr->recorder()->page()))
	  //outs << " (" << y << ")";
	  string pg = nr->recorder()->page();
	  if(pg.length() != 0)
	    outs << " (" << pg << ")";
	  outs << ".";
	}
	outs << "\r\n";

	if(NULL == nr->recorder()->publication().ptr())
	  delete p;
      }
      ++qi;
    }
    ++li;
  }
}  

list <d_Object*> select (ostream & outs, const char* s, list<Query> &query, int seq, queries_out &output)
{
  const char *tail = s + strlen(s);
  while(s < tail && !isspace(*s)){s++;}
  while(s < tail && isspace(*s)){s++;}
  list <d_Object*> ret;
  if(strlen(s) == 0 || (!isdigit(*s) && !isdigit(*(s+1))))
    return ret;

  int qn = atoi(s);
  int cnt = 0;
  list<Query>::iterator qi = query.begin();
  list<Query>::iterator qe = query.end();
  if (qn < 1)
    qn = seq + qn - 2;

  while(qi != qe/* && qn > cnt*/){
    if(qn == ++cnt){
      outs << "%" << qi->q << "\r\n";
      output.outputfunction(outs, qi->ans);
      break;  //without break, it results in segF.  why?
    }
    ++qi;
  }
  return qi->ans; //ret;
}

list<d_Object*> history(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<NRnode*> _ret;
  list<d_Object*> ret;
  if(res.empty())
    outs << "-no record found for " << s << "\r\n";
  else{
    list<NRnode*> cur;
    res.sort();
    res.unique();
    res.sort(NRnode::gt());
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    hash_map<string, NRnode*, Hash<string> > h;
    register list<NRnode*>::iterator ri;
    register list<NRnode*>::iterator re;
    while(iter != end){
      list<NRnode*> r(navigate(*iter));
      r.unique();
      ri = r.begin();
      re = r.end();
      while(ri != re){
	_ret = current(*ri);
	register list<NRnode*>::iterator ci = _ret.begin();
	register list<NRnode*>::iterator ce = _ret.end();
	while(ci != ce){
	  cur.push_back(*ci);
	  ++ci;
	}
	++ri;
      }
      ++iter;
    }
    cur.sort();
    cur.unique();
    _ret.clear();

    iter = cur.begin();
    end = cur.end();
    while(iter != end){
      res = navigate(*iter);
      ri = res.begin();
      re = res.end();
      while(ri != re){
	_ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }
    _ret.sort();
    _ret.unique();
    _ret.sort(NRnode::gt());
    iter = _ret.begin();
    end  = _ret.end();
    cnt = 0;
    while(iter != end){
      ret.push_back(*iter);
      cnt++;++iter;
    };
    //    ret.unique();
    if(output.om == TEXT)
      outs << "+" << cnt << " record" << (1==cnt?"":"s") << " navigated from " << s << "\r\n";
    output.outputfunction(outs, ret);
    //outs << ret;
    
  }
  return ret;
}

list <d_Object*> thread(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;
  list<NRnode*> _ret;
  if(res.empty())
    outs << "-no record found for " << s << "\r\n";
  else{
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    set<NRnode*> source;
    while(iter != end){
      source.insert(*iter);
      ++iter;
    }
    set<NRnode*>::iterator si = source.begin();
    set<NRnode*>::iterator se = source.end();
    while(si != se){
      list<NRnode*> current(current(*si));
      list<NRnode*>::iterator ci = current.begin();
      list<NRnode*>::iterator ce = current.end();
      while(ci != ce){
	//	outs << (*ci)->namerecord->persistentID() << "\r\n";
	list<NRnode*> disp(navigate(*ci));
	outs << disp << "\r\n";;
	
	_ret.merge(disp);

	++ci;
      }
      ++si;
    }
    iter = _ret.begin();
    end  = _ret.end();
    while(iter != end){
      ret.push_back(*iter);
      ++iter;
    }
  }
  return ret;
}

list <d_Object*> genus(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)  
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->specific(s));
  list<d_Object*> ret;
  if(res.empty())
    outs << "-no record found for " << s << "\r\n";
  else{
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    string g("genus");
    while(iter != end){
      cnt++;
      list<NRnode*> r(navigate(*iter));
      register list<NRnode*>::iterator ri = r.begin();
      register list<NRnode*>::iterator re = r.end();
      while(ri != re){
	if((*ri)->namerecord->group() == g)
	  ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }
    //    outs << ret;
    output.outputfunction(outs, ret);
  }
  return ret;
}

list <d_Object*>  synonyms(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<NRnode*> _ret;
  list<d_Object*> ret;

  if(res.empty())
    outs << "-no record found for " << s << "\r\n";
  else{
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    while(iter != end){
      cnt++;
      list<NRnode*> r(synonymize(*iter));
      register list<NRnode*>::iterator ri = r.begin();
      register list<NRnode*>::iterator re = r.end();
      while(ri != re){
	_ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }

    _ret.sort();
    _ret.unique();

    iter = _ret.begin();
    end  = _ret.end();
    cnt = 0;
    while(iter != end){
      ret.push_back(*iter);
      cnt++;++iter;
    };
    outs << "+" << cnt << " synonym" << (1==cnt?"":"s") << " found for " << s << ":\r\n";
    
    //    outs << ret;
    output.outputfunction(outs, ret);
  }
  return ret;
}

list <d_Object*> species(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;
  if(res.empty())
    outs << "-no record found for " << s << "\r\n";
  else{
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    string grp("species");
    while(iter != end){
      cnt++;
      list<NRnode*> r(navigate(*iter));
      register list<NRnode*>::iterator ri = r.begin();
      register list<NRnode*>::iterator re = r.end();
      while(ri != re){
	if((*ri)->namerecord->group() == grp)
	  ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }
    //    outs << ret;
    output.outputfunction(outs, ret);
  }
  return ret;
}

list<d_Object*> origin(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  
  list<NRnode*> res(nomencurator->query(s));
  list<NRnode*> _ret;
  list<d_Object*> ret;
  
  if(res.empty())
    outs << "%no record found for " << s << "\r\n";
  else{
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    while(iter != end){
      cnt++;
      list<NRnode*> r(origine(*iter));
      register list<NRnode*>::iterator ri = r.begin();
      register list<NRnode*>::iterator re = r.end();
      while(ri != re){
	_ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }
    _ret.sort();
    _ret.unique();

    list<NRnode*>::iterator i = _ret.begin();
    list<NRnode*>::iterator e = _ret.end();
    cnt = 0;
    while(i != e){
      ret.push_back(*i);
      cnt++;
      ++i;
    };
    outs << "+" << cnt << " origin" << (1==cnt?"":"s") << " found for " << s << ":\r\n";
    
    output.outputfunction(outs, ret);
  }

  return ret;
}

list <d_Object*> revisions(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  
  list<NRnode*> res(nomencurator->query(s));
  
  list<NRnode*> _ret;
  list<d_Object*> ret;

  if(res.empty())
    outs << "%no record found for " << s << "\r\n";
  else{
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    while(iter != end){
      cnt++;
      list<NRnode*> r(revise(*iter));
      register list<NRnode*>::iterator ri = r.begin();
      register list<NRnode*>::iterator re = r.end();
      while(ri != re){
	_ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }
    _ret.sort();
    _ret.unique();

    list<NRnode*>::iterator i = _ret.begin();
    list<NRnode*>::iterator e = _ret.end();
    cnt = 0;
    while(i != e){
      ret.push_back(*i);
      cnt++;
      ++i;
    };

    outs << "+" << cnt << " record" << (1==cnt?" is":"s are") << " revision"<< (1==cnt?"":"s") << " of " << s << "\r\n";
    output.outputfunction(outs, ret);

  }

  return ret;

}

list <d_Object*> currents(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;
  list<NRnode*> _ret;
  
  if(res.empty())
    outs << "%no record found for " << s << "\r\n";
  else{
    res.sort();
    res.unique();
    list<NRnode*>::iterator iter = res.begin();
    list<NRnode*>::iterator end = res.end();
    int cnt = 0;
    while(iter != end){
      cnt++;
      list<NRnode*> r(current(*iter));
      r.sort();
      r.unique();
      register list<NRnode*>::iterator ri = r.begin();
      register list<NRnode*>::iterator re = r.end();
      while(ri != re){
	_ret.push_back(*ri);
	++ri;
      }
      ++iter;
    }

    _ret.sort();
    _ret.unique();
    
    iter = _ret.begin();
    end = _ret.end();
    cnt = 0;
    while(iter != end){
      ret.push_back(*iter);
      cnt++;
      ++iter;
    };
    outs << "+" << cnt << " current name" << (1==cnt?"":"s") << " for " << s << (1==cnt?" is":" are") << ":\r\n";
    
    //    outs << ret;
    output.outputfunction(outs, ret);
  }

  return ret;
}  



void set_out(ostream & outs, const char* s, list<Query>& query, queries_out &output)
{
  while(*s && !isspace(*s)){s++;}
  while(*s && isspace(*s)){s++;}
  if(0 == *s){
    outs << "+" << (output.om==TEXT?"TEXT":(output.om == PTR?"PTR":"RAW")) << "\r\n";
    return;
  }

  bool ack = false;

  if(!strncmp(s, "ptr", 3) || !strncmp(s, "PTR", 3)){
    output.om = PTR;
    //    output.outputfunction = ptrNameRecord;
    output.outputfunction = ptrNamedObject;
    output._NameRecordMinorExtract = _NameRecordPtr;
    output._NameRecordExtract = _NameRecordPtr;
    ack = true;
  }

  else if(!strncasecmp(s, "txt", 3) || !strncasecmp(s, "text", 4)){
    output.om = TEXT;
    output.outputfunction = textNameRecord;
    output._NameRecordMinorExtract = _NameRecordMinorText;
    output._NameRecordExtract = _NameRecordText;
    ack = true;
  }

  else if(!strncmp(s, "raw", 3) || !strncmp(s, "RAW", 3)){
    output.om = FULL;
    output.outputfunction = rawOutput;
    ack = true;
  }


  if(ack)
    outs << "+ACK";
  else
    outs << "-DNY";
  outs << " " << (output.om==TEXT?"TEXT":(output.om == PTR?"PTR":"RAW")) << "\r\n";
}  

int _lowerCnt = 0;

static list<d_Object*> subtree(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;
  if(res.empty()){
    outs << "-no record found for " << s << "\r\n";
    return ret;
  }
  
  int indent = 0;
  list<NRnode*>::iterator iter = res.begin();
  list<NRnode*>::iterator end = res.end();

  int cnt = 0;
  hash_map<string, NRnode*, Hash<string> > h;
  list<NRnode*> _ret;
  while(iter != end){
    //    _ret.merge(_lower(outs, s, nomencurator, seq, indent, *iter, cnt, output));
    list<NRnode*> tmp(_lower(outs, s, nomencurator, seq, indent, *iter, cnt, output));
    _ret.merge(tmp);
    ++iter;
    outs << "\r\n";
  }

  list<NRnode*>::iterator i = _ret.begin();
  list<NRnode*>::iterator e = _ret.end();
  while(i != e){
    ret.push_back(*i);
    i++;
  }

  return ret;
}

static list<d_Object*> hierarchy(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;

  if(res.empty()){
    outs << "-no record found for " << s << "\r\n";
    return ret;
  }

  res.sort(NRnode::gt());
  res.unique();
  
  int indent = 0;
  list<NRnode*>::iterator iter = res.begin();
  list<NRnode*>::iterator end = res.end();
  set<NRnode*> top;
  while(iter != end){
    top.insert((*iter)->top());
    iter++;
  }
  res.clear();
  set<NRnode*>::iterator titer = top.begin();
  set<NRnode*>::iterator tend = top.end();
  while(titer != tend){
    res.push_back(*titer);
    titer++;
  }

  res.sort(NRnode::gt());
  res.unique();
  iter = res.begin();
  end = res.end();
  int cnt = 0;

  hash_map<string, NRnode*, Hash<string> > h;
  list<NRnode*> _ret;

  while(iter != end){
    NameRecord* nrptr = (*iter)->namerecord.ptr();
    outs << "+in: " << publication(nrptr, output.om)<<"\r\n";
    //    _ret.merge(_lower(outs, s, nomencurator, seq, indent, *iter, cnt, output));
    list<NRnode*> tmp(_lower(outs, s, nomencurator, seq, indent, *iter, cnt, output));
    _ret.merge(tmp);
    ++iter;
    outs << "\r\n";
  }

  list<NRnode*>::iterator i = _ret.begin();
  list<NRnode*>::iterator e = _ret.end();
  while(i != e){
    ret.push_back(*i);
    i++;
  }

  return ret;
}


static string _NameRecordPtr(const NRnode *nrn)
{ return nrn->persistentID(); }

static string _NameRecordText(const NRnode *nrn)
{
  NameRecord *nr = nrn->namerecord.ptr();
  string s("");
  s += nr->group();
  s += " ";

  if(0 != nr->generic().length())
      s += nr->generic();
  else
      s += "[]";
  s += " ";

  s += nr->specific();
  s += " ";

  s += nr->authorityStr();
  s += " ";

  s += nr->recorderStr();
  return s;
}

static string _NameRecordMinorText(const NRnode *nrn)
{
  NameRecord *nr = nrn->namerecord.ptr();
  string s("");
  s += nr->group();
  s += " ";

  bool lowerOnly = true;
  string specific(nr->specific());
  register const char* p = specific.data();
  register const char* q = p + specific.length() - 1;
  while(p < q){if(!islower(*p++)) lowerOnly = false;}

  if((s == "species " || s == "variety " || lowerOnly) 
     && 0 != nr->generic().length()){
    s += nr->generic();
    s += " ";
  }

  s += specific;

  if(nr->authorityStr().length() > 1){
    s += " ";
    s += nr->authorityStr();
  }
#if 0
  s += " ";
  s += nr->recorderStr();
#endif

  return s;
}

list<NRnode*> _lower(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, int indent, NRnode* seed, int &cnt, queries_out &output, bool toOut)
{
  list<NRnode*> res;
  list<NRnode*> ret;
  if(NULL == seed)
    return ret;
  indent++;
  ++cnt;
  
  if(toOut){
    outs << "#";
    outs << cnt;
    
    for (int i = 0; i < indent; i++)
      outs << "     ";//"\t"
    outs << output._NameRecordMinorExtract(seed) << "\r\n";  
  }
  ret.push_back(seed);

  list<d_Ref<NRnode> >::iterator iter = seed->lower.begin();
  list<d_Ref<NRnode> >::iterator end  = seed->lower.end();

  while(iter != end){
    //ret.merge(_lower(outs, s, nomencurator, seq, indent, iter->ptr(), cnt, output, toOut));
    list<NRnode*> tmp(_lower(outs, s, nomencurator, seq, indent, iter->ptr(), cnt, output, toOut));
    ret.merge(tmp);
    ++iter;
  }
  /*
  list<NRnode*>::iterator i = res.begin();
  list<NRnode*>::iterator e = res.end();
  while(i != e){
    ret.push_back(*i);
    i++;
  }
  */
  return ret;
}


static list<d_Object*> higher(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;
  if(res.empty()){
    outs << "-no record found for " << s << "\r\n";
    return ret;
  }
  

  res.sort(NRnode::gt());
  res.unique();

  int cnt = 0;

  list<NRnode*>::iterator iter = res.begin();
  list<NRnode*>::iterator end = res.end();
  while(iter != end){
    NRnode *pnrn = (*iter)->higher.ptr();
    if(NULL != pnrn){
      outs << "+in: " << publication(pnrn, output.om)<<"\r\n";
      ret.push_back(pnrn);
      outs << "#";
      outs << ++cnt;
      outs << "\t";
      outs << output._NameRecordMinorExtract(pnrn) << "\r\n";  
    }
    ++iter;
  }
  return ret;
}

static list<d_Object*> lower(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<NRnode*> res(nomencurator->query(s));
  list<d_Object*> ret;
  if(res.empty()){
    outs << "-no record found for " << s << "\r\n";
    return ret;
  }
  
  res.sort(NRnode::gt());
  res.unique();

  int cnt = 0;

  list<NRnode*>::iterator iter = res.begin();
  list<NRnode*>::iterator end = res.end();

  while(iter != end){
    if(!(*iter)->lower.empty()){
      outs << "+in: " << publication(*iter, output.om)<<"\r\n";

      list<d_Ref<NRnode> >::iterator diter = (*iter)->lower.begin();
      list<d_Ref<NRnode> >::iterator dend = (*iter)->lower.end();
      while(diter != dend){
	ret.push_back((*diter).ptr());
	outs << "#";
	outs << ++cnt;
	outs << "\t";
	outs << output._NameRecordMinorExtract((*diter).ptr()) << "\r\n";  
	++diter;
      }
      outs << "\r\n";  
    }
    ++iter;
  }
  return ret;
}

static list<d_Object*> author(ostream & outs, const char* s, Nomencurator* nomencurator, int seq, queries_out &output)
{
  while(!isspace(*s)){s++;}
  while(isspace(*s)){s++;}
  list<Author*> res(nomencurator->author(s));
  list<d_Object*> ret;
  if(res.empty()){
    outs << "-no record found for " << s << "\r\n";
    return ret;
  }

  res.sort();
  res.unique();

  int cnt = 0;

  list<Author*>::iterator iter = res.begin();
  list<Author*>::iterator end = res.end();

  while(iter != end){
    ret.push_back(*iter);
    ++cnt;
    ++iter;
  }

  if(output.om != TEXT)
    output.outputfunction(outs, ret);
  else {
    outs << "+" << cnt << " author" << (1==cnt?"":"s") << " found for " << s << ":\r\n";
    textAuthor(outs, ret);
  }

  return ret;

}

#if 1
string publication(NRnode* nrn, outputMode om)
{ 
  if(om == PTR)
    return _publicationInPtr(nrn);
  else
    return _publicationInText(nrn);
}

string publication(NameRecord* nrptr, outputMode om)
{
  if(om == PTR)
    return _publicationInPtr(nrptr);
  else
    return _publicationInText(nrptr);
}

string publication(Citation* cptr, outputMode om)
{
  if(om == PTR)
    return _publicationInPtr(cptr);
  else
    return _publicationInText(cptr);
}

string publication(Publication* pubptr, outputMode om)
{
  if(om == PTR)
    return _publicationInPtr(pubptr);
  else
    return _publicationInText(pubptr);
}
#endif

#if 1
string _publicationInText(NRnode* nrn)
{
  if(NULL == nrn)
    return string("");

  return _publicationInText(nrn->namerecord.ptr());
}

string _publicationInPtr(NRnode* nrn)
{
  if(NULL == nrn)
    return string("");

  return _publicationInPtr(nrn->namerecord.ptr());
}

string _publicationInText(NameRecord* nrptr)
{
  string ret("");
  if(NULL == nrptr)
    return ret;

  Citation* cptr = nrptr->recorder().ptr();
  if(NULL != cptr)
    return _publicationInText(cptr);

  string s(nrptr->recorderStr());
  //  register const char *p = s.data();
  register int p = 0;
  //  const char *q = p + s.length();
  const int q = s.length();
  //  while(p < q && *p != '_') p++;
  while(p < q && s[p] != '_') p++;

  ret += string(s, 0, p - 1);
  p++;
  ret += " ";
  ret += string(s, p, q - p);

  return ret;  
}

string _publicationInPtr(NameRecord* nrptr)
{
  string ret("");
  if(NULL == nrptr)
    return ret;

  Citation* cptr = nrptr->recorder().ptr();
  if(NULL != cptr)
    return _publicationInPtr(cptr);
  
  string s(nrptr->persistentID());
  register const char *p = s.data();
  const char *q = p + s.length();
  if(p == q)
    return ret;

  //skip until group
  while(p < q && *p != '_') p++;
  p++;

  //skip major
  while(p < q && *p != '_') p++;
  p++;

  //skip minor
  while(p < q && *p != '_') p++;
  p++;

  //skip page
  while(p < q && *q != '_') q--;

  ret += "Publication::";
  ret += string(p, q - p);

  return ret;  
}

string _publicationInText(Citation* cptr)
{
  Publication *pubptr = cptr->publication().ptr();
  if(NULL != pubptr)
    return _publicationInText(pubptr);

  string ret("");

  //  string s(cptr->persistentID());
  //  register const char *p = s.data();
  //  register const char *q = p + s.length();
  char* s = strdup(cptr->persistentID().c_str());
  register const char *p = s;
  register const char *q = p + strlen(s);
  while(p < q && strncmp(p - 14, "_Publication::", 14)) ++p;
  const char *head = p;
  while(p < q && *p != '_') {p++;}

  //Authors
  ret += string(head,  p - head);

  head = ++p;
  while(p < q && *p != '_') {p++;}

  //year
  ret += " ";
  ret += string(head,  p - head);

  head = ++p;
  while(p < q && *p != '_') {p++;}

  //title
  ret += ", ";
  ret += string(head,  p - head);
  ret += ". ";

  head = ++p;
  while(p < q && *p != '_') {p++;}

  //volume
  if(*(p+1) != '_')
    ret += string(head,  p - head);

  head = ++p;
  while(p < q && *p != '_') {p++;}

  //number
  if(*(p+1) != '_'){
    ret += "(";
    ret += string(head,  p - head);
    ret += ")";
  }

  head = ++p;
  while(p < q && *p != '_') {p++;}

  //page
  if(*(p+1) != '_'){
    int from = atoi(string(head,  p - head).c_str());
    int to = from;
    head = ++p;
    while(p < q && *p != '_') {p++;}
    //page
    if(*(p+1) != '_'){
      to = atoi(string(head,  p - head).c_str());
    }
    if(from){
      ret += ": ";
      char f[10];
      sprintf(f, "%d", from);
      ret+= f;
      if(to != from && to != 0){
	ret += "-";
	sprintf(f, "%d", to);
	ret+= f;
      }
    }
  }
  ret += ".";

  delete [] s;
  return ret;
}

string _publicationInPtr(Citation* cptr)
{
  return cptr->publication().persistentID();
}

string _publicationInPtr(Publication* pubptr)
{
  return pubptr->persistentID();
}


string _publicationInText(Publication* pubptr)
{
  string ret("");
  if(NULL == pubptr)
    return ret;

  if(pubptr->authorlist.empty()){
    string s(pubptr->authorWithYear());
    register const char *p = s.data();
    const char *q = p + s.length();
    while(p < q && *p != '_') {p++;}
    ret += string(s, 0, p - s.data() - 1);
    p++;
    ret += " ";
    ret += string(s, p - s.data(), q - p);
    ret += ",";
  }
  else{
    list <d_Ref<Author> >::iterator authiter =  pubptr->authorlist.begin();
    list <d_Ref<Author> >::iterator authend  =  pubptr->authorlist.end();
    list <d_Ref<Author> >::iterator authand  =  authend;
    int authors = 0;
    while(authiter != authend) {
      ++authors;
      ++authiter;
    }
    if(authors > 1) --authand;
    
    authiter =  pubptr->authorlist.begin();
    authend  =  pubptr->authorlist.end();
    authors = 0;
    do{
      if(NULL != authiter->ptr())
	ret += (*authiter)->fullname();
      else{
	string s(authiter->persistentID());
	register const char *p = s.data();
	const char *q = p + s.length();
	while(p < q && *p != ':') p++;
	p++;
	p++;
	q = p;
	while(*q != '_') q++;
	ret += string(s, p - s.data(), q - p);
	if(*(q-1) != '.' && isspace(*(q-2)))
	  ret += ".";
      }
      ++authiter;
      if(authiter == authand && authend != authand)
	ret += " and ";
      else 
	ret += " ";

    }while(authiter != authend);

    int year = pubptr->year();
    if(year != 0){
      char f[10];
      sprintf(f, "%d", year);
      ret+= f;
    }
  }
  
  ret += ", ";
  ret += pubptr->title();
  ret += ". ";

  if(pubptr->volume().length()){
    ret += pubptr->volume();
    if(pubptr->number().length()){
      ret += "(";
      ret += pubptr->number();
      ret += ")";
    }

    if(pubptr->from()){
      ret += ": ";
      char f[10];
      sprintf(f, "%d", pubptr->from());
      ret+= f;
      if(pubptr->from()!= pubptr->to() && pubptr->to() != 0){
	ret += "-";
	sprintf(f, "%d", pubptr->to());
	ret+= f;
      }
    }
  }
  ret += ".";

  return ret;
}


#endif

bool commit(Nomencurator *nomen, Nomencurator *n){
  bool ret = nomen->merge(*n);
  n->clear();
  return ret;
}

bool append(istream & ins, Nomencurator *nomen)
{
  bool appendMode = true;
  Nomencurator n;

  hash_map<string, list<NameRecord*>, Hash<string> > nr;
  hash_map<string, list<Annotation*>, Hash<string> > an;
  hash_map<string, list<Citation*>, Hash<string> > ci;
  hash_map<string, list<Publication*>, Hash<string> > pub;
  hash_map<string, list<Author*>, Hash<string> > au;
  hash_map<string, list<NRnode*>, Hash<string> > nrn;
  hash_map<string, list<d_Ref<NameRecord>*>, Hash<string> > unr;
  hash_map<string, list<d_Ref<Annotation>*>, Hash<string> > uan;
  hash_map<string, list<d_Ref<Citation>*>, Hash<string> > uci;
  hash_map<string, list<d_Ref<Publication>*>, Hash<string> > upub;
  hash_map<string, list<d_Ref<Author>*>, Hash<string> > uau;
  hash_map<string, list<d_Ref<NRnode>*>, Hash<string> > unrn;

  bool appended = false;
  while(ins && appendMode){
      NamedField nf;
      ins >> nf;
      if(ins){
	const char* s = nf.entryName();
	if(0 == strlen(s))
	  break;
	if(!strcasecmp(s, "commit")){  //work?
	  appendMode = false;
	}
	else if(!strcmp(s, "NameRecord")){
	  NameRecord *p = new NameRecord(&nf);
	  n += p;
	  appended = true;
	}
	else if(!strcmp(s, "NRnode")){
	  n += new NRnode(&nf);
	  appended = true;
	}
	else if(!strcmp(s, "Citation")){
	  n += new Citation(&nf);
	  appended = true;
	}
	else if(!strcmp(s, "Publication")){
	  n +=  new Publication(&nf);
	  appended = true;
	}
	else if(!strcmp(s, "Author")){
	  n += new Author(&nf);
	  appended = true;
	}
	else{
	  const Annotation::annoTuple *t = Annotation::tuple;
	  bool notfound = true;
	  while(t->str && notfound){
	    if(!strncmp(s, t->str, t->n)){
	      n += new Annotation(nf, t->str);
	      appended = true;
	      notfound = false;
	      break;
	    }
	    ++t;
	  }
	  appendMode = !notfound;
	}
      }
  }
  if(appended){
    nomen->merge(n);
  }
  return appended;
}
